/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2005, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/arc.e,v 1.2 2005/01/15 00:23:22 william Exp $
 */

#ifndef _ARC_E_
#define _ARC_E_

extern int	arcDrawn;

#ifdef _INCLUDE_FROM_ARC_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_ARC_C_*/

extern void	PointsToArc ARGS_DECL((int xc, int yc, int x1, int y1,
		                       int x2, int y2, int dir, int int_degree,
		                       int *ltx, int *lty, int *w, int *h,
		                       int *angle1, int *angle2));
extern void	ArcRealX2Y2 ARGS_DECL((struct ArcRec *, int *X2, int *Y2));
extern void	GetArcArrowInfo ARGS_DECL((struct ObjRec *,
		                           IntPoint *tipvs1, IntPoint *tailvs1,
		                           IntPoint *vs1, int *a_angle1,
		                           IntPoint *tipvs2, IntPoint *tailvs2,
		                           IntPoint *vs2, int *a_angle2));
extern void	CalcArcOBBox ARGS_DECL((struct ObjRec *));
extern void	CalcArcBBox ARGS_DECL((struct ObjRec *, struct BBRec obbox,
		                       struct BBRec *bbox));
extern void	DumpArcObj ARGS_DECL((FILE *, struct ObjRec *));
extern int	NeedsToCacheArcObj ARGS_DECL((struct ObjRec *));
extern void	DrawArcObj ARGS_DECL((Window, int X, int Y, struct ObjRec *));
extern struct ObjRec	*CreateArcObj ARGS_DECL((int xc, int yc, int x1, int y1,
			                         int x2, int y2, int dir,
			                         int ltx, int lty, int w, int h,
			                         int angle1, int angle2,
			                         int CreateAbsolute));
extern void	DrawArc ARGS_DECL((XEvent *));
extern void	SaveArcObj ARGS_DECL((FILE *, struct ObjRec *));
extern void	ReadArcObj ARGS_DECL((FILE *, char *, struct ObjRec **));
extern void	SetArcPropMask ARGS_DECL((struct ObjRec *, long *plMask,
		                          long *plSkip,
		                          struct PropertiesRec *pProp));
extern void	FreeArcObj ARGS_DECL((struct ObjRec *));
extern void	MakePreciseArc ARGS_DECL((void));
extern void	PreciseRotateAnArc ARGS_DECL((void));

#ifdef _INCLUDE_FROM_ARC_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_ARC_C_*/

#endif /*_ARC_E_*/
