/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2003, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/edit.e,v 4.21 2003/02/25 01:17:39 william Exp $
 */

#ifndef _EDIT_E_
#define _EDIT_E_

extern struct SelRec *outerSelForFind;
extern struct SelRec *innerSelForFind;

#ifdef _INCLUDE_FROM_EDIT_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_EDIT_C_*/

extern void	CleanOuterInnerSelForFind ARGS_DECL((void));
extern void	CleanUpEdit ARGS_DECL((void));
extern void	InitEdit ARGS_DECL((void));
extern void	ConvertIntSpline ARGS_DECL((void));
extern void	ConvertToBezier ARGS_DECL((void));
extern int	SetBezierConvertNumSegsValue ARGS_DECL((char*));
extern void	SetBezierConvertNumSegs ARGS_DECL((char*));
extern void	ToggleSmoothHinge ARGS_DECL((void));
extern void	BreakUpText ARGS_DECL((void));
extern void	SetTextFillPatternColor ARGS_DECL((void));
extern void	MakeRegularPolygon ARGS_DECL((void));
extern void	DeletePoint ARGS_DECL((void));
extern void	AddPoint ARGS_DECL((void));
extern void	FlushUndoBuffer ARGS_DECL((void));
extern void	RestoreImageWH ARGS_DECL((void));
extern void	CutMaps ARGS_DECL((void));
extern void	BreakUpMaps ARGS_DECL((void));
extern void	LayoutOnArc ARGS_DECL((void));
extern void	PreciseRotate ARGS_DECL((void));
extern void	RotateAllSelObj ARGS_DECL((double degrees));
extern void	NoTransform ARGS_DECL((void));
extern void	SetEditTextSize ARGS_DECL((void));
extern void	FindCaseSensitive ARGS_DECL((void));
extern void	FindNoCase ARGS_DECL((void));
extern void	FindAgain ARGS_DECL((void));
extern int	RefreshEditMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateEditMenu ARGS_DECL((TgMenu*, int X, int Y, TgMenuInfo*,
		                           int status_str_xlated));
extern int	EditMenu ARGS_DECL((int X, int Y, int TrackMenubar));
extern void	FrontProc ARGS_DECL((void));
extern void	BackProc ARGS_DECL((void));
extern void	AlignObjsTop ARGS_DECL((void));
extern void	AlignObjsMiddle ARGS_DECL((void));
extern void	AlignObjsBottom ARGS_DECL((void));
extern void	AlignObjsLeft ARGS_DECL((void));
extern void	AlignObjsCenter ARGS_DECL((void));
extern void	AlignObjsRight ARGS_DECL((void));
extern void	AbutHorizontal ARGS_DECL((void));
extern void	AbutVertical ARGS_DECL((void));
extern void	RefreshArrangeMenu ARGS_DECL((TgMenu*));
extern int	ArrangeMenu ARGS_DECL((int X, int Y, int TrackMenubar));
extern int	RefreshPropertiesMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreatePropertiesMenu ARGS_DECL((TgMenu*, int X, int Y,
		                                 TgMenuInfo*,
		                                 int status_str_xlated));
extern int	PropertiesMenu ARGS_DECL((int X, int Y, int TrackMenubar));
extern void	UpdateSymbols ARGS_DECL((void));

extern void	SizeToWidest ARGS_DECL((void));
extern void	SizeToNarrowest ARGS_DECL((void));
extern void	SizeToTallest ARGS_DECL((void));
extern void	SizeToShortest ARGS_DECL((void));
extern void	SizeToGivenWidthHeight ARGS_DECL((void));
extern void	SizeToGivenWidth ARGS_DECL((void));
extern void	SizeToGivenHeight ARGS_DECL((void));

#ifdef _INCLUDE_FROM_EDIT_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_EDIT_C_*/

#endif /*_EDIT_E_*/
