/***************************************************************************
                             rminternals.h
                             -------------------
    begin                : May 2001
    copyright            : (C) 2001 by Jorge Allyson Azevedo
                                       Milena Scanferla
                                       Magnos Martinello
                                       Daniel Sadoc
    email                : {allyson,milena,magnos,sadoc}@land.ufrj.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RMINTERNALS_H
#define RMINTERNALS_H

#define NUM_TIMERS 5  /* number of timers used by the program */

#define RECEIVE             'R'
#define SEND                'S'
#define RECEIVE_AND_LOSE    'L'

#include "rmstruct.h"
#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/utsname.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "rmmsgpckt.h"
#include "rmevent.h"
#include "rmcache.h"
#include "rmmsg.h"

#define MAX_BUFFER 1000

#define FOREVER while(1)


void *rmcastHandleSignals(void *arg);

int   rmcastCreateSocket  (int port);

void  rmcastSetTTLValue   (int soc, int ttl);
void  rmcastSetLoopBack   (int soc, int loop);

void  rmcastJoinGroup     (int soc, char *group_addr);
void  rmcastLeaveGroup    (int soc, char *group_addr);

void  rmcastSendPacket	  (int soc, BYTE *message, int message_size);
void  *rmcastReceivePackets(void *soc);

void  rmcastCatchEvents   (int i);

/****************************************************************************************************/

/* Routines To Facilitate the Interface with the Event List and the Cache */

int rmcastRemoveEvent(PACKET_INFO *packt, int event_type);
int rmcastFindEvent(PACKET_INFO *packt, int event_type);
int rmcastCacheContains(PACKET_INFO *packt);
int rmcastInsertEvent(PACKET_INFO *packt, int event_type);
void rmcastProcessDataPacket(PACKET_INFO pckt_info);
void rmcastProcessRefreshPacket(PACKET_INFO pckt_info);
double generate_uniform(void);

void lock_eventlist_and_cache();
void unlock_eventlist_and_cache();

void showLogMsg(char type, PACKET_INFO *pckt_info);

/****************************************************************************************************/

struct SGLOBAL_OPTIONS
{

    int        *pipe; 
    char       tcp_ip[MAX_IP_STRING_SIZE];
    int        tcp_port;
    void       (*shut_down_routine)(void); 
    int        cur_state_server_is_up;
    char       dest_ip[16]; /* this is the destination ip used in the connection to the multicast group (or unicast destination host) */
    int        dest_port;
    int        ttl;
    int        microsleep;
    double     avg_delay;
    int        version;
    int        transmission_mode;
    char       log_file[255];
    int        new_user_support;
    int        statistics;
    int        refresh_timer;
    float      loss_prob;

};

typedef struct SGLOBAL_OPTIONS GLOBAL_OPTIONS;

/****************************************************************************************************/

struct SUSER_INFO
{
	struct TIMER
	{
		int min,max;
	} timer[NUM_TIMERS];
	
	struct GROUP_ID
	{
		char ip[MAX_IP_STRING_SIZE]; /* ip address and... */
		int port;    /* port of the group  */
	} group_id;
	
	MEMBER_ID member_id;
	
	int cache_size;
	
	int sn;
	
	int socket;
	
};

typedef struct SUSER_INFO USER_INFO;

/****************************************************************************************************/





#endif    
