/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2001, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/xbitmap.e,v 4.24 2001/08/06 21:39:37 william Exp $
 */

#ifndef _XBITMAP_E_
#define _XBITMAP_E_

extern GC	xbmGC;
extern int	askForXBmSpec;
extern int	stripEPSComments;
extern int	saveEPSLines;
extern int	leftExportPixelTrim;
extern int	topExportPixelTrim;
extern int	rightExportPixelTrim;
extern int	bottomExportPixelTrim;
extern Pixmap	dummyBitmap;
extern char	gszHhtmlExportTemplate[MAXPATHLENGTH];

#ifdef _INCLUDE_FROM_XBITMAP_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_XBITMAP_C_*/

extern void	SetHtmlExportTemplate ARGS_DECL((void));
extern int	ReadHtmlExportTemplate ARGS_DECL((char *buf));
extern void	SetExportPixelTrim ARGS_DECL((int cur_val_is_too_large));
extern int	GetXpmOutputVersion ARGS_DECL((void));
extern void	SetXpmOutputVersion ARGS_DECL((int));
extern void	InitXBm ARGS_DECL((void));
extern void	ExportHalfToneBitmap ARGS_DECL((void));
extern void	ExportThresholdBitmap ARGS_DECL((void));
extern void	SetExportBitmapThreshold ARGS_DECL((char*));
extern int	RefreshBitPixmapMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateBitPixmapMenu ARGS_DECL((TgMenu*, int X, int Y,
                                                TgMenuInfo*,
                                                int status_str_xlated));
extern void	CleanUpXBm ARGS_DECL((void));
extern void	CalcTransform ARGS_DECL((struct MtrxRec *));
extern void	MakeCachedBitmap ARGS_DECL((struct ObjRec *));
extern int	ExtractBitmap ARGS_DECL((Pixmap OrigBitmap, XImage *OrigImage,
		                         int X, int Y, int W, int H,
		                         Pixmap *Bitmap, XImage **Image));
extern int	AutoTrimBitmap ARGS_DECL((Pixmap OrigBitmap, int *pnImageW,
		                          int *pnImageH, Pixmap *Bitmap,
		                          XImage **Image, int *pnEmptyImage,
		                          int *pnDontFreeOrigBitmap));
extern void	InvertXBitmaps ARGS_DECL((void));
extern void	ParseCutSpec ARGS_DECL((char *Spec, int ImageW, int ImageH,
		                        float *Mag, int *SrcX, int *SrcY,
		                        int *SrcW, int *SrcH));
extern void	CutXBitmap ARGS_DECL((void));
extern void	GenPreviewBitmap ARGS_DECL((FILE *, int llxPage, int llyPage,
		                            int urxPage, int uryPage));
extern void	GetRealBaseName ARGS_DECL((char *fname));
extern void	DumpXBitmapFile ARGS_DECL((int nInImageProc,
		                           int nPageNumInFileName));
extern int	DumpXImageToFile ARGS_DECL((XImage*, int W, int H, char*));
extern void	ExportXPixmapDeckToGIF ARGS_DECL((void));
extern void	DumpBitmap ARGS_DECL((FILE*, XImage*, char*, int ImageW,
		                      int ImageH, int Transformed, int OrigX,
		                      int OrigY, int AdjX, struct MtrxRec *,
		                      int Indent));
extern void	DumpXBmObj ARGS_DECL((FILE*, struct ObjRec *));
extern int	NeedsToCacheXBmObj ARGS_DECL((struct ObjRec *));
extern void	DrawXBmObj ARGS_DECL((Window, int XOff, int YOff,
		                      struct ObjRec *));
extern struct ObjRec	* CreateXBmObj ARGS_DECL((int ImageW, int ImageH, int W,
			                          int H, Pixmap, XImage *));
extern void	BreakUpXBitmap ARGS_DECL((struct ObjRec *, int ColsAndRows,
		                          int W, int H));
extern void	DumpXBmData ARGS_DECL((FILE*, Pixmap bitmap, XImage**,
		                       int W, int H));
extern void	SaveXBmObj ARGS_DECL((FILE *, struct ObjRec *));
extern void	ReadXBmObj ARGS_DECL((FILE *, char *Inbuf, struct ObjRec **));
extern void	SetXBmPropMask ARGS_DECL((struct ObjRec *, long *plMask,
		                          long *plSkip,
		                          struct PropertiesRec *pProp));
extern void	FreeXBmObj ARGS_DECL((struct ObjRec *));

#ifdef _INCLUDE_FROM_XBITMAP_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_XBITMAP_C_*/

#endif /*_XBITMAP_E_*/
