/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2001, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/scroll.e,v 4.13 2001/08/06 21:39:32 william Exp $
 */

#ifndef _SCROLL_E_
#define _SCROLL_E_

extern int	autoPan;

extern int	scrollingCanvas;
extern int	smoothScrollingCanvas;

extern int	resetOriginOnAdvancePage;

#ifdef _INCLUDE_FROM_SCROLL_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_SCROLL_C_*/

extern int	TgAnyButtonDown ARGS_DECL((Display*, Window));
extern int	TgPressButtonLoop ARGS_DECL((Display*, Window, struct BBRec *,
		                             ScrollBtnCallbackInfo*));
extern int	TgGetScrollHit ARGS_DECL((int x, int y, int orientation,
		                          int scroll_area_w, int scroll_area_h,
		                          double start_frac, int length,
		                          int total, int *pn_offset));
extern void	TgDrawScrollBar ARGS_DECL((Display*, Window, int orientation,
		                           int x_off, int y_off,
		                           int scroll_area_w, int scroll_area_h,
		                           double start_frac, int length,
		                           int total));
extern void	RedrawVScrollWindow ARGS_DECL((void));
extern void	RedrawHScrollWindow ARGS_DECL((void));
extern void	RedrawScrollBars ARGS_DECL((void));
extern void	GetMaxScrollOrigin ARGS_DECL((int *pn_orig_x, int *pn_orig_y));
extern void	ScrollTo ARGS_DECL((int XOff, int YOff));
extern void	ScrollUp ARGS_DECL((XButtonEvent *));
extern void	ForceScrollDown ARGS_DECL((int));
extern void	ScrollDown ARGS_DECL((XButtonEvent *));
extern void	ScrollLeft ARGS_DECL((XButtonEvent *));
extern void	ScrollRight ARGS_DECL((XButtonEvent *));
extern void	ScrollEventHandler ARGS_DECL((XEvent *));
extern void	ScrollToSpecifiedOrigin ARGS_DECL((int page_num, int orig_x,
		                                   int orig_y, int zoom_scale,
		                                   int zoomed_in));
extern int	ScrollToOrigin ARGS_DECL((void));
extern void	SaveOrigin ARGS_DECL((void));
extern void	SetOrigin ARGS_DECL((int x, int y, int zoom_scale,
		                     int zoomed_in));
extern void	GetOrigin ARGS_DECL((int *pn_x, int *pn_y, int *pn_zoom_scale,
		                     int *pn_zoomed_in));
extern void	CleanUpScrolls ARGS_DECL((void));
extern void	UpdScrollWinWH ARGS_DECL((void));
extern void	InitScroll ARGS_DECL((void));
extern void	ChangeScrollMode ARGS_DECL((int ModeIndex));
extern int	RefreshScrollModeMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateScrollModeMenu ARGS_DECL((TgMenu*, int X, int Y,
                                                 TgMenuInfo*,
                                                 int status_str_xlated));

#ifdef _INCLUDE_FROM_SCROLL_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_SCROLL_C_*/

#endif /*_SCROLL_E_*/
