/***************************************************************************
                             server.c
                             -------------------
    begin                : May 2001
    copyright            : (C) 2001 by Jorge Allyson Azevedo
                                       Milena Scanferla
                                       Magnos Martinello
                                       Daniel Sadoc
    email                : {allyson,milena,magnos,sadoc}@land.ufrj.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/******************************************************************************************************
 *																									  *
 * Reliable Multicast Protocol (server.c)															  *
 *																									  *
 * Example of usage of the Reliable Multicast Protocol.                                               *
 *																									  *
 * This program sends packets to the multicast group.			  									  *
 *																									  *
 * use tab spacing = 4																				  *
 *																									  *
 ******************************************************************************************************/

#include "rmcast.h"

#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h> 
#include <ctype.h>
#include <signal.h>


#define QPERM 0660
#define QKEY_BASE (key_t) 0105


#define BUFFSIZE 1000

void remove_queues(int i);

int main()
{

    int soc, port=5151;
    int nbytes /*, i */, j=0;
    char buffer[BUFFSIZE];
    
    
    fprintf(stderr,"Reliable multicast SERVER in action!\n");
    
    RM_initialize(0, "rmcastserver.log");
    
    soc =  RM_joinGroup ("224.1.1.1", port);
    
    
    while (1)
    {
         nbytes = RM_recv(soc, buffer, BUFFSIZE);
         
         /* fprintf(stderr,"%s",buffer); 
         
         for(i=0; i<nbytes; i++)
         {
            if (isalnum((int)buffer[i]))
            {
               fprintf(stderr,"%c ",buffer[i]);
            }
            else
            {
               fprintf(stderr,"\\%d ",buffer[i]);
            }
         }
         fprintf(stderr,"\n"); */
         fprintf(stderr,"%d\n",j);
         j++;
    }
    
    
    RM_leaveGroup(soc, "225.0.0.5");
    
       
    return 1;
}



