#!/usr/bin/perl
#
# Author:	Andrew P. Anselmo <anselmo@ERXSG.rl.plh.af.mil>
#		http://thermsa.eng.sunysb.edu/~anselmo/anselmo.html
#
# usage:	tgif-thumb.pl *.obj
#
# Thumbnail processing of the first sheet in a bunch of
# .obj files; put a bunch on a page
# use a formatted page already made using tgif, and put
# regular pages in those locations...
#
# get filenames 16 at a time; prepare for a tgif
# template...
#
# 1) Requires perl.
# 2) Requires tgif.
# 3) Requires pstoepsi.
# 4) The current directory must be writable.
# 5) You cannot have any files named temp001.obj, temp002.obj, ...,
#	temp016.obj in the current directory.
#
# If thumbnail1.ps is not generated, please scan through the printout,
#	there may be something the program can't find.
# Please ignore the following warning message:
#	"Warning:  EPS file 'temp???.eps' is newer than the EPS object."

# ---------------------- installation procedure ----------------------- #
#									#
# Copy MAIN_TEMPLATE.OBJ to a system directory,				#
#	e.g., /usr/lib/X11/tgif/tgif-thumb/MAIN_TEMPLATE.OBJ.		#
# Change $templatefname to the path where MAIN_TEMPLATE.OBJ is located,	#
#	e.g., /usr/lib/X11/tgif/tgif-thumb/MAIN_TEMPLATE.OBJ.		#
# If tgif is not in the path, change $tgif to where tgif is located.	#
# If pstoepsi is not in the path, change $pstoepsi to where pstoepsi is	#
#	located.							#
# The default output file name is thumbnail1.ps, etc.  If you don't	#
#	like the name, change $output.					#
#									#
$templatefname="MAIN_TEMPLATE.OBJ";
$tgif="tgif";
$pstoepsi="pstoepsi";
$tmpfname="__X__";
$subtmpfname="__x__";
$output="thumbnail";
#									#
# -------------------- end installation procedure --------------------- #


$icount=1;


while (@ARGV) {

	printf "Sheet %d started...\n",$icount;

# commands at start...
# copy template to a temporary file
	system "cp $templatefname $tmpfname.obj";

	for($i=1;$i<=16;$i++)
		{
    		$file = shift @ARGV;
		if($file eq "")
			{
			goto bailout;
			}

# commands to do...

# print the number and the file being worked on...
		printf "%s \n",$file;
# copy this file to a temporary filename
		system "cp $file $subtmpfname.obj";
# print it to a temporary file
		system "$tgif -print -ps -page 1 $subtmpfname.obj";
# convert it to an eps file
		system "$pstoepsi $subtmpfname.ps $subtmpfname.eps";

# convert number to a leading zero string
		$ii=&itoa2($i);
# create the root filename 'tempXXX', where XXX is the number of the file
		$tempfile="temp".$ii;

# move this file to a temporary NUMBERED filename
		system "mv $subtmpfname.eps $tempfile.eps";

# substitute name of file used in $tmpfname.obj w/real the real filename
		system "sed s/temp$ii.obj/$file/g $tmpfname.obj > ${tmpfname}_.obj";
		system "mv ${tmpfname}_.obj $tmpfname.obj";
		}

bailout:

# commnands at end...

# print the main sheet
	system "$tgif -print -ps -page 1 $tmpfname.obj";
# copy it to a proper name
	system "cp $tmpfname.ps $output$icount.ps";

# remove all old files
	for($i=1;$i<=16;$i++)
		{
		$ii=&itoa2($i);
		$tempfile="temp".$ii;
		system "rm -f $tempfile.eps";
		}
	system "nice rm -f $subtmpfname.obj $subtmpfname.ps";
	system "nice rm -f $tmpfname.obj $tmpfname.ps";

# tell all that we have printed the sheet
printf "Sheet %d ($output$icount.ps) completed...\n\n\n",$icount;

	$icount++;

}


# a function to convert and integer into a leading zero'd
# string
sub itoa2
	{
	$number=$_[0];
	$hundreds=int($number/100);
        $tens=int(($number-$hundreds*100)/10);
	$ones=int($number-$hundreds*100-$tens*10);
	$final=$hundreds.$tens.$ones;
	}
#
# EOF
#
