/*
 * @(#)$Header: /mm/src/tgif/v4/gspn2tgif/RCS/tgifintf.h,v 1.0 1999/02/11 15:38:37 william Exp $
 */

#ifndef _GSPN2TGIF_TGIFINTF_H_
#define _GSPN2TGIF_TGIFINTF_H_

#ifdef _INCLUDE_FROM_TGIFINTF_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_TGIFINTF_C_*/

extern void	CleanUpTgifInterface ARGS_DECL((void));
extern int	InitTgifInterface ARGS_DECL((void));

extern int	TgifAttr ARGS_DECL((
			float *x,
			float *baseline_y,
			char *font_name,
			int font_size,
			int center_justified, /* 1: center, 0: left justified */
			int visible,          /* 1: visible, 0: invisible */
			int name_visible,     /* 1: visible, 0: invisible */
			char *attr_name,      /* the last char must be '=' */
			char *attr_value));

extern int	TgifText ARGS_DECL((
			float *x,
			float *baseline_y,
			char *font_name,
			int font_size,
			char *buf));

extern int	TgifOval ARGS_DECL((
			float *ltx, float *lty, float *rbx, float *rby));
extern int	TgifMarkedOval ARGS_DECL((
			float *inside_ltx, float *inside_lty,
			float *inside_rbx, float *inside_rby,
			float *ltx, float *lty, float *rbx, float *rby));

extern int	TgifBox ARGS_DECL((
			float *ltx, float *lty, float *rbx, float *rby,
			int solid,    /* 1: filled, 0: hollow (timed) */
			int rotate)); /* 0: no rotate, +1: 45, -1: 135 */

extern int	TgifStartVertex ARGS_DECL((float *x, float *y));
extern int	TgifAddVertex ARGS_DECL((float *x, float *y));

extern int	TgifPoly ARGS_DECL((
			char *width_spec,
			char *arrow_width_spec,
			char *arrow_height_spec));
extern int	TgifSmooth ARGS_DECL((
			int head, /* 1: smooth near head, 0: smooth near tail */
			int horizontal, /* 1: horizontal, 0: vertical */
			int rotate)); /* 0: no rotate, +1: 45, -1: 135 */

extern int	TgifGenerate ARGS_DECL((FILE*));

#ifdef _INCLUDE_FROM_TGIFINTF_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_TGIFINTF_C_*/

#endif /*_GSPN2TGIF_TGIFINTF_H_*/
