/*
 * @(#)$Header: /mm/src/tgif/v4/gspn2tgif/RCS/gspn2tgif.c,v 1.0 1999/02/11 15:38:36 william Exp $
 */

#include "tgifdefs.h"

#include "tgifintf.h"

#ifdef MAXSTRING
#undef MAXSTRING
#endif /* MAXSTRING */

#define ALIGNED 5

#define INPUT 0
#define OUTPUT 1
#define INHIBITOR 2

#define MAX_RP 32
#define MAX_MP 32

#define MAXNAME 128
#define MAXSTRING 1024
#define MAX_PLACE 512
#define MAX_TRANSITION 512
#define MAX_DEF 512
#define PSTOTGIFPAGENR 1

#define PIXEL_IN_CM 60.0
#define diam 16.0
#define fontsize_TAG 10
#define fontsize_ARC 10

#define fonttype_TAG "Courier"
#define fonttype_ARC "Times-BoldItalic" 

static float xpr_off = -(diam);
static float ypr_off = (diam);

#define MIN(a,b) (a<=b)?a:b
#define ABS(a) (a>=0)?a:-a

static char *name_p = NULL;

static float r = diam/2;
static float rimm = diam/4;
static float di = diam/2;
static float ri = diam/4;
static float m,q;

static float pc[MAX_PLACE][4];
static float tc[MAX_TRANSITION][4];
static int rot[MAX_TRANSITION];
static int tim[MAX_TRANSITION];
static float intermediate_c[MAX_TRANSITION][2];

static float x_offset = 200.0;
static float y_offset = 200.0;
static float gf_x1,gf_y1,gf_x2,gf_y2;

static int np = 1;
static int nt = 1;
static int nintermediate = 0;
static char prs[MAXSTRING];

static char def[MAX_DEF][MAXSTRING];
static char name[MAX_DEF][MAXNAME];

static char cdef[MAX_DEF][MAXSTRING];
static char cname[MAX_DEF][MAXNAME];
static char mdef[MAX_DEF][MAXSTRING];
static char mname[MAX_DEF][MAXNAME];
static char ddef[MAX_DEF][MAXSTRING];
static char dname[MAX_DEF][MAXNAME];
static char fdef[MAX_DEF][MAXSTRING];
static char fname[MAX_DEF][MAXNAME];

static char rpname[MAX_RP][MAXNAME];
static char mpname[MAX_MP][MAXNAME];


static char rate_md[MAX_TRANSITION][MAXSTRING];
 
static int char_read;
static int int_val;
static float xcoord1,ycoord1;

static FILE * def_fp = NULL;
static FILE * in_fp = NULL;
static FILE * out_fp = NULL;

static    int intcompare(i,j)
float *i, *j;
{
return(i<=j);
}


/**************************************************************/
/* NAME : */
/* DESCRIPTION : */
/* PARAMETERS : */
/* RETURN VALUE : */
/**************************************************************/
FILE *efopen ( file, mode )
 char file[MAXSTRING],mode[5];
 {/* Init efopen */
  extern FILE *fopen();
  FILE *callptr;
 
  if ((callptr = fopen(file, mode)) == NULL)
   {/* Errore */
    fprintf(stdout,"Runtime Error: fopen couldn't open %s, in mode %s\n",file, mode );
    exit(1);
   }/* Errore */
  return(callptr);
 }/* End efopen */
/**************************************************************/
/* NAME : */
/* DESCRIPTION : */
/* PARAMETERS : */
/* RETURN VALUE : */
/**************************************************************/
void choose_transition_side(x1,y1,nt,xint,yint,type,xc,yc)
 float x1;
 float y1;
 int nt;
 float *xint;
 float *yint;
 int type;
 float *xc;
 float *yc;
 {
  float xt,yt;
  float edge = 0.0;
  float ray = r;

  if(type==INHIBITOR)
   edge = di;
  if(tim[nt])
   ray = rimm;

/**** AGGIUNGERE LA ROTAZIONE  di 45 e 135 GRADI *******/
  xt = tc[nt][0];
  yt = tc[nt][1];
  if(x1<=xt)
   {
    if(y1<=yt)
     {
      if(rot[nt]==0)
       {
        *xint = xt; 
        *yint = yt-ray/2-edge;
	*xc = *xint - ri;
	*yc = *yint;
       }
      else
       {
        *xint = xt-ray/2-edge;
        *yint = yt;
	*xc = *xint;
	*yc = *yint - ri;
       }
     }
    else
     {
      if(rot[nt]==0)
       {
        *xint = xt; 
        *yint = yt+ray/2+edge;
        *xc = *xint - ri;
        *yc = *yint - di;
       }
      else
       {
        *xint = xt-ray/2-edge;
        *yint = yt;
        *xc = *xint;
        *yc = *yint - ri;
       }
     }
   }
  else
   {
    if(y1<=yt)
     {
      if(rot[nt]==0)
       {
        *xint = xt; 
        *yint = yt-ray/2-edge;
	*xc = *xint - ri;
	*yc = *yint;
       }
      else
       {
        *xint = xt+ray/2+edge;
        *yint = yt;
	*xc = *xint - di;
	*yc = *yint - ri;
       }
     }
    else
     {
      if(rot[nt]==0)
       {
        *xint = xt; 
        *yint = yt+ray/2+edge;
        *xc = *xint - ri;
        *yc = *yint - di;
       }
      else
       {
        *xint = xt+ray/2+edge;
        *yint = yt;
	*xc = *xint -di;
	*yc = *yint - ri;
       }
     }
   }
 }
/**************************************************************/
/* NAME : */
/* DESCRIPTION : */
/* PARAMETERS : */
/* RETURN VALUE : */
/**************************************************************/
void get_transition_side(intermediate_points,pl,nt,xint,yint,type,xc,yc)
 int intermediate_points;
 int pl;
 int nt;
 float *xint;
 float *yint;
 int type;
 float *xc;
 float *yc;
 {
  float x1,y1;

  if(intermediate_points)
   {
    switch(type)
     {
      case INPUT:
                 x1 = intermediate_c[1][0];
                 y1 = intermediate_c[1][1];
		 break;
      case OUTPUT:
                 x1 = intermediate_c[1][0];
                 y1 = intermediate_c[1][1];
		 break;
      case INHIBITOR:
                 x1 = intermediate_c[1][0];
                 y1 = intermediate_c[1][1];
		 break;
     }
   }
  else
   {
    x1 = pc[pl][0]+r;
    y1 = pc[pl][1]+r;
   }
  choose_transition_side(x1,y1,nt,xint,yint,type,xc,yc);
 }
/**************************************************************/
/* NAME : */
/* DESCRIPTION : */
/* PARAMETERS : */
/* RETURN VALUE : */
/**************************************************************/
void get_arc_position(intermediate_points,pl,nt,xint,yint,type)
 int intermediate_points;
 int pl;
 int nt;
 float *xint;
 float *yint;
 int type;
 {
  float xint1,xint2;
  float xdummy,ydummy;
  float a,b,c,delta;

  gf_x1 = pc[pl][0]+r;
  gf_y1 = pc[pl][1]+r;
  if(intermediate_points)
   {
    switch(type)
     {
      case INPUT:
                 gf_x2 = intermediate_c[1][0];
                 gf_y2 = intermediate_c[1][1];
		 break;
      case OUTPUT:
                 gf_x2 = intermediate_c[intermediate_points][0];
                 gf_y2 = intermediate_c[intermediate_points][1];
		 break;
      case INHIBITOR:
                 gf_x2 = intermediate_c[1][0];
                 gf_y2 = intermediate_c[1][1];
		 break;
     }
   }
  else
   choose_transition_side(gf_x1,gf_y1,nt,&gf_x2,&gf_y2,type,&xdummy,&ydummy);
  *xint = (gf_x1<=gf_x2)?gf_x1:gf_x2;
  delta = gf_x2-gf_x1;
  delta = (delta>=0)?delta:-delta;
  *xint += delta/2;
  *yint = (gf_y1<=gf_y2)?gf_y1:gf_y2;
  delta = gf_y2-gf_y1;
  delta = (delta>=0)?delta:-delta;
  *yint += delta/2;
  
  
 }
/**************************************************************/
/* NAME : */
/* DESCRIPTION : */
/* PARAMETERS : */
/* RETURN VALUE : */
/**************************************************************/
void get_intersection(intermediate_points,pl,nt,xint,yint,type,xc,yc)
 int intermediate_points;
 int pl;
 int nt;
 float *xint;
 float *yint;
 int type;
 float *xc;
 float *yc;
 {
  float xint1,xint2;
  float a,b,c,delta;

  gf_x1 = pc[pl][0]+r;
  gf_y1 = pc[pl][1]+r;
  if(intermediate_points)
   {
    switch(type)
     {
      case INPUT:
                 gf_x2 = intermediate_c[intermediate_points][0];
                 gf_y2 = intermediate_c[intermediate_points][1];
		 break;
      case OUTPUT:
                 gf_x2 = intermediate_c[intermediate_points][0];
                 gf_y2 = intermediate_c[intermediate_points][1];
		 break;
      case INHIBITOR:
                 gf_x2 = intermediate_c[intermediate_points][0];
                 gf_y2 = intermediate_c[intermediate_points][1];
		 break;
     }
   }
  else
   choose_transition_side(gf_x1,gf_y1,nt,&gf_x2,&gf_y2,type,xc,yc);
  delta = (gf_x1>=gf_x2)?gf_x1-gf_x2:gf_x2-gf_x1;
  if(delta > ALIGNED)
   {
    m = (gf_y1 - gf_y2)/(gf_x1-gf_x2);
    q = gf_y1 - m * gf_x1;

    a = (1+m*m);
    b = (2*q*m-2*gf_x1-2*gf_y1*m);
    c = (gf_x1*gf_x1+q*q+gf_y1*gf_y1-2*gf_y1*q-r*r);
         
    xint1 = (-b + ((float)(sqrt((double)(b*b-4*a*c)))))/(2*a);
    xint2 = (-b - ((float)(sqrt((double)(b*b-4*a*c)))))/(2*a);
    if(gf_x2>=xint1 && gf_x2>=xint2)
     {
      *xint = (xint1>=xint2)?xint1:xint2;
      *yint = m * (*xint) + q;
     }
    else
     {
      *xint = (xint1<=xint2)?xint1:xint2;
      *yint = m * (*xint) + q;
     }
   }
  else
   {
    *xint = gf_x1;
    *yint = (gf_y2>=gf_y1)?gf_y1+r:gf_y1-r;
   }
 }
/**************************************************************/
/* NAME : */
/* DESCRIPTION : */
/* PARAMETERS : */
/* RETURN VALUE : */
/**************************************************************/
int main(argc,argv)
 int argc;
 char *argv[];
 {/* Init greatspntoobj */ 
  int el[10];
  char tmp[MAXSTRING];
  char trash[MAXSTRING];
  char read_name[MAXSTRING];
  char type;
  int int_val1,int_val2,int_val3,int_val4;
  int place,nint;
  int nin,nout,ninh;
  int item_arc,item_skip,item;
  int rte;
  double float_val;
 


  float magnification = 1.0;

  float xtable;
  float ytable;

  float xcoord2,ycoord2;
  float xcoord3,ycoord3;

  float xint,yint;
  float xt,yt;
  float xc,yc;
  float xdummy,ydummy;

  int first_TIMED = 1;
  int first_IMMEDIATE = 0;
  int def_ind = 1;
  int tr;
  char ctype,ctrash;

  float xclass,xfunc,xdyn,xmark;
  float yclass,yfunc,ydyn,ymark;

  int class,func,dyn,mark;

  char buf[MAXSTRING], buf1[MAXSTRING];
  float tmp_x, tmp_y;

  class = func = dyn = mark = 1;
 
  sprintf(tmp,"%s.def",argv[1]);
  def_fp = efopen(tmp,"r");
  sprintf(tmp,"%s.net",argv[1]);
  in_fp = efopen(tmp,"r");
  sprintf(tmp,"%s.obj",argv[1]);
  out_fp = efopen(tmp,"w");

  if (!InitTgifInterface()) return 1;

  while( 1 )
   {/* Scanning .def file */
    if( fgets( tmp, MAXSTRING - 1, def_fp ) == NULL )
     if( feof( def_fp ) )
      break;
    if(tmp[0]=='|' )
     {/* Rate MD o delimitatore */
      if(tmp[1]=='2' && tmp[2]=='5' && tmp[3]=='6' && tmp[4]=='\n')
       {/* Delimitatore |256 */
	do
	 {
          fgets( tmp, MAXSTRING - 1, def_fp );
         }
	while(tmp[0]!='|' || tmp[1]!='\n');
       }/* Delimitatore |256 */
      else
       {/* Definizioni di rate MD */
	 name_p = tmp;
	 sscanf(tmp + 1,"%d",&tr);
         fgets( tmp, MAXSTRING - 1, def_fp );
	 strcpy(rate_md[tr],tmp);
	 rate_md[tr][strlen(tmp)-1] = '\0';
       }/* Definizioni di rate MD */
     }/* Rate MD o delimitatore */
    else 
     {/* Superato l'inizio file */
      /* Lettura del nome della definizione (classe di colore....) */
      if(tmp[0]=='(')
       {/* Definizioni di colori, marcature o funzioni */
	name_p = tmp + 1;
	sscanf(name_p,"%s %c %f %f %c",read_name,&ctype,&xcoord2,&ycoord2,&ctrash);
	strcpy(name[def_ind],read_name);
	name[def_ind][strlen(read_name)] = '\0';
	fgets( tmp, MAXSTRING - 1, def_fp );
	strcpy(def[def_ind],tmp);
	def[def_ind][strlen(tmp)-1] = '\0';
	switch(ctype)
	 {
	  case 'c' : 
	             strcpy(cname[class],name[def_ind]);
	             strcpy(cdef[class],def[def_ind]);
		     class++;
		     break;
	  case 'm' : if(tmp[0]=='(')
		      {/* Definizione di sottoclasse dinamica */
	               strcpy(dname[dyn],name[def_ind]);
	               strcpy(ddef[dyn],def[def_ind]);
		       dyn++;
		      }/* Definizione di sottoclasse dinamica */
		     else
		      {/* Definizione di marcatura */
	               strcpy(mname[mark],name[def_ind]);
	               strcpy(mdef[mark],def[def_ind]);
		       mark++;
		      }/* Definizione di marcatura */
		     break;
	  case 'f' :
		     {/* Definizione di funzione */
	               strcpy(fname[func],name[def_ind]);
	               strcpy(fdef[func],def[def_ind]);
		       func++;
		     }/* Definizione di funzione */
		     break;
	 }
	fgets( tmp, MAXSTRING - 1, def_fp );
	def_ind++;
       }/* Definizioni di colori, marcature o funzioni */
     }/* Superato l'inizio file */
   }/* Scanning .def file */

  fclose(def_fp);
  while( 1 )
   {/* Scanning .def file */
    if( fgets( tmp, MAXSTRING - 1, in_fp ) == NULL )
     if( feof( in_fp ) )
      break;
    if(tmp[0]=='|' && tmp[1]=='\n')
     {/* Parsing della prima riga */
      fscanf(in_fp,"%c %d %d %d %d %d %d",&type,&el[0],&el[1],&el[2],&el[4],&el[3],&el[5]);
      while(getc(in_fp)!='\n');
      break;
     }/* Parsing della prima riga */
   }/* Scanning .def file */
  /*********** MARKING PARAMETERS ***********/
  xtable = 30.0;
  ytable = 35.0;
  if(el[0] > 0)
   {/* Ci sono marking parameters */
    TgifText(&xtable,&ytable,fonttype_TAG,20,"MARKING PARAMETERS");
    ytable += fontsize_TAG;
    for(item = 1; item <= el[0]; item++)
     {/* Lettura dei Marking Parameters */
      fgets( tmp, MAXSTRING - 1, in_fp );

      sscanf(tmp,"%s %d %f %f %s",read_name,&int_val,&xcoord1,&ycoord1,trash);
      strcpy(mpname[item],read_name);
      TgifText(&xtable,&ytable,fonttype_TAG,fontsize_TAG,read_name);
      ytable += fontsize_TAG+2;

     }/* Lettura dei Marking Parameters */
   }/* Ci sono marking parameters */
  ytable += fontsize_TAG+10;
  TgifText(&xtable,&ytable,fonttype_TAG,20,"INITIAL MARKING");
  ytable += fontsize_TAG;
  /*********** PLACES ***********/
  if(el[1] > 0)
   {/* Ci sono posti */
    for(item = 1; item <= el[1]; item++)
     {/* Lettura dei Posti */
      fgets( tmp, MAXSTRING - 1, in_fp );

      sscanf(tmp,"%s %d %f %f %f %f %n",read_name,&int_val,&xcoord1,&ycoord1,&xcoord2,&ycoord2,&char_read);

      /* DISEGNO DELLA CIRCONFERENZA */
      gf_x1 = pc[np][0] = PIXEL_IN_CM*xcoord1+x_offset-r;
      gf_y1 = pc[np][1] = PIXEL_IN_CM*ycoord1+y_offset-r;
      gf_x2 = pc[np][2] = PIXEL_IN_CM*xcoord1+x_offset+r;
      gf_y2 = pc[np][3] = PIXEL_IN_CM*ycoord1+y_offset+r;
      np++;
      if (int_val)
       {
        gf_x1 = PIXEL_IN_CM*xcoord1+x_offset-r/4;
        gf_y1 = PIXEL_IN_CM*ycoord1+y_offset-r/4;
        gf_x2 = PIXEL_IN_CM*xcoord1+x_offset+r/4;
        gf_y2 = PIXEL_IN_CM*ycoord1+y_offset+r/4;
        TgifMarkedOval(&gf_x1,&gf_y1,&gf_x2,&gf_y2,&pc[np-1][0],&pc[np-1][1],&pc[np-1][2],&pc[np-1][3]);
       }
      else
       TgifOval(&gf_x1,&gf_y1,&gf_x2,&gf_y2);

      /* DISEGNO DEL TAG */
      tmp_x = PIXEL_IN_CM*xcoord2+x_offset;
      tmp_y = PIXEL_IN_CM*ycoord2+y_offset;
      TgifAttr(&tmp_x,&tmp_y,fonttype_TAG,fontsize_TAG,0,1,0,"name=",read_name);

      /* DISEGNO DELLA MARCATURA */
      if(int_val == 1)
       {
        gf_x1 = PIXEL_IN_CM*xcoord1+x_offset-r/4;
        gf_y1 = PIXEL_IN_CM*ycoord1+y_offset-r/4;
        gf_x2 = PIXEL_IN_CM*xcoord1+x_offset+r/4;
        gf_y2 = PIXEL_IN_CM*ycoord1+y_offset+r/4;
       }
      else if(int_val )
       {/* put a label below the circle for special marking of a place */
        gf_x1 = PIXEL_IN_CM*xcoord1+x_offset-r/2;
        gf_y1 = PIXEL_IN_CM*ycoord1+y_offset-r/2+fontsize_ARC;
        if(int_val >= 0)
         sprintf(buf,"%d",int_val);
	else if(int_val < -10000)
         sprintf(buf,"%s",name[-int_val-10000]);
	else
         sprintf(buf,"%s",mpname[-int_val]);
        TgifAttr(&gf_x1,&gf_y1,fonttype_ARC,fontsize_ARC,0,1,0,"marking=",buf);
       }
      if(int_val >= 0)
       sprintf(buf1,"%d",int_val);
      else if(int_val < -10000)
       sprintf(buf1,"%s",name[-int_val-10000]);
      else
       sprintf(buf1,"%s",mpname[-int_val]);
      TgifAttr(&tmp_x,&tmp_y,fonttype_TAG,fontsize_TAG,0,0,0,"M=",buf1);
      sprintf(buf,"M(%s) = %s",read_name,buf1);
      TgifText(&xtable,&ytable,fonttype_TAG,fontsize_TAG,buf);
      ytable += fontsize_TAG+2;

      name_p = tmp + char_read ;

      switch(*(name_p+1))
       {/* Tipo di dominio del posto */
        case '@'  : break;
        case '\n' : break;
        default   : {/*Dominio colorato da parsificare*/
                     if (!(*name_p >= '0' && *name_p <= '9')) name_p++;
                     sscanf(name_p," %f %f %n",&xcoord1,&ycoord1,&char_read);
                     name_p+=char_read;
		     if (*name_p != '\0')
                      {/* not sure what we are generating here -- bc 2/9/99 */
		       strcpy(trash,name_p);
		       trash[strlen(name_p)-1] = '\0';

                       /* DISEGNO DEL DOMINIO */
                       tmp_x = PIXEL_IN_CM*xcoord1+x_offset;
                       tmp_y = PIXEL_IN_CM*ycoord1+y_offset;
                       TgifText(&tmp_x,&tmp_y,fonttype_ARC,fontsize_ARC,trash);
                      }
	            }/*Dominio colorato da parsificare*/
        }/* Tipo di dominio del posto */
     }/* Lettura dei Posti */
   }/* Ci sono posti */
  /*********** RATE PARAMETERS ***********/
  if(el[2] > 0)
   {/* Ci sono rate parameters */
    ytable += fontsize_TAG+10;
    TgifText(&xtable,&ytable,fonttype_TAG,20,"RATE PARAMETERS");
    ytable += fontsize_TAG;
    for(item = 1; item <= el[2]; item++)
     {/* Lettura dei Rate Parameters */
      fgets( tmp, MAXSTRING - 1, in_fp );

      sscanf(tmp,"%s %lg %f %f %s",read_name,&float_val,&xcoord1,&ycoord1,trash);
      strcpy(rpname[item],read_name);
      TgifText(&xtable,&ytable,fonttype_TAG,fontsize_TAG,read_name);
      ytable += fontsize_TAG+2;
     }/* Lettura dei Rate Parameters */
   }/* Ci sono rate parameters */
  /*********** PRIORITY GROUPS ***********/
  if(el[3] > 0)
   {/* Ci sono groups */
    for(item = 1; item <= el[3]; item++)
     {/* Lettura dei Groups */
      fgets( tmp, MAXSTRING - 1, in_fp );
     }/* Lettura dei Groups */
   }/* Ci sono groups */
  /*********** TRANSITIONS ***********/
  if(el[4] > 0)
   {/* Ci sono transizioni */
    for(item = 1; item <= el[4]; item++)
     {/* Lettura delle transizioni */
      fgets( tmp, MAXSTRING - 1, in_fp );

      sscanf(tmp,"%s %lg %d %d %d %d %f %f %f %f %f %f %n",
                read_name,
                &float_val,
                &int_val1,&int_val2,&nin,&int_val4,
                &xcoord1,&ycoord1,&xcoord2,&ycoord2,&xcoord3,&ycoord3,
                &char_read);

      tim[nt] = int_val2;
      rot[nt] = int_val4;

      if(tim[nt]==0 && first_TIMED)
       {
        ytable += fontsize_TAG+10;
        TgifText(&xtable,&ytable,fonttype_TAG,20,"TRANSITION RATES");
        ytable += fontsize_TAG;
	first_TIMED = 0;
	first_IMMEDIATE = 1;
       }
      if(nt==1 && tim[nt]>0)
       {
	first_TIMED = 0;
	first_IMMEDIATE = 1;
       }
      if(tim[nt] > 0 && first_IMMEDIATE)
       {
        ytable += fontsize_TAG+10;
        TgifText(&xtable,&ytable,fonttype_TAG,20,"TRANSITION WEIGHTS");
        ytable += fontsize_TAG;
	first_TIMED = 0;
	first_IMMEDIATE = 0;
       }
      if(float_val==-510)
       {/* Rate MD */
fprintf(stderr, "float_val==-510, this may cause problem!\n");
       }/* Rate MD */
      else
       {
       if(float_val < 0)
        {
         rte = -float_val;
         sprintf(buf,"%s = %s",read_name,rpname[rte]);
        }
       else
        sprintf(buf,"%s = %f",read_name,float_val);
       TgifText(&xtable,&ytable,fonttype_TAG,fontsize_TAG,buf);
       }
      ytable += fontsize_TAG+2;

      /* DISEGNO DEL RETTANGOLO */
      gf_x1 = tc[nt][0] = PIXEL_IN_CM*xcoord1+x_offset;
      gf_y1 = tc[nt][1] = PIXEL_IN_CM*ycoord1+y_offset;
      if(int_val2 > 0)
       {/* Transizione immediata */
	if(int_val4 == 0)
	 {/* Orizzontale */
	  tmp_x = gf_x1-r;
	  tmp_y = gf_y1-rimm/2;
	  gf_x2 = tc[nt][2] = r+PIXEL_IN_CM*xcoord1+x_offset;
	  gf_y2 = tc[nt][3] = rimm/2+PIXEL_IN_CM*ycoord1+y_offset;
	 }/* Orizzontale */
         else
	 {/* verticale */
	  /* solid and vertical transition */
	  tmp_x = gf_x1-rimm/2;
	  tmp_y = gf_y1-r;
	  gf_x2 = tc[nt][2] = rimm/2+PIXEL_IN_CM*xcoord1+x_offset;
	  gf_y2 = tc[nt][3] = r+PIXEL_IN_CM*ycoord1+y_offset;
	 }/* verticale */
       }/* Transizione immediata */
      else
       {/* Transizione temporizzata */
	if(int_val4 == 0)
	 {/* Orizzontale */
	  tmp_x = gf_x1-r;
	  tmp_y = gf_y1-r/2;
	  gf_x2 = tc[nt][2] = r+PIXEL_IN_CM*xcoord1+x_offset;
	  gf_y2 = tc[nt][3] = r/2+PIXEL_IN_CM*ycoord1+y_offset;
	 }/* Orizzontale */
        else
	 {/* verticale */
	  /* hollow and vertical transition */
	  tmp_x = gf_x1-r/2;
	  tmp_y = gf_y1-r;
	  gf_x2 = tc[nt][2] = r/2+PIXEL_IN_CM*xcoord1+x_offset;
	  gf_y2 = tc[nt][3] = r+PIXEL_IN_CM*ycoord1+y_offset;
	 }/* verticale */
       }/* Transizione temporizzata */
      TgifBox(&tmp_x,&tmp_y,&gf_x2,&gf_y2,int_val2>0,0);

      /* DISEGNO DELLA PRIORITA' */
      if(tim[nt] > 1)
       {
        sprintf(buf,"p:%d",tim[nt]);
        tmp_x = xpr_off+PIXEL_IN_CM*xcoord1+x_offset;
        tmp_y = ypr_off+PIXEL_IN_CM*ycoord1+y_offset;
        TgifText(&tmp_x,&tmp_y,"Symbol",fontsize_ARC,buf);
       }

      /* DISEGNO DEL TAG */
      tmp_x = PIXEL_IN_CM*xcoord2+x_offset;
      tmp_y = PIXEL_IN_CM*ycoord2+y_offset;
      TgifAttr(&tmp_x,&tmp_y,fonttype_TAG,fontsize_TAG,0,1,0,"name=",read_name);

#ifdef VEDIAMO_POI
      /* DISEGNO DEL RATE */
      fprintf(buf,"%f",float_val);
      tmp_x = PIXEL_IN_CM*xcoord3+x_offset;
      tmp_y = PIXEL_IN_CM*ycoord3+y_offset;
      TgifText(&tmp_x,&tmp_y,fonttype_TAG,fontsize_TAG,buf);
#endif


      name_p = tmp + char_read;

      switch(*(name_p+1))
       {/* Tipo di dominio della transizione */
        case '@'  : {
	             break;
	            }
        case '\n' : {/* Dominio neutro*/
            	       break;
	            }/* Dominio neutro*/
        default   : {/*Dominio colorato da parsificare*/
                     if (!(*name_p >= '0' && *name_p <= '9')) name_p++;
                     sscanf(name_p," %f %f %n",&xcoord1,&ycoord1,&char_read);
                     name_p+=char_read;
		     if (*name_p != '\0')
                      {/* not sure what we are generating here -- bc 2/9/99 */
		       strcpy(trash,name_p);
		       trash[strlen(name_p)-1] = '\0';

                       /* DISEGNO DEL DOMINIO */
                       tmp_x = PIXEL_IN_CM*xcoord1+x_offset;
                       tmp_y = PIXEL_IN_CM*ycoord1+y_offset;
                       TgifText(&tmp_x,&tmp_y,fonttype_ARC,fontsize_ARC,trash);
                      }
	            }/*Dominio colorato da parsificare*/
       }/* Tipo di dominio della transizione */
         /*********** INPUT ARCS *************/
      if(nin!=0)
       {/* Ci sono archi di ingresso */
        for(item_arc = 1; item_arc <= nin; item_arc++)
         {/* Lettura di ogni arco di ingresso */
          fgets( tmp, MAXSTRING - 1, in_fp );
	  strcpy(trash,tmp);
          sscanf(tmp,"%d %d %d %n",&int_val1,&place,&nint,&char_read);
          for(item_skip = 1; item_skip <= nint; item_skip++)
	   {
            fgets( tmp, MAXSTRING - 1, in_fp ); 
            sscanf(tmp,"%f %f",&intermediate_c[item_skip][0],&intermediate_c[item_skip][1]);
	    intermediate_c[item_skip][0] = x_offset + intermediate_c[item_skip][0] * PIXEL_IN_CM;
	    intermediate_c[item_skip][1] = y_offset + intermediate_c[item_skip][1] * PIXEL_IN_CM;
	   }
          get_intersection(nint,place,nt,&xint,&yint,INPUT,&xdummy,&ydummy);
          get_transition_side(nint,place,nt,&xt,&yt,INPUT,&xdummy,&ydummy);
          TgifStartVertex(&xint,&yint);
          for(item_skip = nint; item_skip >= 1; item_skip--)
            TgifAddVertex(&intermediate_c[item_skip][0],&intermediate_c[item_skip][1]);
          TgifAddVertex(&xt,&yt);
          TgifPoly("1","8","2");
          TgifSmooth(1,int_val4==0,0);

          get_arc_position(nint,place,nt,&xt,&yt,INPUT);
          name_p = trash + char_read;
          switch(*(name_p+1))
           {/* Tipo di arco */
            case '\n' : 
                    {/* Arco senza etichetta */
                       if(int_val1 > 1)
                        {
                         sprintf(buf,"%d",int_val1);
                         TgifText(&xt,&yt,fonttype_ARC,fontsize_ARC,buf);
                        }
                       break;
                    }/* Arco senza etichetta */
            default :
                    {/* Arco con etichetta */
                     if (!(*name_p >= '0' && *name_p <= '9')) name_p++;
                     sscanf(name_p," %f %f %n",&xcoord1,&ycoord1,&char_read);
                     name_p+=char_read;
		     if (*name_p != '\0')
                      {/* not sure what we are generating here -- bc 2/9/99 */
		       strcpy(trash,name_p);
		       trash[strlen(name_p)-1] = '\0';

                       tmp_x = xt+xcoord1*PIXEL_IN_CM;
                       tmp_y = yt+ycoord1*PIXEL_IN_CM;
                       TgifText(&tmp_x,&tmp_y,fonttype_ARC,fontsize_ARC,trash);
                      }
                    }/* Arco con etichetta */
           }/* Tipo di arco */
         }/* Lettura di ogni arco di ingresso */
       }/* Ci sono archi di ingresso */
         /*********** OUTPUT ARCS *************/
      fgets( tmp, MAXSTRING - 1, in_fp ); 
      sscanf(tmp,"%d",&nout);
      
      if(nout!=0)
       {/* Ci sono archi di uscita */
        for(item_arc = 1; item_arc <= nout; item_arc++)
         {/* Lettura di ogni arco di ingresso */
          fgets( tmp, MAXSTRING - 1, in_fp );
	  strcpy(trash,tmp);

          sscanf(tmp,"%d %d %d %n", &int_val1,&place,&nint, &char_read);
          for(item_skip = 1; item_skip <= nint; item_skip++)
	   {
            fgets( tmp, MAXSTRING - 1, in_fp ); 
            sscanf(tmp,"%f %f",&intermediate_c[item_skip][0],&intermediate_c[item_skip][1]);
	    intermediate_c[item_skip][0] = x_offset + intermediate_c[item_skip][0] * PIXEL_IN_CM;
	    intermediate_c[item_skip][1] = y_offset + intermediate_c[item_skip][1] * PIXEL_IN_CM;
	   }
          get_intersection(nint,place,nt,&xint,&yint,OUTPUT,&xdummy,&ydummy);
          get_transition_side(nint,place,nt,&xt,&yt,OUTPUT,&xdummy,&ydummy);

          TgifStartVertex(&xt,&yt);
          for(item_skip = 1; item_skip <= nint; item_skip++)
            TgifAddVertex(&intermediate_c[item_skip][0],&intermediate_c[item_skip][1]);
          TgifAddVertex(&xint,&yint);
          TgifPoly("1","8","2");
          TgifSmooth(0,int_val4==0,0);

          get_arc_position(nint,place,nt,&xt,&yt,OUTPUT);
          name_p = trash + char_read;
          switch(*(name_p+1))
           {/* Tipo di arco */
            case '\n' : 
                    {/* Arco senza etichetta */
                       if(int_val1 > 1)
                        {
                         sprintf(buf,"%d",int_val1);
                         TgifText(&xt,&yt,fonttype_ARC,fontsize_ARC,buf);
                        }
                       break;
                    }/* Arco senza etichetta */
            default :
                    {/* Arco con etichetta */
                     if (!(*name_p >= '0' && *name_p <= '9')) name_p++;
                     sscanf(name_p," %f %f %n",&xcoord1,&ycoord1,&char_read);
                     name_p+=char_read;
		     if (*name_p != '\0')
                      {/* not sure what we are generating here -- bc 2/9/99 */
		       strcpy(trash,name_p);
		       trash[strlen(name_p)-1] = '\0';

                       tmp_x = xt+xcoord1*PIXEL_IN_CM;
                       tmp_y = yt+ycoord1*PIXEL_IN_CM;
                       TgifText(&tmp_x,&tmp_y,fonttype_ARC,fontsize_ARC,trash);
                      }
                    }/* Arco con etichetta */
           }/* Tipo di arco */
         }/* Lettura di ogni arco di ingresso */
       }/* Ci sono archi di uscita */
         /*********** INHIBITOR ARCS *************/
      fgets( tmp, MAXSTRING - 1, in_fp ); 
      sscanf(tmp,"%d",&ninh);
      
      if(ninh!=0)
       {/* Ci sono archi inibitori */
        for(item_arc = 1; item_arc <= ninh ; item_arc++)
         {/* Lettura di ogni arco di ingresso */
          fgets( tmp, MAXSTRING - 1, in_fp );
	  strcpy(trash,tmp);

          sscanf(tmp,"%d %d %d %n", &int_val1,&place,&nint, &char_read);
          for(item_skip = 1; item_skip <= nint; item_skip++)
	   {
            fgets( tmp, MAXSTRING - 1, in_fp ); 
            sscanf(tmp,"%f %f",&intermediate_c[item_skip][0],&intermediate_c[item_skip][1]);
	    intermediate_c[item_skip][0] = x_offset + intermediate_c[item_skip][0] * PIXEL_IN_CM;
	    intermediate_c[item_skip][1] = y_offset + intermediate_c[item_skip][1] * PIXEL_IN_CM;
	   }
          get_intersection(nint,place,nt,&xint,&yint,INHIBITOR,&xdummy,&ydummy);
          get_transition_side(nint,place,nt,&xt,&yt,INHIBITOR,&xc,&yc);

/*        fprintf(out_fp,"group([\n");
          fprintf(out_fp,"%s%d%s\n%s","poly('black',",2+nint,",[","         ");
          fprintf(out_fp,"%f,%f,",xint,yint);
          for(item_skip = nint; item_skip >= 1; item_skip--)
            fprintf(out_fp,"%f,%f,",intermediate_c[item_skip][0],intermediate_c[item_skip][1]);
          fprintf(out_fp,"%f,%f",xt,yt);
	  fprintf(out_fp,"],0,%s%d%s\n%s\n","1,1,",tgifid++,",0,0,0,0,0,0,0,[","]),");
        
          fprintf(out_fp,"%s","oval('black'");
          fprintf(out_fp,",%f",xc);
          fprintf(out_fp,",%f",yc);
          fprintf(out_fp,",%f",xc+di);
          fprintf(out_fp,",%f",yc+di);
          fprintf(out_fp,"%s%d%s\n%s\n",",0,1,1,",tgifid++,",0,0,0,0,0,'1',[","])");
          fprintf(out_fp,"],\n%d,0,[\n]).\n",tgifid++);
 */


          get_arc_position(nint,place,nt,&xt,&yt,INHIBITOR,&xc,&yc);
          name_p = trash + char_read;
          switch(*(name_p+1))
           {/* Tipo di arco */
            case '\n' : 
                    {/* Arco senza etichetta */
                       if(int_val1 > 1)
                        {
                         sprintf(buf,"%d",int_val1);
                         TgifText(&xt,&yt,fonttype_ARC,fontsize_ARC,buf);
                        }
                       break;
                    }/* Arco senza etichetta */
            default :
                    {/* Arco con etichetta */
                     if (!(*name_p >= '0' && *name_p <= '9')) name_p++;
                     sscanf(name_p," %f %f %n",&xcoord1,&ycoord1,&char_read);
                     name_p+=char_read;
		     if (*name_p != '\0')
                      {/* not sure what we are generating here -- bc 2/9/99 */
		       strcpy(trash,name_p);
		       trash[strlen(name_p)-1] = '\0';

                       tmp_x = xt+xcoord1*PIXEL_IN_CM;
                       tmp_y = yt+ycoord1*PIXEL_IN_CM;
                       TgifText(&tmp_x,&tmp_y,fonttype_ARC,fontsize_ARC,trash);
                      }
                    }/* Arco con etichetta */
           }/* Tipo di arco */
         }/* Lettura di ogni arco di ingresso */
       }/* Ci sono archi inibitori */
       nt++;
     }/* Lettura delle transizioni */
   }/* Ci sono transizioni */
  if(class > 1)
   {
    ytable += fontsize_TAG+10;
    TgifText(&xtable,&ytable,fonttype_TAG,20,"COLOR CLASSES");
    ytable += fontsize_TAG;
   }
  for(item_skip = 1; item_skip < class ; item_skip++)
   {
    sprintf(buf,"%s := %s",cname[item_skip],cdef[item_skip]);
    TgifText(&xtable,&ytable,fonttype_TAG,fontsize_TAG,buf);
    ytable += fontsize_TAG+2;
   }
  if(mark > 1)
   {
    ytable += fontsize_TAG+10;
    TgifText(&xtable,&ytable,fonttype_TAG,20,"COLOR MARKING");
    ytable += fontsize_TAG;
   }
  for(item_skip = 1; item_skip < mark ; item_skip++)
   {
    sprintf(buf,"%s := %s",mname[item_skip],mdef[item_skip]);
    TgifText(&xtable,&ytable,fonttype_TAG,fontsize_TAG,buf);
    ytable += fontsize_TAG+2;
   }
  if(dyn > 1)
   {
    ytable += fontsize_TAG+10;
    TgifText(&xtable,&ytable,fonttype_TAG,20,"DYNAMIC SUBCLASSES");
    ytable += fontsize_TAG;
   }
  for(item_skip = 1; item_skip < dyn ; item_skip++)
   {
    sprintf(buf,"%s := %s",dname[item_skip],ddef[item_skip]);
    TgifText(&xtable,&ytable,fonttype_TAG,fontsize_TAG,buf);
    ytable += fontsize_TAG+2;
   }
  if(func > 1)
   {
    ytable += fontsize_TAG+10;
    TgifText(&xtable,&ytable,fonttype_TAG,20,"COLOR FUNCTION");
    ytable += fontsize_TAG;
   }
  for(item_skip = 1; item_skip < func ; item_skip++)
   {
    sprintf(buf,"%s := %s",fname[item_skip],fdef[item_skip]);
    TgifText(&xtable,&ytable,fonttype_TAG,fontsize_TAG,buf);
    ytable += fontsize_TAG+2;
   }

  TgifGenerate(out_fp);

  fclose(in_fp);
  fclose(out_fp);

  CleanUpTgifInterface();

  return 0;
 }/* Init greatspntoobj */ 


