
///////////////////////////////////////////////////////////////////////
//
// Plug-In Filter include for Breeze Designer
// MS-Windows Version 1.0 Filters
// Written by Neville Richards
//
// Copyright (C) 1994,1995,1996 Neville Richards. All Rights Reserved.
//

#ifndef _BREEZE_PLUGIN_
#define _BREEZE_PLUGIN_

#ifndef _CAD_OBJECT_
#define OBJECT_NULL				0
#define OBJECT_GROUP				1
#define OBJECT_TEXT				2
#define OBJECT_RESERVED1		3
#define OBJECT_RESERVED2		4
#define OBJECT_RESERVED3		5
#define OBJECT_RESERVED4		6
#define OBJECT_RESERVED5		7
#define OBJECT_POINTS			8
#define OBJECT_LINESEG			9
#define OBJECT_POLYGON			10
#define OBJECT_LIGHT				11
#define OBJECT_CAMERA			12
#define OBJECT_SPHERE			13
#define OBJECT_PLANE				14
#define OBJECT_DISC				15
#define OBJECT_CYLINDER			16
#define OBJECT_CONE				17	
#define OBJECT_ELLIPSOID		18
#define OBJECT_TORUS				19
#define OBJECT_BOX				20
#define OBJECT_HEIGHTFIELD		21
#define OBJECT_BLOB				22
#define OBJECT_PATCH				23
#endif

#ifdef _WIN32
#ifndef EXPORT
#define EXPORT	/**/
#endif 
#define DLLEXPORT	__declspec( dllexport )
#define PIAPI	UINT DLLEXPORT CALLBACK
#else
#ifndef EXPORT
#define EXPORT	_export
#endif 
#define DLLEXPORT /**/
#define PIAPI	UINT FAR PASCAL EXPORT
#endif

#ifndef UCHAR
#define UCHAR unsigned char
#endif

typedef int HCADOBJECT;

#define PI_ERROR	-1

#define PI_GET_FIRST       1
#define PI_GET_NEXT        2
#define PI_GET_SELECTED    4

#define PLUGIN_NULL        0	
#define PLUGIN_FILTER      1
#define PLUGIN_UTILITY     2

#define ATTRIB_NULL        0
#define ATTRIB_SIZE        1
#define ATTRIB_EXTRA       2
#define ATTRIB_SCALE       3
#define ATTRIB_ROTATE      4
#define ATTRIB_TRANSLATE   5

typedef struct tagPointXYZ
{
	float x;
	float y;
	float z;
	
} PointXYZ;

typedef struct tagPolygonData
{
	PointXYZ	points[3];
	PointXYZ	normals[3];

} POLYGONDATA, FAR *LPPOLYGONDATA;

#ifndef LPXYZ
#define LPXYZ PointXYZ *
#endif
#ifndef LPCXYZ
#define LPCXYZ PointXYZ const *
#endif

typedef UINT (WINAPI *PICALLBACK)( LPCSTR szFunction, UINT nValue, LPSTR szString, LPXYZ lpPoint );

//
// Plug-in classes
//
#define PICLASS_NULL		"NULL"		// Null function
#define PICLASS_UTIL		"UTIL"		// Utility function, no args used
#define PICLASS_LOAD		"LOAD"		// Load or import information
#define PICLASS_SAVE		"SAVE"		// Save or export information
#define PICLASS_BUILD	"BUILD"		// Create new object
#define PICLASS_XFORM	"XFORM"		// Transform existing objects
#define PICLASS_SCREEN 	"SCREEN"		// Manipulate the preview screen

typedef struct tagPlugInFunctions
{
	LPCSTR szClass;
	LPCSTR szFunction;
	LPCSTR szName;

} PLUGINFUNCTIONS, FAR *LPPIFNS;

typedef struct tagPluginInfo
{
	PICALLBACK lpCallBack;
	UINT 	     nPluginInfoSize;
	UINT 	     nFunctionCount;
	LPPIFNS    lpFunctions;
	LPVOID     lpPlugInData;

} PLUGININFO, FAR *LPPLUGININFO;

//
// Plug-in version
//
#define PIVERSION 1

//
// Plug-in return codes
//
#define PI_FAIL		0
#define PI_COMPLETE	1
#define PI_CONTINUE	2

//
// Plug-in operations
//
#define PI_NULL		0
#define PI_GETDATA	1
#define PI_PUTDATA	2
#define PI_GETCAPS	4
#define PI_GETFILTER	8
#define PI_GETINFO	16
#define PI_CONFIG		32


//
// Plugin data interchange structure
//
#define PIDATA_NULL 		0
#define PIDATA_STRING	1
#define PIDATA_FLAGS		2
#define PIDATA_POLYGONS	3
#define PIDATA_METADATA	4

typedef struct tagPluginData
{
	UINT nPluginDataSize;

	UINT  nDataType;
	UINT  nDataSize;
	LPSTR lpData;

} PLUGINDATA, FAR *LPPLUGINDATA;

#define PIFUNC_BASIC		0
#define PIFUNC_ADVANCED	1

#endif
