#ifndef _BREEZE_PLUGIN_CLASS_
#define _BREEZE_PLUGIN_CLASS_

#ifndef _BREEZE_PLUGIN_
#include "plugin.h"
#endif

class CBreezePlugin
{

private:

	LPPLUGINDATA m_pPluginData;
	LPPIPROPERTY m_pPropertyTable;

public:

	CBreezePlugin() : m_pPropertyTable(0), m_pPluginData(0) {};

	virtual BOOL IsValidData();
	virtual BOOL IsValidObject();

	virtual LPPLUGINDATA GetPluginData();
	virtual LPPIPROPERTY GetPropertyTable();
	virtual BOOL   SetPropertyTable( LPPIPROPERTY pPropertyTable );
	virtual BOOL   SetProperty( UINT nIndex, LPCSTR szValue );
	virtual BOOL   SetProperty( UINT nIndex, UINT szValue );
	virtual BOOL   SetProperty( UINT nIndex, int nValue );
	virtual BOOL   SetProperty( UINT nIndex, double nValue );
	virtual LPSTR  GetPropertyString( UINT nValue );
	virtual UINT   GetPropertyInt( UINT nValue );
	virtual double GetPropertyDouble( UINT nValue );

	virtual LPSTR OnGetInfo();
	virtual LPSTR OnGetFilter();
	virtual LPSTR OnGetIcon();
	virtual BOOL  OnConfig();
	virtual BOOL  OnSetProperty();
	virtual BOOL  OnGetProperty();
	virtual BOOL  OnSetFrame( HCADOBJECT hObject, UINT nFrame );
	virtual BOOL  OnRelease( HCADOBJECT hObject );
	virtual BOOL  OnData();
	virtual UINT  OnCreateObject();


	virtual UINT  OnEventCommon( DWORD nOperation, LPVOID lpLocalData );
	virtual UINT  OnEvent( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData  );

	virtual LPSTR GetObjectNameFromFileName( LPCSTR szFileName );
	virtual HCADOBJECT CreatePluginBaseObject( LPSTR szName, LPSTR szDescription );

};

#endif
