
#ifndef _PI_TOOLS_
#define _PI_TOOLS_

///////////////////////////////////////////////////////////////////////
//
// Breeze Designer Plug-In Tools
// Written by Neville Richards
//
///////////////////////////////////////////////////////////////////////

#ifndef _BREEZE_PLUGIN_
#include "plugin.h"
#endif

#ifndef _BREEZE_APP
#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif	/* __cplusplus */

#ifndef PIEXPORT
#define PIEXPORT	__declspec( dllexport ) extern 
#endif
#endif

//
// Local Plugin interface functions
//
PIEXPORT void        piInitVar( LPBDVAR lpVar, UINT nType );
PIEXPORT LPBDVAR     piReturnBdVarDbl( double dValue );
PIEXPORT LPBDVAR     piReturnBdVarInt( UINT nValue );
PIEXPORT LPBDVAR     piReturnBdVarStr( LPCSTR szValue );
PIEXPORT LPBDVAR     piReturnBdVarPnt( LPPOINTXYZ pValue );
PIEXPORT LPBDVAR     piReturnBdVarPtr( LPVOID lpPtr );
PIEXPORT BOOL        piFreeAllHandles();

//
// Plugin interface functions
//
PIEXPORT UINT        piGetViewHandle( LPCSTR szView, BOOL bForceOpen );
PIEXPORT BOOL 			piGetPluginProperty( LPCSTR szFunctionName, LPCSTR szProperty, LPBDVAR lpValue );
PIEXPORT BOOL 			piSetPluginProperty( LPCSTR szFunctionName, LPCSTR szProperty, LPBDVAR lpValue );
PIEXPORT UINT        piCallPlugin( LPCSTR szFunctionName );
PIEXPORT BOOL        piShell( LPCSTR szCommand );
PIEXPORT BOOL        piGetFileName( UINT bSaveLoad, LPCSTR szFilter, LPSTR szFileName );
PIEXPORT UINT        piOpenFile( LPCSTR szFileName, UINT bSaveLoad  );
PIEXPORT BOOL        piCloseFile( UINT hFile );
PIEXPORT int         piReadFile( UINT hFile, LPVOID lpData, DWORD nLength  );
PIEXPORT int         piWriteFile( UINT hFile, LPVOID lpData, DWORD nLength  );
PIEXPORT UINT        piBind( HCADOBJECT hObject, LPSTR szPluginDescription );
PIEXPORT UINT        piGetFunctionOrdinal( LPSTR szFunctionName );
PIEXPORT BOOL        piSetAutoFree( BOOL bState );
PIEXPORT BOOL        piRegisterEvent( HCADOBJECT hCadObject, UINT nEvent, LPVOID pEventHandler );
PIEXPORT BOOL        piFireEvent( HCADOBJECT hCadObject, UINT nEvent );
PIEXPORT BOOL	      piErrorMessage( LPSTR szErrorMessage );

//
// Scene interface functions
//
PIEXPORT HCADOBJECT  piCreateObject( LPCSTR szObjectName, UINT nObjectType );
PIEXPORT HCADOBJECT  piGetObject( HCADOBJECT hCadObject, UINT bFlags );
PIEXPORT HCADOBJECT  piGetObjectByName( LPCSTR szObjectName, UINT bFlags );
PIEXPORT HCADOBJECT  piGetObjectByType( UINT nType, UINT bFlags );
PIEXPORT HCADOBJECT  piCreateDefaultObject( UINT nObjectType );
PIEXPORT HCADOBJECT  piFindObject( LPCSTR szObjectName );
PIEXPORT HCADOBJECT  piGetNextChildObject( HCADOBJECT hCadObject, BOOL bDecend );
PIEXPORT BOOL        piDeleteObject( HCADOBJECT hCadObject );
PIEXPORT BOOL        piAddChildObject( HCADOBJECT hParent, HCADOBJECT hCadObject );
PIEXPORT BOOL        piRemoveChildObject( HCADOBJECT hParent, HCADOBJECT hCadObject );
PIEXPORT BOOL        piFreeObject( HCADOBJECT hCadObject );
PIEXPORT UINT        piGetObjectCount( UINT nFlags );
PIEXPORT BOOL        piSelectObject( HCADOBJECT hCadObject, BOOL bSelect );
PIEXPORT BOOL        piClearSelection( void );
PIEXPORT BOOL        piAnimCreate( LPCSTR szProjectName, UINT mMaxFrames );
PIEXPORT BOOL        piAnimSetObject( HCADOBJECT hCadObject );
PIEXPORT UINT        piAnimGetMaxFrame( void );
PIEXPORT BOOL        piAnimSetFrame( UINT nFrame  );
PIEXPORT BOOL        piAnimGotoFrame( UINT nFrame  );
PIEXPORT UINT        piAnimGetCurrentFrame();
PIEXPORT BOOL        piAnimSetAttrib( UINT nAttrib, UINT nState );
PIEXPORT BOOL  		piCustomTexture( LPCSTR szTextureName, UINT nOperation, LPTEXPROPERTY lpTexProp  );
PIEXPORT BOOL			piLoad( LPCSTR szFileName );
PIEXPORT BOOL        piSave( LPCSTR szFileName, UINT nFileType );
PIEXPORT BOOL        piRender() ;
PIEXPORT BOOL			piNewScene();
PIEXPORT BOOL        piRedraw( void );
PIEXPORT BOOL        piRebuild( void );
PIEXPORT BOOL        piUpdate( void );
PIEXPORT BOOL  		piSetSceneProperty( UINT nProperty, LPBDVAR lpValue );
PIEXPORT BOOL        piRebuildObject( HCADOBJECT hCadObject, BOOL bOnlyThisObject );

//
// Object interface functions
//
PIEXPORT UINT        piGetObjectPropertyId( LPCSTR szProperty );
PIEXPORT UINT 			piGetPropertyId( LPCSTR szProperty );
PIEXPORT BOOL        piGetObjectProperty( HCADOBJECT hCadObject, LPCSTR szProperty, LPBDVAR lpValue );
PIEXPORT BOOL        piSetObjectProperty( HCADOBJECT hCadObject, LPCSTR szProperty, LPBDVAR lpValue );
PIEXPORT BOOL        piSetObjectPropPnt( HCADOBJECT hCadObject, LPCSTR szProperty, LPXYZ pAttribute );
PIEXPORT BOOL        piGetObjectPropPnt( HCADOBJECT hCadObject, LPCSTR szProperty, LPXYZ pAttribute );
PIEXPORT UINT        piGetObjectPropInt( HCADOBJECT hCadObject, LPCSTR szProperty );
PIEXPORT BOOL        piSetObjectPropInt( HCADOBJECT hCadObject, LPCSTR szProperty, UINT nValue );
PIEXPORT BOOL        piGetObjectName( HCADOBJECT hCadObject, LPSTR szName  );
PIEXPORT BOOL        piSetObjectName( HCADOBJECT hCadObject, LPCSTR szName  );
PIEXPORT BOOL        piSetObjectColor( HCADOBJECT hCadObject, LPCSTR szTexture );
PIEXPORT BOOL        piSetObjectTexture( HCADOBJECT hCadObject, LPCSTR szTexture );
PIEXPORT BOOL        piGetObjectTexture( HCADOBJECT hCadObject, LPSTR szTexture );
PIEXPORT BOOL        piGetTextureProperty( HCADOBJECT hCadObject, LPTEXPROPERTY lpTexProp  );
PIEXPORT BOOL        piSetTextureProperty( HCADOBJECT hCadObject, LPTEXPROPERTY lpTexProp  );
PIEXPORT BOOL        piSetObjectData( HCADOBJECT hCadObject, LPVOID lpData );
PIEXPORT BOOL        piGetObjectData( HCADOBJECT hCadObject, LPVOID lpData );
PIEXPORT UINT	      piGetObjectType( HCADOBJECT hCadObject );
PIEXPORT UINT	      piGetObjectGroup( HCADOBJECT hCadObject );
PIEXPORT BOOL        piDeleteGeometry( HCADOBJECT hCadObject );
PIEXPORT BOOL        piGetGeometry( HCADOBJECT hCadObject, UINT nFirstNext, LPXYZ lpPoint );
PIEXPORT BOOL        piPutGeometry( HCADOBJECT hCadObject, UINT nPoints, LPXYZ lpCadFacet );
PIEXPORT BOOL        piSmooth( HCADOBJECT hCadObject, UINT nFlag );
PIEXPORT BOOL  		piSize( HCADOBJECT hCadObject, LPXYZ pSize );
PIEXPORT BOOL        piMove( HCADOBJECT hCadObject, LPXYZ pMove );
PIEXPORT BOOL        piScale( HCADOBJECT hCadObject, LPXYZ pScale );
PIEXPORT BOOL        piScaleAbout( HCADOBJECT hCadObject, LPXYZ pScale, LPXYZ pAbout );
PIEXPORT BOOL        piRotate( HCADOBJECT hCadObject, LPXYZ pRotate );
PIEXPORT BOOL  		piRotateAbout( HCADOBJECT hCadObject, LPXYZ pRotate, LPXYZ pAbout );
PIEXPORT BOOL        piSetCursor( LPXYZ pPosition );
PIEXPORT BOOL        piMoveF( double xOffset, double yOffset, double zOffset );
PIEXPORT BOOL        piScaleF( double xScale, double yScale, double zScale );
PIEXPORT BOOL        piRotateF( double xRotate, double yRotate, double zRotate );
PIEXPORT BOOL        piRotateAboutF( double xRotate, double yRotate, double zRotate, double xOrigin, double yOrigin, double zOrigin );
PIEXPORT BOOL        piSetCursorF( double xPosition, double yPosition, double zPosition );
PIEXPORT BOOL        piTransform( HCADOBJECT hCadObject, LPCSTR szTransform );


#ifndef _BREEZE_APP
#ifdef __cplusplus
}                       /* End of extern "C" { */
#endif	/* __cplusplus */
#endif
#endif





