
///////////////////////////////////////////////////////////////////////
//
// Plug-In Filter include for Breeze Designer
// MS-Windows Version 1.5 Filters
// Written by Neville Richards
//
// Copyright (C) 1994-1999 Neville Richards. All Rights Reserved.
//

#ifndef _BREEZE_PLUGIN_
#define _BREEZE_PLUGIN_

//
// Plug-in version. This is the current plugin interface version.
//
#define PIVERSION 4

///////////////////////////////////////////////////////////////
//
// General plugin defines

#ifdef _WIN32
#ifndef EXPORT
#define EXPORT	/**/
#endif 
#define DLLEXPORT	__declspec( dllexport )
#define PIAPI	UINT DLLEXPORT CALLBACK
#else
#ifndef EXPORT
#define EXPORT	_export
#endif 
#define DLLEXPORT /**/
#define PIAPI	UINT FAR PASCAL EXPORT
#endif

#ifndef UCHAR
#define UCHAR unsigned char
#endif

#ifndef POINTXYZ

typedef struct tagPointXYZ
{
	float x;
	float y;
	float z;
	
} PointXYZ, POINTXYZ, *LPPOINTXYZ;

#endif

#ifndef LPXYZ
#define LPXYZ PointXYZ *
#endif
#ifndef LPCXYZ
#define LPCXYZ PointXYZ const *
#endif

#ifndef TO_RADIANS
#define TO_RADIANS(x)	(x * (4.0 * atan(1.0)) / 180.0)
#endif

#ifndef TO_DEGREES
#define TO_DEGREES(x)	(x * 180.0 / (4.0 * atan(1.0)))
#endif

///////////////////////////////////////////////////////////////
//
// Plugin interface defines etc

typedef int HCADOBJECT;

#define PI_ERROR	 		 -1
#define PI_SELECTED		 -2
#define PI_EVERY   		 -3

#define PI_GET_ANY	     0
#define PI_GET_FIRST      1
#define PI_GET_NEXT       2
#define PI_GET_SELECTED   4
#define PI_GET_LAST       8

#define PLUGIN_NULL       0	
#define PLUGIN_FILTER     1
#define PLUGIN_UTILITY    2

//
// Breeze Designer interface level definition. Plugins returning PIFUNC_BASIC
// will only recieve PI_GETDATA messages. This mode is mostly for compatibilty
// with older plugins.
//
#define PIFUNC_BASIC		0
#define PIFUNC_ADVANCED	1

typedef UINT (WINAPI *PICALLBACK)( LPCSTR szFunction, UINT nValue, LPSTR szString, LPXYZ lpPoint );

//
// Plug-in classes. All plugins should contain handlers for one or more of these types.
// A single plugin file may contain any number of handlers of any type. The simplest
// plugin would cotain only a single handler.
//
#define PICLASS_NULL		"NULL"		// Null function
#define PICLASS_UTIL		"UTIL"		// Utility function, no args used
#define PICLASS_LOAD		"LOAD"		// Load or import information
#define PICLASS_SAVE		"SAVE"		// Save or export information
#define PICLASS_BUILD	"BUILD"		// Create new object
#define PICLASS_XFORM	"XFORM"		// Transform existing objects
#define PICLASS_SCREEN 	"SCREEN"		// Manipulate the preview screen
#define PICLASS_RENDER 	"RENDER"		// Implement an external renderer
#define PICLASS_ANIMAT 	"ANIMAT"		// Animation motion controller

typedef struct tagPlugInFunctions
{
	LPCSTR szClass;
	LPCSTR szFunction;
	LPCSTR szName;

} PLUGINFUNCTIONS, FAR *LPPIFNS;

typedef struct tagPluginInfo
{
	PICALLBACK lpCallBack;
	UINT 	     nPluginInfoSize;
	UINT 	     nFunctionCount;
	LPPIFNS    lpFunctions;
	LPVOID     lpPlugInData;

} PLUGININFO, FAR *LPPLUGININFO;

//
// Plug-in return codes. A plugin may return one of these for each message.
//
#define PI_FAIL	  		0
#define PI_COMPLETE		1
#define PI_CONTINUE 		2
#define PI_NOTSUPPORTED	4

//
// Plug-in class flags
//
#define PICF_DEFAULT_PREVIEW	1
#define PICF_DEFAULT_DISPLAY	2

//
// Plugin data interchange structure
//
#define PIDATA_NULL 		0
#define PIDATA_STRING	1
#define PIDATA_FLAGS		2
#define PIDATA_POLYGONS	3
#define PIDATA_METADATA	4
#define PIDATA_HANDLE	5
#define PIDATA_BINARY	6

// The plugin data is passed from Breeze Designer to a plugin when
// any call is made to the plugin. An active object object handle is
// set if the plugin call us being made relative to an existing
// plugin ie a change of frame or from object properties.

typedef struct tagPluginData
{
	UINT 			nPluginDataSize;	// Size of this structure
	UINT 			nDataType;			// Type of data sent
	UINT  		nDataSize;			// Size of data sent
	LPSTR 		lpData;				// Pointer to data
	HCADOBJECT	hObject;				// Handle to active object

} PLUGINDATA, FAR *LPPLUGINDATA;

//
// Polygon data structure
//
typedef struct tagPolygonData
{
	POINTXYZ   points[3];
	POINTXYZ   normals[3];

} POLYGONDATA, FAR *LPPOLYGONDATA;

//
// Breeze Designer viewport definition.
//
typedef struct tagPluginViewport
{
	HWND	 hwnd;
	HDC	 hdc;
	RECT   rectView;
	LPVOID lpReserved1;
	LPVOID lpReserved2;

} PLUGINVIEWPORT, FAR *LPPLUGINVIEWPORT;

#define MAX_STRING_LENGTH	32

//
// Breeze Designer variant definitions.
//
#ifndef BDVAR_NULL
#define BDVAR_NULL 	0
#define BDVAR_BOOL 	1
#define BDVAR_UINT 	2
#define BDVAR_DOUBLE	3
#define BDVAR_POINT	4
#define BDVAR_STRING 5
#define BDVAR_PTR		6

typedef struct tagBreezeVariant 
{
	UINT  nSize;
	UINT	nVarType;
	UINT	nReservered1;
	UINT	nReservered2;
	union
		{
		UINT	   nValue;
		double   dValue;
		POINTXYZ pValue[6];
		char     szValue[ MAX_STRING_LENGTH ];
		LPVOID	lpPtr;
		};

} BREEZEVARIANT, BDVAR, *LPBDVAR;

#define BDVAR_GETUINT(v)   v.nValue
#define BDVAR_GETDOUBLE(v) v.dValue
#define BDVAR_GETPOINT(v)  v.pValue
#define BDVAR_GETSTRING(v) v.szValue
#define BDVAR_GETPTR(v)	   v.lpPtr

#endif

//
// Breeze Designer plugin property definition.
//
typedef struct tagPluginProperty
{
	UINT  nSize;
	char  szProperty[ MAX_STRING_LENGTH ];
	BDVAR varValue;

} PIPROPERTY, *LPPIPROPERTY;

///////////////////////////////////////////////////////////////
//
// Plug-in operations. Then messages are sent from Breeze Designer to the client
// plugin. Use the pitools library to process any unhandled messages.
//
#define PI_NULL				0x00000000
#define PI_GETDATA			0x00000001		// Return object data or just build object
#define PI_PUTDATA			0x00000002		// Save or process object data
#define PI_GETCAPS			0x00000004		// Return plugin capabilities PI_ALL default
#define PI_GETFILTER			0x00000008		// Return file filter details
#define PI_GETINFO			0x00000010		// Return plugin description string
#define PI_CONFIG				0x00000020		// Popup configuration dialog
#define PI_GETFLAGS			0x00000040		// 
#define PI_SETPROPERTY		0x00000080		// Set plugin property from variant
#define PI_GETPROPERTY		0x00000100		// Return plugin property as variant
#define PI_SETFRAME			0x00000200		// Notice for new animation frame
#define PI_GETICON			0x00000400		// Return plugin ICON handle for object builder
#define PI_RELEASE			0x00002000		// Free all object private memory allocations

//
// Object messages
//
#define PI_OBJ_CREATE		0x00004000		// Object has been created
#define PI_OBJ_DELETE		0x00004001		// Object is about to be deleted
#define PI_OBJ_UPDATE		0x00004002		// Object property updated
#define PI_OBJ_FRAME	  		0x00004003		// Object level frame change
#define PI_OBJ_RENDER		0x00004004		// Object begin render
#define PI_OBJ_EXPORT  		0x00004005		// Object begin export
#define PI_OBJ_IMPORT  		0x00004006		// Object begin import
#define PI_OBJ_SELECT		0x00004007		// Object has been selected or unselected
#define PI_OBJ_TRANSFORM	0x00004008		// Object has transformed ie moved, scaled, rotated
#define PI_OBJ_TEXTURE		0x00004009		// Object texture changed

//
// Scene messages
//
#define PI_SCN_CREATE		0x00008000		// New Scene created
#define PI_SCN_DELETE		0x00008001		// Current scene about to be deleted
#define PI_SCN_UPDATE		0x00008002		// Scene level update
#define PI_SCN_FRAME			0x00008003		// Scene animation frame changed
#define PI_SCN_RENDER		0x00008004		// Scene begin export
#define PI_SCN_EXPORT		0x00008005		// Scene begin export
#define PI_SCN_IMPORT		0x00008006		// Scene begin import


#define PI_ALL					0xFFFFFFFF		// Capabilities mask ie send all plugin events


///////////////////////////////////////////////////////////////
//
// Below is a complete list of object types supported by Breeze Designer. User objects
// may use any value from OBJECT_USERDEFINED and above. Different plugins may use the
// same object definition within a given scene.
//
#ifndef _CAD_OBJECT_
#define OBJECT_NULL				0
#define OBJECT_GROUP				1
#define OBJECT_RESERVED0		2
#define OBJECT_RESERVED1		3
#define OBJECT_RESERVED2		4
#define OBJECT_RESERVED3		5
#define OBJECT_RESERVED4		6
#define OBJECT_RESERVED5		7
#define OBJECT_POINTS			8
#define OBJECT_LINESEG			9
#define OBJECT_POLYGON			10
#define OBJECT_LIGHT				11
#define OBJECT_CAMERA			12
#define OBJECT_SPHERE			13
#define OBJECT_PLANE				14
#define OBJECT_DISC				15
#define OBJECT_CYLINDER			16
#define OBJECT_CONE				17	
#define OBJECT_ELLIPSOID		18
#define OBJECT_TORUS				19
#define OBJECT_BOX				20
#define OBJECT_HEIGHTFIELD		21
#define OBJECT_BLOB				22
#define OBJECT_PATCH				23
#define OBJECT_TEXT				24
#define OBJECT_USERDEFINED		25
#endif

#define MAX_OBJECT_TYPES	128

///////////////////////////////////////////////////////////////
//
// Object property defines
//
#define OBJPROP_NULL						0
#define OBJPROP_SIZE						1
#define OBJPROP_EXTRA  					2
#define OBJPROP_SCALE  					3
#define OBJPROP_ROTATE     			4
#define OBJPROP_TRANSLATE  			5
#define OBJPROP_LOOKAT					6
#define OBJPROP_UP    					7
#define OBJPROP_DIRECTION				8
#define OBJPROP_RIGHT	 				9
#define OBJPROP_RESERVED1 				100
#define OBJPROP_TYPE		  				101
#define OBJPROP_FLAGS	  				102
#define OBJPROP_GROUP	  				103
#define OBJPROP_SELECT	  				104
#define OBJPROP_RGB		  				105
#define OBJPROP_CSG		  				106
#define OBJPROP_MATERIALTYPE  		107
#define OBJPROP_ATTRIBUTE       		108
#define OBJPROP_LIGHT_TYPE				110
#define OBJPROP_LIGHT_TIGHTNESS		111
#define OBJPROP_LIGHT_ADAPTIVE		112
#define OBJPROP_LIGHT_JITTER			113
#define OBJPROP_RESERVED2				120
#define OBJPROP_VISIBLE					121
#define OBJPROP_SMOOTH					122
#define OBJPROP_UVMAP					123
#define OBJPROP_TINDEX					124
#define OBJPROP_ANIMATED				125
#define OBJPROP_RESERVED3 				200
#define OBJPROP_NAME						201
#define OBJPROP_MATERIAL				202
#define OBJPROP_PLUGIN_SIGNATURE		203
#define OBJPROP_TEXTOBJECTSTRING		204
#define OBJPROP_HEIGHTFIELDNAME		205
#define OBJPROP_RESERVED4				300
#define OBJPROP_EXTRA_COMMENT			301
#define OBJPROP_EXTRA_VRML_ANCHOR	302
#define OBJPROP_EXTRA_VRML_INLINE	303
#define OBJPROP_EXTRA_USER_INLINE	304
#define OBJPROP_EXTRA_DATA				305
#define OBJPROP_LIGHT_FALLOFF			410
#define OBJPROP_LIGHT_RADIUS			411


///////////////////////////////////////////////////////////////
//
// Breeze Designer texture element definition.
//

#define CUSTOM_TEXTURE_CREATE		1
#define CUSTOM_TEXTURE_COMMIT		2
#define CUSTOM_TEXTURE_DELETE		3
#define CUSTOM_TEXTURE_GETITEM	4
#define CUSTOM_TEXTURE_SETITEM	5

typedef struct tagTexProprty
{
	UINT nSize;
	char szProperty[ MAX_STRING_LENGTH ];
	BDVAR varValue;

} TEXPROPERTY, *LPTEXPROPERTY;

#endif
