
#include "frame.h"
#include "mem.h"

#ifdef SplinePatch
#include "splines.h"

DBL interpol1(SPLINE_ENTRY * se,int i,int k,DBL p);
void fitq(SPLINE_ENTRY *se,int i,int k,DBL *a,DBL *b,DBL *c);
DBL interpol2(SPLINE_ENTRY * se,int i,int k,DBL p);
int findt(SPLINE2* sp, DBL Time);
void mkfree(SPLINE2* sp, int i);


DBL interpol1(SPLINE_ENTRY * se,int i,int k,DBL p)
{
  DBL p1, p2, v1, v2;
  p1=se[i].par; p2=se[i+1].par;
  v1=se[i].vec[k]; v2=se[i+1].vec[k];
  return (p-p1)*(v2-v1)/(p2-p1)+v1;
}

void fitq(SPLINE_ENTRY *se,int i,int k,DBL *a,DBL *b,DBL *c)
{
  /* fit quadratic function to three point*/
  DBL n;
  DBL p1, p2, p3, 
      v1, v2, v3;
  /* assignments to make live easier */
  p1=se[i-1].par; p2=se[i].par; p3=se[i+1].par;
  v1=se[i-1].vec[k]; v2=se[i].vec[k]; v3=se[i+1].vec[k];
 
  n=(p2-p1)*(p3-p1)*(p3-p2);

  *a=(-p2*v1+p3*v1
      +p1*v2-p3*v2
      -p1*v3+p2*v3) /n;
  *b=( p2*p2*v1 - p3*p3*v1
      -p1*p1*v2 + p3*p3*v2
      +p1*p1*v3 - p2*p2*v3) /n;
  *c=(-p2*p2*p3*v1+p2*p3*p3*v1
      +p1*p1*p3*v2-p1*p3*p3*v2
      -p1*p1*p2*v3+p1*p2*p2*v3) /n;
}

DBL interpol2(SPLINE_ENTRY * se,int i,int k,DBL p)
{
  DBL a1,b1,c1;
  DBL a2,b2,c2;
  DBL v1,v2;
  DBL p1,p2;
  p1=se[i].par; p2=se[i+1].par;
  fitq(se,i,k,&a1,&b1,&c1);
  fitq(se,i+1,k,&a2,&b2,&c2);
  v1=(a1*p+b1)*p+c1;
  v2=(a2*p+b2)*p+c2;
  return (p-p1)*(v2-v1)/(p2-p1)+v1;
}

int findt(SPLINE2* sp, DBL Time)
{
  int i;
  SPLINE_ENTRY *se;
  se=sp->SplineEntries;
  if (sp->Number_Of_Entries==0) return 0;
  if (Time<=se[0].par) return 0;
  if (Time>=se[sp->Number_Of_Entries-1].par) return sp->Number_Of_Entries;
  i=1;
  while (Time>se[i].par) i++;
  return i;
}

void mkfree(SPLINE2* sp, int i)
{
  int j;
  SPLINE_ENTRY *se;
  se=sp->SplineEntries;

  for (j=sp->Number_Of_Entries;j>i;j--) 
    { 
      se[j]=se[j-1];
    }
}

SPLINE2 *Create_Spline(int typ)
{
SPLINE2 *New;
New=(SPLINE2*)POV_MALLOC(sizeof(SPLINE2),"spline");
New->SplineEntries=POV_MALLOC(MAX_SPLINE_ENTRIES*sizeof(SPLINE_ENTRY),
			       "spline entry");
New->Number_Of_Entries=0;
New->Type=typ;
return New;
}

SPLINE2 *Copy_Spline(SPLINE2 *se)
{
  SPLINE2 *New;
  New=(SPLINE2*)POV_MALLOC(sizeof(SPLINE2),"spline");
  New->SplineEntries=POV_MALLOC(se->Number_Of_Entries*sizeof(SPLINE_ENTRY),"spline entry");
  New->Number_Of_Entries=se->Number_Of_Entries;
  New->Type=se->Type;
  return New;
}

void Destroy_Spline(SPLINE2* s)
{
  POV_FREE(s->SplineEntries);
  POV_FREE(s);
}

int Insert_Spline_Entry(SPLINE2 *sp,DBL p,VECTOR v)
{
  int i, k;
  if (sp->Number_Of_Entries==MAX_SPLINE_ENTRIES) return 1;
  i=findt(sp,p);
  mkfree(sp,i);
  sp->SplineEntries[i].par=p;
  for (k=0;k<5;k++)
    sp->SplineEntries[i].vec[k]=v[k];
  sp->Number_Of_Entries+=1;
  return 0;
}

DBL Get_Spline_Val(SPLINE2 *sp,DBL p,DBL v[])
{
  int i, k;
  int last;
  SPLINE_ENTRY *se;
  
  last=sp->Number_Of_Entries-1;

  se=sp->SplineEntries;
  
  if (last==0)
    {
      /* if only one entry then return this */
      for (k=0;k<5;k++) v[k]=se[0].vec[k]; 
      return se[0].vec[0]; 
    }
  
  i=findt(sp,p);

  if (i==0)
    { 
      /* lower than first entry -> return first */
      for (k=0;k<5;k++) v[k]=se[0].vec[k]; 
      return se[0].vec[0]; 
    }
  if (i>last)
    {
      /* higher than last entry -> return last */
      for (k=0;k<5;k++) v[k]=se[last].vec[k]; 
      return se[last].vec[0]; 
    }
  if ((sp->Type==LINEAR_SPLINE)||(i<2)||(i>last-1))
    {
      /* type==linear or no other than linear interpolation possible */
      for (k=0;k<5;k++)
	v[k]=interpol1(se,i-1,k,p);
        return v[0];
    }
  else
    {
      for (k=0;k<5;k++)
	v[k]=interpol2(se,i-1,k,p);
        return v[0];
    }
}

#else
 static  char dummy[2];
#endif

