/****************************************************************************
*                   bezier.h
*
*  This module contains all defines, typedefs, and prototypes for BEZIER.C.
*
*  from Persistence of Vision(tm) Ray Tracer
*  Copyright 1996,1999 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file.
*  If POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by email to team-coord@povray.org or visit us on the web at
*  http://www.povray.org. The latest version of POV-Ray may be found at this site.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*****************************************************************************/


#ifndef BEZIER_H
#define BEZIER_H



/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

#define BICUBIC_PATCH_OBJECT (PATCH_OBJECT)
/* NK 1998 double_illuminate - removed +DOUBLE_ILLUMINATE from bicubic_patch */

#define BEZIER_INTERIOR_NODE 0
#define BEZIER_LEAF_NODE 1

#ifdef RBezierPatch
#define BEZIER_NSK 		2	/* Bezier surface patches, method Nishita, Sederberg, Kakimoto; see SIGGRAPH 90 */
#define RATIONAL_BEZIER_NSK	3	/* rational Bezier surface patches, method NSK.... */
#endif
#define MAX_PATCH_TYPE 4




/*****************************************************************************
* Global typedefs
******************************************************************************/

#ifdef RBezierPatch
typedef DBL DISTANCES[4][4];
typedef DBL WEIGHTS[4][4];
#endif
typedef struct Bicubic_Patch_Struct BICUBIC_PATCH;
typedef struct Bezier_Node_Struct BEZIER_NODE;
typedef struct Bezier_Child_Struct BEZIER_CHILDREN;
typedef struct Bezier_Vertices_Struct BEZIER_VERTICES;

struct Bezier_Child_Struct
{
  BEZIER_NODE *Children[4];
};

struct Bezier_Vertices_Struct
{
  float uvbnds[4];
  VECTOR Vertices[4];
};

struct Bezier_Node_Struct
{
  int Node_Type;      /* Is this an interior node, or a leaf */
  VECTOR Center;      /* Center of sphere bounding the (sub)patch */
  DBL Radius_Squared; /* Radius of bounding sphere (squared) */
  int Count;          /* # of subpatches associated with this node */
  void *Data_Ptr;     /* Either pointer to vertices or pointer to children */
};

struct Bicubic_Patch_Struct
{
  OBJECT_FIELDS
  int Patch_Type, U_Steps, V_Steps;
  VECTOR Control_Points[4][4];
  /* NK 1998 */
  UV_VECT ST[4]; /*MH*/
  double Mapping[3][3]; /*MH*/
  /* NK 1998 */
  VECTOR Bounding_Sphere_Center;
  DBL Bounding_Sphere_Radius;
  DBL Flatness_Value;
 #ifdef RBezierPatch
  DBL accuracy;
#endif  
  BEZIER_NODE *Node_Tree;
#ifdef RBezierPatch
  WEIGHTS      *Weights;
#endif  
 };


/*****************************************************************************
* Global variables
******************************************************************************/



/*****************************************************************************
* Global functions
******************************************************************************/

void Precompute_Patch_Values (BICUBIC_PATCH *Shape);
BICUBIC_PATCH *Create_Bicubic_Patch (void);
void Compute_Bicubic_Patch_BBox (BICUBIC_PATCH *Patch);

#ifdef RBezierPatch
void beztype2_compute_normals (BICUBIC_PATCH *, VECTOR [4][4], DBL , VECTOR);

int intersect_bicubic_patch_nsk (RAY *, BICUBIC_PATCH *, ISTACK *);
void find_planes  ( VECTOR, VECTOR, VECTOR, DBL *,VECTOR,DBL *);
#endif

#endif
