/*
 * File: uniutils.h
 *
 * Author: Jon A. Cruz
 *         joncruz@geocities.com
 *
 * Simple implementation of UTF-8 to UCS-2 conversion routine.
 * ( described in RFC 2279 )
 *
 *
 *     Jan 23, 1999 - Initial version
 */


#ifndef _INC_UNIUTILS
#define _INC_UNIUTILS

#define ENCODING_INVALID (-1)

int uniGetDefaultEncoding( void );
int uniGetEncodingByName( char *str );
int uniIsEncodingValid( int encoding );
int uniIsAppleByte( int encoding );
int uniBytesToChars( const unsigned char *pszString, wchar_t *pwDstBuff, int sbDstBuff, int encoding );

int uniUtf8ToWide( const unsigned char *pszUtf8, wchar_t *pwDstBuff, int sbDstBuff );

#endif /*_INC_UNIUTILS */
