#ifdef RBezierPatch
#ifndef RBEZIER_H
#define RBEZIER_H

/*****************************************************************************
 * Global preprocessor defines
 ******************************************************************************/

/* #define RBEZIER_PATCH_OBJECT (PATCH_OBJECT+DOUBLE_ILLUMINATE) */
#define RBEZIER_PATCH_OBJECT (PATCH_OBJECT) 

#define TRIM_MAX_CONST		1024

/*****************************************************************************
 * Global typedefs
 ******************************************************************************/

typedef struct RBezier_struct RBEZIER_PATCH;
typedef struct trim_shape_struct TRIM_SHAPE;

struct RBezier_struct
{
  OBJECT_FIELDS
  int 		u_order, v_order;
  DBL		accuracy;
  DBL       	*Points;
  DBL		*(pts[3]);
  DBL		*Weights;
  char 		w_precomp;

  TRIM_SHAPE	**trims;
  int		num_of_trims;

#ifdef DEBUG_RBEZIER
  char		debug;
#endif

 };


struct trim_shape_struct
{
  int		refs, num_of_parts, num_of_cp;
  DBL		bounds[2][2];
  char 		*ctypes;
  DBL		*u, *v, *w;
  char 		ttype;
};

RBEZIER_PATCH *Create_RBezier_Patch (void);
void Compute_RBezier_Patch_BBox ( RBEZIER_PATCH *);

void Destroy_Trim ( TRIM_SHAPE * );
TRIM_SHAPE *Copy_Trim ( TRIM_SHAPE *);

void trim_rotate_cp ( DBL, DBL *,DBL *, int );
void trim_scale_cp ( DBL *, DBL *,DBL *, int );
void trim_translate_cp ( DBL *, DBL *,DBL *, int );
TRIM_SHAPE *trim_deep_copy ( TRIM_SHAPE *);
void trim_compute_bounds (TRIM_SHAPE *);
#endif
#endif /*#ifdef RbezierPatch */
