//	Persistence of Vision Ray Tracer Scene Description File
//	File: bicub-uv.pov
//	Date: 20-09-2000
//	Author: Ren Smellenbergh
//	Demo showing - the new 4 corner syntax for uv_vectors with bicubic
//							- interior and exterior textures


//*** Switch to the different bicubic-patch calculation metods *************
#declare Type = 2;  //0, 1, 2, 3
#declare Step = 5;  //affects only type 0 and 1 (sets the number of u and v steps)
#declare Rat = 4;    //affects only type 3 (Rational bicubic_patch)

#version unofficial MegaPov 0.6;

camera {
	location <0.0, 0.0, -25>
	up y*image_height right x*image_width
	look_at <0.0, 0.0, 0.0>
	angle 40
}

light_source { <3000, 2000, -1000> rgb 1.2 }
light_source { <-0, 0, -25> rgb 0.4 shadowless  }	//fill light

//************* Bicubic_patch with uv_mapping **********************
bicubic_patch {
	type Type
	#if (Type=0 | Type = 1)	flatness 0.0 u_steps Step v_steps Step	#else accuracy 0.00001 	#end
	#if (Type != 3)
		<-7, 7, 5>, <-1.769023, 5.528420, 0.0>, <1.636088, 5.528420, 0.0>, <7, 7, 5>,
		<-5.174134, 1.862827, 0.0>, <0.038471, 0.031270, 18.101474>, <0.036657, 0.031270, 18.101474>, <5.041199, 1.862827, 0.0>,
		<-5.174134, -1.802766, 0.0>, <0.038471, 0.028792, 18.101474>, <0.036657, 0.028792, 18.101474>, <5.041199, -1.802766, 0.0>,
		<-7, -7, 5>, <-1.769023, -5.468359, 0.0>, <1.636088, -5.468359, 0.0>, <7, -7, 5>
		uv_vectors <0,0>, <1,0>, <1,1>, <0,1>
	#else
		<-7, 7, 5, 1>, <-1.769023, 5.528420, 0.0, Rat>, <1.636088, 5.528420, 0.0, Rat>, <7, 7, 5, 1>,
		<-5.174134, 1.862827, 0.0, Rat>, <0.038471, 0.031270, 18.101474, Rat>, <0.036657, 0.031270, 18.101474, Rat>, <5.041199, 1.862827, 0.0, Rat>,
		<-5.174134, -1.802766, 0.0, Rat>, <0.038471, 0.028792, 18.101474, Rat>, <0.036657, 0.028792, 18.101474, Rat>, <5.041199, -1.802766, 0.0, Rat>,
		<-7, -7, 5, 1>, <-1.769023, -5.468359, 0.0, Rat>, <1.636088, -5.468359, 0.0, Rat>, <7, -7, 5, 1>
		uv_vectors <0,0>, <1,0>, <1,1>, <0,1>
	#end
	uv_mapping
	
	//*************** Set exterior texture on bicubic_patch ************************
	texture{
		pigment {
			image_map {
				pattern image_width, image_width { //make resolution dependent of render size
					gradient x
					color_map {
						[ 0.0 rgb 1.0 ]
						[ 0.75 rgb 1.0 ]
						[ 0.75 rgb <0.0, 0.0, 1.0> ]
						[ 1.0 rgb <0.0, 0.0, 1.0> ]
					}
					scale 0.02
				}
				map_type 0	//planar
				interpolate 4	//normalized distance
			}
			ramp_wave
		}
	}
	texture {
		pigment {
			image_map {
				pattern image_width, image_width { //make resolution dependent of render size
					gradient z
					color_map {
						[ 0.0 rgbt <1.0, 1.0, 1.0, 1.0> ]
						[ 0.75 rgbt <1.0, 1.0, 1.0, 1.0> ]
						[ 0.75 rgb <0.0, 0.0, 1.0> ]
						[ 1.0 rgb <0.0, 0.0, 1.0> ]
					}
					scale 0.02
				}
				map_type 0	//planar
				interpolate 4	//normalized distance
			}
			ramp_wave
		}
	} //exterior_texture
	//*************** Set interior texture  on bicubic_patch ************************
	interior_texture {
		pigment {
			image_map {
				pattern image_width*2/3, image_width*2/3 { //make resolution dependent of render size
					leopard
					color_map {
						[ 0.0 rgb <1, 1, 1> ]
						[ 0.3 rgb <0.719982, 0.583948, 0.239994> ]
						[ 0.4 rgb <0.797894, 0.577569, 0.342077> ]
						[ 0.5 rgb <0.555993, 0.373999, 0.244007> ]
						[ 0.8 rgb <0.613184, 0.374868, 0.226795> ]
						[ 1.0 rgb <0.25, 0.1, 0.07> ]
					}
					scale 0.01
				}
				map_type 0	//planar
				interpolate 2	//bilinear
			}
			ramp_wave
		}
	} //interior_texture
	rotate x*-62
	translate y*-2.7
} //bicubic_patch

//*********************** Sky *************************
sky_sphere {
	pigment { rgb <0.258, 0.258, 0.435> }
    pigment {
        bozo
        turbulence 1.5
        octaves 10 omega .5 lambda 2.5
        color_map {
            [0.0, 0.5 color rgbf<.75, .75, .75, 0> color rgbf<.9, .9, .9, .9> ]
            [0.5, 0.7 color rgbf<.9, .9, .9, .9> color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1> color rgbf<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
    pigment {
        bozo
        turbulence 0.6
        octaves 10 omega .5 lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<.75, .75, .75, 0> color rgbf<.9, .9, .9, .9> ]
            [0.4, 0.7 color rgbf<.9, .9, .9, .9> color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1> color rgbf<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
    pigment {
        bozo
        turbulence 0.8
        octaves 10 omega .5 lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<.75, .75, .75, 0> color rgbf<.9, .9, .9, .9> ]
            [0.4, 0.6 color rgbf<.9, .9, .9, .9> color rgbf<1, 1, 1, 1> ]
            [0.6, 1.0 color rgbf<1, 1, 1, 1> color rgbf<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
	scale 2
	rotate y*30
}
