//	Persistence of Vision Ray Tracer Scene Description File
//	File: warp_maps.pov
//	Date: 15/11/99
//	Demo showing the use warps in pigment
	
#version unofficial MegaPov 0.4;


camera {
	location <0.0, 1.5, -11>

	up y*image_height	right x*image_width
	angle 45
	look_at <0.0, 0.0, 0.0>
}

global_settings { 	assumed_gamma  1.8 }

light_source { <0.0, 2, -5> rgb 0.8 }

light_source {
	<20, 10, -40>
	rgb <1.0, 1.0, 1.0>*1.3
	//parallel
	//point_at <0, 0, 0>
}

background { rgb 1 }

#declare Move = 2.4;
#declare MoveY = 1.85;
		
difference {
	torus { 0.7, 0.35 }
		box {
			<-2, -0.7, -2>, <0.001, 0.7, 0.001>
			rotate y*-45 translate z*-0.3
		}
		pigment {
			hexagon
			scale 0.08
			warp {
				toroidal 
				orientation y
				dist_exp 0.0
				major_radius 0.7
			}
		}
		rotate x*-25
	}

	difference {
		torus { 0.7, 0.35 }
		box {
			<-2, -0.7, -2>, <0.001, 0.7, 0.001>
			rotate y*-60	translate z*-0.3
		}
		pigment {
			gradient z
			scale 0.1
			warp {
				toroidal 
				orientation y
				dist_exp 0.0
				major_radius 0.7
			}
		}
		rotate x*-25
		translate x*-Move
	}

	difference {
		torus { 0.7, 0.35 }
		box {
			<-2, -0.7, -2>, <0.001, 0.7, 0.001>
			rotate y*-45	translate z*-0.3
		}
		pigment {
			spiral1 4
			scale 0.1
			warp {
				toroidal 
				orientation y
				dist_exp 0.0
				major_radius 0.7
			}
		}
		rotate x*-25
		translate <Move, 0, 0>
	}

	difference {
		sphere { <0, 0, 0>, 1.0 }
		box {
			<-2, -1.2, -2>, <0.001, 1.2, 0.001>
			rotate y*-80
		}
		pigment {
			brick
			scale 0.04
			warp {
				spherical 
				dist_exp 0.0
			}
		}
		translate <-Move, MoveY, 0>
	}
	
	difference {
		sphere { <0, 0, 0>, 1.0 }
		box {
			<-2, -1.2, -2>, <0.001, 1.2, 0.001>
			rotate y*-45
		}
		pigment {
			checker
			scale 0.2
			warp {
				spherical 
				dist_exp 0.0
			}
		}
		translate <0, MoveY, 0>
	}

	difference {
		sphere { <0, 0, 0>, 1.0 }
		box {
			<0.001, -1.2, -2>, <2.0, 1.2, 0.001>
			rotate y*70
		}
		pigment {
			hexagon
			scale 0.1
			warp {
				spherical 
				orientation y
				dist_exp 0.0
			}
		}
		translate <Move, MoveY, 0>
	}

	difference {
		cylinder {
			<0, -0.8, 0>, <0, 0.6, 0>, 1.0
		}
		box {
			<-2, -0.5, -2>, <0.001, 0.7, 0.001>
			rotate y*-55
		}
		pigment {
			crackle metric 3
			color_map {
				[ 0.0 color rgb < 0.179202, 0.838148, 0.860792 > ]
				[ 0.4 color rgb < 0.159579, 0.960403, 0.626688 > ]
				[ 1.0 color rgb < 0.058503, 0.176043, 0.841474 > ]
			}
			scale 0.3
			warp {
				cylindrical 
				orientation z
				dist_exp 0.0
			}
		}
		rotate x*-5
		translate <-Move, -MoveY, -0.2>
	}

	difference {
		cylinder {
			<0, -0.8, 0>, <0, 0.6, 0>, 1.0
		}
		box {
			<-2, -0.5, -2>, <0.001, 0.7, 0.001>
			rotate y*-45
		}
		pigment {
			bozo
			color_map {
				[ 0.0 color rgb < 0.179202, 0.838148, 0.860792 > ]
				[ 0.2 color rgb < 0.159579, 0.960403, 0.626688 > ]
				[ 1.0 color rgb < 0.058503, 0.176043, 0.841474 > ]
			}
			scale 0.3
			warp {
				cylindrical 
				orientation y
				dist_exp 0.0
			}
		}
		rotate x*-5
		translate <0, -MoveY, -0.2>
	}

	difference {
		cylinder {
			<0, -0.8, 0>, <0, 0.6, 0>, 1.0
		}
		box {
			<-2, -0.5, -2>, <0.001, 0.7, 0.001>
			rotate y*-45
		}
		pigment {
			quilted
			control0 0.8
			control1 0.8
				color_map {
					[ 0.0 color rgb < 1.000000, 0.8, 1.000000 > ]
					[ 0.1 color rgb < 1.000000, 0.8, 1.000000 > ]
					[ 1.0 color rgb < 0.090013, 0.0, 0.909972 > ]
				}
			scale 0.26
			warp {
				cylindrical 
				orientation y
				dist_exp 0.0
			}
		}
		rotate x*-5
		translate <Move, -MoveY, -0.2>
	}
