//	Persistence of Vision Ray Tracer Scene Description File
//	Needs MegaPov 0.6
//	Date: 8-08-2000
//	Author: Ren Smellenbergh
//	Demo showing some of the possibilities of the blob_pigment pattern as density in media

#version unofficial MegaPov 0.6;

global_settings {
	assumed_gamma 1.0
	max_trace_level 7
}

camera {
	location <0.0, 0.0, -25>
	up y*image_height right x*image_width
	look_at <0.0, 0.0, 0.0>
	angle 45
}

light_source { <2000, 3000, -5000> rgb 1.2 }

//******* Switches for the objects in the scene *************************
#declare HelixBoxOn=1;
#declare TorusSpiralOn=1;
#declare WebOn=1;
#declare GridOn=1;
#declare PigmentOn=1;
#declare Ior = 1.1;

//******** Some parameters; please play with it ***********************
#declare Func = 0; //density_function: 0, 1, 2, 3 or 4
#declare falloffAmt = 2.8; //falloff amount
#declare InverseOn = 1;	//1=on;	0=off
#declare Ints = 5; //number of intervals for the media
#declare Samp = 3;
#declare AA_l =4.0;
#declare AA_t = 0.1;

//******** Declare a blob object that can be used in the blob_pigment ******
#declare DeclaredBlob = off;	//switch on to use the declared blob
     //if off, the same components of this blob are used, but directly in the blob_pigment

#declare Ablob =
	blob {
		#declare C = 0;
		#declare Copies = 90;
		#while ( C < Copies)
		threshold 0
		sphere {
			<0, 0, 0>, 0.18, strength 0.6
			scale <1.8, 0.5, 1.1>
			translate x*0.42
			rotate y*(C*(6.75*360)/(Copies -1))
			translate y*(-0.48 + (C*(0.48 - (-0.48))/(Copies -1)))
		} //sphere-component
		#declare C = C +1;
		#end  //while (C < Copies)
	} //blob-component

//********** Box object with media helix *************************
#if (HelixBoxOn=1)
box {
	<-0.6, -0.5, -0.6>, <0.6, 0.5, 0.6>
	texture {
		pigment { rgbt <0.0, 0.9, 0.0, 0.95> 	}
		finish {
		    ambient 0.05
		    diffuse 0.1
			reflection rgb 0.05
			specular 0.8  roughness 0.003
			phong 1  phong_size 400
			conserve_energy
		}
	}
	interior {
		ior Ior
		media {
			emission rgb <0.2, 0.9, 0.2>
			density {
				blob_pigment {
					threshold 0.2
					max_density 1.0
					#if (DeclaredBlob =1)	 //use the declared blob
						blob {
							Ablob
							strength 1
							pigment {
								cylindrical
								color_map { [ 0.0 rgb 1.2 ] [ 1.0 rgb 0.8 ] }
								scale 0.5
							}
						}
					#else //use the blob components directly in the blob_pigment
						#declare C = 0;
						#declare Copies = 90;
						#while ( C < Copies)
						threshold 0
						sphere {
							<0, 0, 0>, 0.18, strength 0.6
							density_function 0, 2.8
							scale <1.8, 0.5, 1.1>
							translate x*0.42
							rotate y*(C*(6.75*360)/(Copies -1))
							translate y*(-0.48 + (C*(0.48 - (-0.48))/(Copies -1)))
							pigment {
								cylindrical
								color_map { [ 0.0 rgb 1.2 ] [ 1.0 rgb 0.8 ] }
								scale 0.5
							}
						} //sphere-component
						#declare C = C +1;
						#end  //while (C < Copies)
					#end
				} //blob_pigment
				color_map { [ 0.0 rgb 0.8 ] [ 1.0 rgb 1.0 ] }
			} //density
			method 3
			intervals Ints
			samples Samp, Samp
			aa_level AA_l		aa_threshold AA_t
		} //media
	} //interior
	hollow
	scale <2.4, 5.3, 2.4>
	rotate <0, 50,-25>
	rotate y*-42
	translate <-6.4, 2.6, -1.0>
}
#end //(HelixBoxOn)

//********** Torus with media spiral ***************************
#if (TorusSpiralOn =1)
torus {
	3, 0.8
	sturm
	pigment { rgbt <1.0, 0.0, 0.0, 0.95> }
	finish {
	    ambient 0.05
	    diffuse 0.1
		reflection rgb 0.05
		specular 0.8  roughness 0.003
		phong 1  phong_size 400
		conserve_energy
	}
	interior {
		ior Ior
		media {
			emission rgb <1.6, 0.0, 0.0>
			density {
				blob_pigment {
					threshold 0.3
					max_density 1.0
					#declare C = 0;
					#declare Copies = 150;
					#while ( C < Copies)
						box {
							<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>, strength 0.7
							density_function Func, falloffAmt
							scale 0.3
							translate x*0.3
							rotate z*(C*(15*360)/(Copies -1))
							translate x*3
							rotate y*(C*(360)/(Copies -1))
							inverse
							pigment { rgb 1.2 }
						} //box-component
						#declare C = C +1;
					#end  //while (C < Copies)
				}
				color_map { [ 0.0 rgb 1.2 ] [ 1.0 rgb 1.2 ] }
			} //density
			method 3
			intervals Ints
			samples Samp, Samp
			aa_level AA_l
			aa_threshold AA_t
		} //media
	} //interior
	hollow
	rotate z*60
	rotate y*-85
	translate <0, 1.6, -3>
} //object-torus
#end //(TorusSpiralOn)

//************** A web-like media ************************
#if (WebOn =1)
cylinder  {
	<0.0, -0.35, 0.0>, <0.0, 0.35, 0>, 5.4
	pigment { rgbt <0.9, 0.9, 1.0, 1.0> 	}
	finish {
	    ambient 0.0
	    diffuse 0.0
	}
	interior {
		media {
			emission rgb <0.0, 0.0, 1.1>
			density {
				blob_pigment {
					threshold 0.08
					max_density 1.0
					#declare C1 = 0;
					#declare Copies1 = 12;
					#while ( C1 < Copies1)
						#declare C = 0;
						#declare Copies = 5;
						#while ( C < Copies)
							#declare Va1 = (C*5/(Copies -1));
							cylinder {
								vrotate(<Va1, 0, 0>, y*15), vrotate(<Va1, 0, 0>, y*-15), 0.25
								strength 1.3
								density_function Func, falloffAmt
								inverse
								rotate y*(C1*30)
								pigment { rgb 1.5
								}
							} //cylinder-component
							#declare C = C +1;
						#end  //while (C < Copies)
							cylinder {
								<0, 0, 0>, vrotate(<5.2, 0, 0>, y*-15), 0.3
								strength 1.3
								density_function Func, falloffAmt
								inverse
								rotate y*(C1*30)
								pigment { rgb 1.5
								}
							} //cylinder-component
						#declare C1 = C1 +1;
					#end  //while (C1 < Copies1)
				} //blob_pigment
				color_map { [ 0.0 rgb 0.9 ] [ 1.0 rgb 1.2 ] }
			} //density
			method 2
			samples Samp, Samp+5
			aa_level AA_l
			aa_threshold AA_t
			intervals Ints
		} //media
	} //interior
	hollow
	scale 0.401
	rotate z*60
	rotate y*-85
	translate <0, 1.6, -3>
} //object
#end //(WebOn)

//********* A media density created by blobbibg two pigments (gradient & cylindrical) *******
#if (PigmentOn=1)
cylinder {
	<0, -0.5, 0.0>, <0, 0.5, 0.0>, 0.6
	pigment { rgbt <0.0, 0.9, 0.9, 0.95> 	}
	finish {
	    ambient 0.05
	    diffuse 0.1
		reflection rgb 0.05
		specular 0.8  roughness 0.003
		phong 1  phong_size 400
		conserve_energy
	}
	interior {
		ior Ior
		media {
			emission rgb <0.0, 0.8, 0.8>
			density {
				blob_pigment {
					threshold 0.2
					max_density 1.0
					pigment {
						strength 1.3
						gradient y
						color_map {
							[ 0.0 rgb 0.95 ]
							[ 0.25 rgb 0.45 ]
							[ 0.5 rgb 0.05 ]
							[ 0.75 rgb 0.45 ]
							[ 1.0 rgb 0.95 ]
						}
						density_function 3, 0.5
						translate <0.0, -0.5, 0.0>
					} //pigment-component
					pigment {
						strength 0.5
						cylindrical
						color_map {
							[ 0.0 rgb 0.0 ]
							[ 0.6 rgb 1.3 ]
							[ 1.0 rgb 1.8 ]
						}
						density_function 3, 0.4
						scale <0.3, 1, 0.3>
					} //pigment-component
				} //blob_pigment
				color_map { [ 0.0 rgb 0.4 ] [ 1.0 rgb 1.1 ] }
			} //density
			method 3
			samples Samp, Samp
			aa_level AA_l
			aa_threshold AA_t
			intervals Ints
		} //media
	} //interior
	hollow
	scale <2.5, 5.5, 2.5>
	rotate z*25
	rotate y*45
	translate <6.4, 2.4, -1>
}
#end //(PigmentOn)

//************ A grid-like media composed of blobbing cylinders *************
#if (GridOn=1)
box {< -8.55, -8.5, -0.7>, < 8.55, 8.5, 0.7>
	pigment { rgbt <1.0, 1.0, 0.8, 0.95> 	}
	finish {
	    ambient 0.05
	    diffuse 0.1
		reflection rgb 0.15
		specular 0.8  roughness 0.003
		phong 1  phong_size 400
		conserve_energy
	}
	interior {
		ior Ior
		media {
			emission rgb <0.6, 0.6, 0.0>
			density {
				blob_pigment {
					threshold 0.2
					max_density 1.0
					#declare Copies = 7;
					#declare C2 = 0;
					#while ( C2 < Copies)
						cylinder {
							<-8, 0, 0>, <8, 0, 0>, 0.5
							strength 0.9
							density_function Func, 2
							translate y*(-8 + (C2 *(16)/(Copies -1)))
							pigment { rgb 1.5 }
						} //cylinder-component
						#declare C2 = C2 +1;
					#end  //while (C2 < Copies)
					#declare C = 0;
					#while ( C < Copies)
						cylinder {
							<0, -8, 0>, <0, 8, 0>, 0.5
							strength 0.9
							density_function Func, 2
							translate x * (-8 + (C * (8 - (-8))/(Copies -1)))
							pigment { rgb 1.5 }
						} //cylinder-component
						#declare C = C +1;
					#end  //while (C < Copies)
				} //blob_pigment
				ramp_wave
				color_map { [0.0 rgb 1.0] [1.0 rgb 1.5] }
			} //density
			method 3
			samples Samp, Samp
			jitter 1.0
			aa_level AA_l
			aa_threshold AA_t
			intervals Ints
		} //media
	} //interior
	hollow
	scale 0.7
	rotate z*45
	rotate x*85
	translate <0, -5.2, 6>
} //object
#end //(GridOn)

//********** White background to be reflected in objects **********
background { rgb 1.0 }

//********** Black background *******************************
polygon {
	5, 
	<-0.93338, -0.93338>,
	<0.93338, -0.93338>,
	<0.93338, 0.93338>,
	<-0.93338, 0.93338>,
	<-0.93338, -0.93338>
	pigment { rgb 0.0 }
	scale <100, 100, 1>
	translate z*16
}
