//	Persistence of Vision Ray Tracer Scene Description File
// cutaway_textures demo

#declare Demo_switch = 1; // change nr. to switch between options below
	// 1 = use keyword "cutaway_textures" to show the textures of the cut away surface.
				// the cutting object may not have any assigned texture.
				// the texture of the primary objects will show.
				// Overlapping areas get an average texture.
	// 2 = specified texture of the cutting object (blue/white leopard)
	// 3 = default texture (Red) (CSG has no texture)
	
#version unofficial MegaPov 0.5;

#default { texture { pigment { color rgb < 1, 0, 0 > } finish { phong 0.8 phong_size 450 } } }
global_settings {
	assumed_gamma 1.8
	ini_option concat("Height =",str(image_width,0,0)) //force ratio of 1/1
}

camera {
	location <0.0, 0.0, -2.5>
	up y*image_height right x*image_width
	angle 40
	look_at <0.0, 0.0, 0.0>
}

light_source {
	<10000, 6000, -8000>
	rgb <1.0, 1.0, 1.0>
	parallel
	point_at <0, 0, 0>
}

// union of four boxes with different textures, intersected with a squished sphere
intersection {
	union {
		box {
			-0.5, 0.5
			texture {
				pigment {
					agate agate_turb 0.25
					color_map {
						[ 0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
						[ 0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
						[ 0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
						[ 0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
						[ 0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
						[ 0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
						[ 0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
						[ 0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
						[ 0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
						[ 1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
					}
					scale 0.1
				}
			}
			translate y*0.33
		}
		box {
			-0.5, 0.5
			texture {
				pigment {
					gradient <0.0, 1.0, 0.0>
					color_map {
						[ 0.0 rgb <0.976608, 0.951720, 0.763378> ]
						[ 0.12 rgb <0.946807, 0.810803, 0.773190> ]
						[ 0.23 rgb <0.955001, 0.751980, 0.744976> ]
						[ 0.5 rgb <0.909804, 0.650187, 0.810315> ]
						[ 0.7 rgb <0.700710, 0.682887, 0.897093> ]
						[ 0.8 rgb <0.618387, 0.811933, 0.901595> ]
						[ 1.0 rgb <0.591974, 0.928008, 0.731991> ]
					}
					scale 0.4
				}
			}
			translate <0.66, 0.33, 0>
		}
		box {
			<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
			texture {
				pigment {
					function { x^2+y^2-0.15 }	//progressive circular
					color_map { 
					    [0.0, 0.1 color rgb <0.55, 0.32, 0.20> 
					              color rgb <0.55, 0.32, 0.20>]
					    [0.1, 0.2 color rgb <0.55, 0.35, 0.20>
					              color rgb <0.88, 0.60, 0.40>]
					    [0.2, 0.3 color rgb <0.88, 0.60, 0.40>
					              color rgb <0.60, 0.30, 0.20>]
					    [0.3, 0.4 color rgb <0.60, 0.30, 0.20> 
					              color rgb <0.60, 0.30, 0.20>]
					    [0.4, 0.9 color rgb <0.60, 0.30, 0.20>
					              color rgb <0.88, 0.60, 0.40>]
					    [0.9, 1.0 color rgb <0.88, 0.60, 0.40>
					              color rgb <0.55, 0.32, 0.20>]
					}
					ramp_wave
					scale 0.15
					warp { turbulence 0.03 }
				}
			}
			translate <0.66, -0.33, 0>
		}
		box {
			<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
			texture {
				pigment {
					function { x^(2/3)+y^(2/3)-1^(2/3) }	//astroid
					color_map {
						[ 0.0 rgb <1.0, 1.0, 1.0> ]
						[ 0.25 rgb <0.550500, 0.573785, 0.829496> ]
						[ 0.5 rgb <0.715557, 0.543984, 0.856001> ]
						[ 0.75 rgb <0.845991, 0.453986, 0.748013> ]
						[ 1.0 rgb <0.945006, 0.554986, 0.906050> ]
					}
					cubic_wave
					scale 0.1
				}
			}
			translate <0.0, -0.33, 0>
		}
	}
	sphere {	// cutting object
		<0.33, 0.0, 0.0>, 0.82
		scale <1, 1, 0.2>
	}
	#if (Demo_switch = 1)
		cutaway_textures
	#end
	#if (Demo_switch = 2)
		texture {	//blue spots
			pigment {
				leopard
				color_map {
					[ 0.000 rgb <1.0, 1.0, 1.0> ]	//white
					[ 1.000 rgb <0.0, 0.0, 1.0> ]	//blue
				}
				scale 0.05
			}
		}
	#end
	translate x*-0.33
}
