//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.5;

global_settings{
  ambient_light 1/1000
#declare high_quality=no;
#if(high_quality)        
  // High Quality - slow rendering
  ini_option "+QR"
  radiosity{
	pretrace_start 0.08
	pretrace_end 0.04
    count 50             // CHANGE range from 20 to 150 (higher is usually pointless)
    nearest_count 5      // CHANGE range from 3 to 10   (higher is usually pointless)
    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
                         //   1 : preview_end_size = 4
                         //   3 : preview_end_size = 8
                         //   use preview_start_size = 16
                         // you can go lower than 1, but then you probably will want to set
                         // preview_end_size to 2, which is really slow
    recursion_limit 4    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1.25         // exaggerated
    
    max_sample 2         // CHANGE - this should be the same as the brightest object
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
#else
  // Medium Quality - works for most scenes
  ini_option "+QR"
  radiosity{
	pretrace_start 0.16
	pretrace_end 0.08
    count 35             // CHANGE range from 20 to 150 (higher is usually pointless)
    nearest_count 5      // CHANGE range from 3 to 10   (higher is usually pointless)
    error_bound 2.0     // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
                         //   1 : preview_end_size = 4
                         //   3 : preview_end_size = 8
                         //   use preview_start_size = 16
                         // you can go lower than 1, but then you probably will want to set
                         // preview_end_size to 2, which is really slow
    recursion_limit 2    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 2         // exaggerated
    
    max_sample 2         // CHANGE - this should be the same as the brightest object
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
#end
}

camera { location -z*17 look_at 0 }

// Room
difference
{ box { <-12,-9,-19><12,9,12> }
  box { <-11,-8,-18><11,8,11> }
  pigment { rgb <1,1,.8> }
}
box
{ <-11,-8,-18><-10.99,8,11>
  pigment { rgb <1,.5,0> }
}
box
{ <11,-8,-18><10.99,8,11>
  pigment { rgb <0,.5,1> }
} 

#declare Light=
  union
  { box { <-1,-.2,-1><1,.2,1> no_shadow pigment { rgb 1 } finish { ambient .25*4*1000 } }
    light_source
    { 0, 1 area_light x*2,z*2,10,10 adaptive 0
    }
  }
  
object { Light rotate z*-45 translate <10,7,8> }

union
{ box { <-.4,-8,-4><.4,-1,4> }
  box { <-.4,-1,-4><-6,-1.5,4> }
  pigment { rgb <1,.8,.4> }
  translate x*3+z*4
}
box { <-3,-8,0><3,-.5,-1> pigment { rgb <1,.7,.7> } rotate y*-45 translate <-9.5,0,9.5> }

#declare Jar=
  sor
  { 8
    <0,0><2,0><2.1,.4><2,.8><2.5,5>
    <1.5,7><2,8><2.1,8>
    sturm
    pigment { rgb 1 } finish { specular .2 }
    scale .5
  }
  
object { Jar translate -y+z*4 }

#declare Jar2=
  sor
  { 9
    <0,0><1,0><2.5,1.2><3,3><2.5,4.5>
    <1,7><1,8><1.5,8.5><2,8.5>
    sturm
    pigment { rgb <1,.5,.2> } finish { specular .2 }
    scale .5
  }

object { Jar2 translate <0,-8,4> }

