/*

This scene demonstrates blinn highlights and post processing in MegaPov 0.4

Author: Nathan Kopp


 Here is the syntax for post processing used in this file:

 soft_glow{amount, blur}
// 
*/

#version unofficial MegaPov 0.4;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0


  // **** soft glow ****  
  post_process {soft_glow{1.0, 8}}
}


// ----------------------------------------
camera
{
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color rgb 1  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------
plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

$a=0;
#while(a<100)
sphere { 0.0, 1 
//box{
  //-1,1
  //scale <1,.1,1>
  texture {
    pigment {radial frequency 8} 
    //finish{ phong .6 }
    //finish{ specular .6 roughness .05 }
    finish{ blinn 1 facets .2 }
  }
  interior{
    ior 20
  }
  //rotate -70*x
  translate -3*x
  translate z*a
}

sphere { 0.0, 1 
//box{
  //-1,1
  //scale <1,.1,1>
  texture {
    pigment {radial frequency 8} 
    //finish{ phong .6 }
    //finish{ specular .6 roughness .05 }
    finish{ blinn 1 facets .2 }
  }
  interior{
    ior 20
  }
  //rotate -70*x
  translate 3*x
  translate z*a
}

$a=a+10;
#end


// red stretched sphere is very close to the camera

sphere { 0.0, 1 
  texture {
    pigment {color rgb <1,.2,.2>} 
    finish{ blinn 1 facets .2 }
    //finish{diffuse 0 ambient 1}
  }
  interior{
    ior 20
  }
  scale <.003,1,.003>
  translate -3.7*z+.1*x
}

