/*

This scene demonstrates blinn highlight & post processing in MegaPov 0.4

Author: Nathan Kopp


 Here is the syntax for post processing used in this file:

 focal_blur{ field_start, depth_of_field, max_pixel_blur }
*/

#version unofficial MegaPov 0.4;

$keep_aa = 1.0;

#include "colors.inc"
#include "skies.inc"
#include "stones.inc"
#include "woods.inc"

global_settings {
  assumed_gamma 1.0
  //post_process { focal_blur{ 5, 9.5, 6, keep_aa}}  // normal
  //post_process { focal_blur{ 9.5, 5, 8, keep_aa}}  // exaggerated
  post_process {focal_blur{ 11, 2, 6, keep_aa }}    // more exaggerated
  //post_process {focal_blur{ 0, 3, 6, keep_aa}}     // close in focus - far not
  //post_process {focal_blur{ 4, 20000000, 6, keep_aa}}  // focal dist 4 POV units to 20 million
}


// ----------------------------------------
camera {
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  S_Cloud1
  
  /*
  // use this sky_sphere to show problems with using keep_aa
  //   in the post-process focal blur
  pigment{
    checker rgb 1, rgb 0
  scale .02
  }
  */
}

light_source {
  0*x // light's position (translated below)
  color rgb 1  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------
plane { 
	y, -1 
	//pigment {color rgb <0.7,0.5,0.3>}
	texture{
		#version official 3.1;
		T_Stone18
		#version unofficial MegaPov 0.5;
	}
}

$a=0;
#while(a<100)
sphere { 0.0, 1 
//box{
  //-1,1
  //scale <1,.1,1>
  texture {
    pigment {radial frequency 8} 
    //finish{ phong .6 }
    //finish{ specular .6 roughness .05 }
    finish{ blinn 1 facets .2 }
  }
  interior{ ior 20 }
  //rotate -70*x
  translate -3*x
  translate z*(a+3)
}

sphere { 0.0, 1 
//box{
  //-1,1
  //scale <1,.1,1>
  texture {
    pigment {radial frequency 8} 
    //finish{ phong .6 }
    //finish{ specular .6 roughness .05 }
    finish{ blinn 1 facets .2 }
  }
  interior{
    ior 20
  }
  //rotate -70*x
  translate 3*x
  translate z*(a+3)
}

$a=a+10;
#end


// red stretched sphere is very close to the camera

sphere { 0.0, 1 
  texture {
//    pigment {color rgb <1,.2,.2>} 
//    finish{ blinn 1 facets .2 }
//    finish{diffuse 0 ambient 1}
    #version official 3.1;
    T_Wood12
    #version unofficial MegaPov 0.5;
  }
  interior{ ior 20 }
  scale <.003,1,.003>
  translate -3.7*z+.1*x
}

