//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

/*
   Three Lenses 2
   Photon Mapping Test Scene
   Nathan Kopp
   Spring, 1999
*/

#include "colors.inc"
#include "woods.inc"

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  photons { 	
    spacing 0.025*5
    autostop 0
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      1.287+3.5,     -17.525*.65,      16.135*.65>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      3.189-1.5,      -1.209-.5,      -0.315>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <-12, 2, 2>
  color rgb <1.000, 0.000, 0.000>*200
  fade_distance 1
  fade_power 2
}
light_source {   // Light1
  <-12, 0, 2>
  color rgb <0.000, 1.000, 0.000>*200
  fade_distance 1
  fade_power 2
}
light_source {   // Light1
  <-12, -2, 2>
  color rgb <0.000, 0.000, 1.000>*200
  fade_distance 1
  fade_power 2
}

//
// ********  TEXTURES  *******
//

#declare Glass1 = 
   material  {// Glass1
      texture {      
         pigment { color rgbf <1.0, 1.0, 1.0, 0.7> }      
         finish {
            ambient 0.0
            diffuse 0.0
            specular 1.0
            roughness 0.001
            reflection 0.1
         }
      }   
      interior { ior 1.5 }
   }


#declare Bright_Bronze = 
   material  {		// Bright_Bronze
      texture {      
         pigment { color rgb <0.36, 0.28, 0.2> }      
         finish {
            ambient 0.1
            diffuse 0.65
            brilliance 1.5
            specular 0.85
            roughness 0.01
            reflection 0.8
         }
      }
   }

//
// ********  REFERENCED OBJECTS  *******
//

#declare Lens1 = intersection { // Lens1
  sphere { // Sphere001
    <0,0,0>,1
    scale <0.5, 1.0, 1.0>
    translate  -0.25*x
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale <0.5, 1.0, 1.0>
    translate  0.25*x
  }
  scale 2.0
}

//
// ********  OBJECTS  *******
//
#if(1)
box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  material { Bright_Bronze }
  rotate 15.793823*z
  translate  <3.841741, -2.857446, 1.143055>
  photons {
	target 0.2
    reflection on
  }
}

box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  //rotate 15.793823*z
  texture {
    pigment{rgb<0,0,1>}
    rotate 64.078362*x
  }
  translate  <5.841741, .7, 1>
}
#end

object { // Lens4->Lens1
  Lens1
  material { Glass1 }
  translate  -4*y
  photons {
	  target 0.7
    refraction on
  }
}

object { // Lens3->Lens1
  Lens1
  material { Glass1 }
  photons {
	  target 0.7
    refraction off
  }
}


object { // Lens2->Lens1
  Lens1
  material { Glass1 }
  translate  <0,4, 0.0>
  photons {
	  target 0.7
    refraction on
  }
}


box { // Floor
  <-1, -1, -1>, <1, 1, 1>
  scale <10.0, 10.0, 0.1>
  texture {
    T_Wood1
    scale 5
    rotate <84.078362,0,-20>
    // Transform to parent space
  }
}




