// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version unofficial MegaPov 0.4;


#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------
plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

//sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} }

/*
mesh
{
  smooth_triangle {<-1,0,0>,<-1,0,0>,
            <0,0,-1>,<0,0,-1>,
            <0,1,0>,<0,1,0>}
  smooth_triangle {<-1,0,0>,<-1,0,0>,
            <0,0,1>,<0,0,1>,
            <0,1,0>,<0,1,0>}
  smooth_triangle {<1,0,0>,<1,0,0>,
            <0,0,1>,<0,0,1>,
            <0,1,0>,<0,1,0>}
  smooth_triangle {<1,0,0>,<1,0,0>,
            <0,0,-1>,<0,0,-1>,
            <0,1,0>,<0,1,0>}

  triangle {<-1,0,0>,<0,0,-1>,<0,-1,0>}
  triangle {<-1,0,0>,<0,0,1>,<0,-1,0>}
  triangle {<1,0,0>,<0,0,1>,<0,-1,0>}
  triangle {<1,0,0>,<0,0,-1>,<0,-1,0>}
  texture {pigment {radial frequency 8} finish{specular 1}}
}
*/

mesh2
{
  normal_vectors{
    6
    <-1,0,0>,<0,-1,0>,<0,0,-1>
    < 1,0,0>,<0, 1,0>,<0,0, 1>
  }  
  vertex_vectors{
    6
    <-1,0,0>,<0,-1,0>,<0,0,-1>
    < 1,0,0>,<0, 1,0>,<0,0, 1>
  }

  face_indices{
    8
    <0,2,4>,<3,5,4>,<0,3,4>,<3,2,4>
    <0,2,1>,<3,5,1>,<0,3,1>,<3,2,1>
  }
  normal_indices{
    4
    <0,2,4>,<3,5,4>,<0,3,4>,<3,2,4>
    //<0,2,1>,<3,5,1>,<0,3,1>,<3,2,1>
  }
  texture {pigment {radial frequency 8} finish{specular 1}}
}
