//	Persistence of Vision Ray Tracer Scene Description File
//	File: parametric_helicoid.pov
//	Date: 15/11/99
//	Demo showing parametric isosurface
	
#version unofficial MegaPov 0.4;

#include "colors.inc"
#declare BoxV = 4;

parametric { 
	function u*sin(5*v), v, u*cos(5*v) 
	<0, -3>, <3, 3> 
	<-BoxV,-BoxV,-BoxV>, <BoxV, BoxV, BoxV> 
	accuracy 0.001 
	precompute 15, [x, z] 
	pigment  {
		cylindrical
		color_map {
			[0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
			[0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
			[0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
			[0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
			[0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
			[0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
			[0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
			[0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
			[0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
			[1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
		}
		scale < 4, 1, 4 >
	}
} 

camera { 
	location  < 16, 8,-10>
	look_at   < 0, 0, 0>
	angle 30
} 

light_source { <20, 10, -20> rgb 2.5 }

background { White }