/* isoblob_test3.pov */
#version unofficial MegaPov 0.4;

#include "colors.inc"
#include "textures.inc"

camera {
  location <0,0,-10>
  direction z*1.5
  up y right x*4/3
  look_at 0
  }

light_source {<-5,10,-5> color White}

#declare F1=function{
  1/sqrt(1 +sqr(x+noise3d(x*5,y*5,z*5)-0.5)
           +sqr(y+noise3d(x*5,y*5,z*5+50)-0.5)
           +sqr(z+noise3d(x*5,y*5,z*5+100)-0.5))
  }

isoblob {
  threshold 0.2
  accuracy 0.001
  max_trace 10
  normal
  
  function {max(1-2*sqrt(sqr(sqrt(sqr(x)+sqr(y))-2)+sqr(z)),0)}
  function {max(1-2*sqrt(sqr(x)+sqr(y)),0)*max(min(4-sqr(r)-sqr(s),1),0)}

  sphere {<0,0,0>, 3 strength 1 function 1}
  cylinder {<0,0,0>, <2,0,0>, 1 strength 0.5 function 2 rotate -30*z}
  cylinder {<0,0,0>, <-2,0,0>, 1 strength 0.5 function 2 rotate 30*z}
  cylinder {<0,2,0>, <0,-2,0>, 1 strength 0.5 function 2}

  hollow
  interior {media {intervals 30 density{function{F1}} emission <1.2,0.7,0.3>*2.5}}

  texture {Glass}
  }

plane {
  -z,-5
  texture {
    pigment {checker color Gray10 color Black}
    finish {ambient 1 diffuse 0}
    }
  }