// Persistence Of Vision raytracer version 3.1e isosurface patch
// sample file. By R.Suzuki.
// This image contains an example of 'isosurface' using library "i_nfunc" and "i_algbr".
#version unofficial MegaPov 0.4;

#include "colors.inc"
#include "textures.inc"

//------  declare Objects ------------

#declare PsObject =
object {
	isosurface {
		function {"func_13", <4.3>, library "i_nfunc"}
		contained_by{ box { <-5, -0.15, -5>, <5, 0.15, 5>} }
		max_gradient 1.5
		max_trace 2
		texture {
			pigment{White_Marble scale 0.2}
			finish {phong 1.0}
		}
		rotate y*10
		translate <3.5, 0, 4.0>
	}
}

#declare Ps2Object =
object {
	isosurface {
		function  {"func_13", <5>, library "i_nfunc"}
		contained_by{ box {<-5.5, -1, -5.5>, <5.5, 1, 5.5>}	}
		max_gradient 1.5
		texture {
			pigment {Blue_Agate}
			finish { phong 1.0}
		}
		rotate y*34
		scale <1,0.3,1>
		translate<3.5,0,3>
	}
}

#declare Cy1Object =
object {
	isosurface {
		function  {"func_9", <1, 0, -1, 0, 0.5>, library "i_nfunc"}
		contained_by{ box {<-1.5, -1.6, -1.5>, <1.5, 1.6, 1.5>}}
		max_gradient 1.1
		texture {
			pigment {color red 0.12 green 0.2 blue 0.2 }
			finish { phong 1.0 reflection 0.7 }
		}
		scale <0.8, 1.2, 0.8>
	}
	translate <2.2,2,-5.2>
}

//------------------------------------------------
camera {
	location <24, 28, -40>
	angle 27
	look_at <0,1,0>
}

light_source { < 130, 220, -180 > color rgb < 1.0, 1.0, 1.0 > }
light_source { < 0, 240, 0 > color rgb < 0.8, 0.8, 0.8 > }
light_source { < 80, 40, -10 > color rgb < 1.0, 1.0, 1.0 > }

object {  Cy1Object  }
object {  Cy1Object  scale <-1,1,1>  }
object {  Cy1Object  scale <-1,1,-1> }
object {  Cy1Object  scale <1,1,-1>  }


object {
	difference {
		isosurface {
			function {"func_0", <0.5, 1.25, 0.5>, library "i_nfunc"}
			contained_by{ box {<-8.8, -1, -10>, <8.8, 1, 10>}}
			threshold 5.7
			max_gradient 1.25
			scale <1,0.125,1>
		}
		isosurface {
			function { "func_2", <16, 0.01, 6.0, 3., 0.>, library "i_nfunc"}
			contained_by{ box {<-8, -0.15, -8>, <8, 0.15, 8>}}
			threshold -1.
			max_gradient 4.9
			max_trace 2
			texture	{
				pigment { Brown_Agate scale 0.2 }
				finish { phong 1.0}
			}
		}
		object{ PsObject   }
		object{ PsObject   scale <-1,1,1>  }
		object{ PsObject   scale <-1,1,-1> }
		object{ PsObject   scale <1,1,-1>  }
	}
	scale <1,2.4,1>
	texture {
		PinkAlabaster
		finish { phong 0.3}
	}
}

//------------ MESH ----------------------
isosurface {
	function  {"mesh1", <2, 2, 1.0, 0.184,  1>}
	threshold    0.25
	contained_by { box {<-15.5, -0.5, -16.5>, <15.5, 0.5, 16.5>	}	}
	max_gradient 2.1
	texture {
		pigment { color red 0.35 green 0.28 blue 0.18	}
		finish { phong 1.0 reflection 0.8 }
	}
	scale <0.5, 0.5, 0.5>
}

union {
	object{ Ps2Object  }
	object{ Ps2Object  scale <-1,1,1>  }
	object{ Ps2Object  scale <-1,1,-1> }
	object{ Ps2Object  scale <1,1,-1>  }
	scale <0.8, 1.0, 0.8>
	translate y*4
	rotate y*90
}

//------------ MESH ----------------------
isosurface {
	function { "mesh1", <1.5, 1.5, 1.0, 0.12,  1>}
	contained_by{ box {<-11, -0.4, -11>, <11, 0.4, 11>}}
	threshold    0.15
	max_gradient 2.1
	texture {
		pigment {color red 0.28 green 0.28 blue 0.28}
		finish { phong 1.0 reflection 1.0}
	}
	scale <0.5, 0.5, 0.5>
	translate y*4
}

//----------------------------------------------
union {
	isosurface {
		function   {"Algbr_Cyl1", <0.5,0.5,1,1,90>,  library "i_algbr"}
		contained_by{ box {<-2., -1.1, -2>, <2., 1.1, 2>}}
		max_trace 2
		texture {
			pigment {color red 0.85 green 0.85 blue 0.6 filter 0.9}
			finish { phong 0.8 reflection 0.2}
		}
		interior { ior 1.5 }
		scale 1.2
		translate <6, 1.5, 2.5>
	}
	isosurface {
		function  {"Algbr_Cyl1", <0.3,15,1,0,0>, library "i_algbr"}
		contained_by{ box {<-1.1, -1, -1.1>, <1.1, 1, 1.1>}}
		texture {
			pigment {color red 0.5 green 0.6 blue 0.9 filter 0.9}
			finish {phong 0.8 reflection 0.2}
		}
		interior { ior 1.5 }
		scale 2
		translate <-6, 1.3, -2.5>
	}
	isosurface {
		function  {"Pillow", <.17>, library "i_algbr"}
		contained_by{ box {<-1.18, -1.18, -1.18>, <1.18, 1.18, 1.18>}}
		texture {
			pigment {color red 0.7 green 0.95 blue 0.5 filter 0.85}
		       finish {phong 1.0 reflection 0.2}
		}
		interior { ior 1.5 }
		scale <1.25, 1, 1.25>
		translate <6, 1.47, -2.5>
	}
	isosurface {
		function  {"Piriform", <0.8>, library "i_algbr"}
		contained_by{ box {<-0., -.5, -.5>, <1, .5, .5>}}
		texture {
		     pigment {color red 0.9 green 0.7 blue 0.67 filter 0.9}
		     finish { phong 0.8 reflection 0.2}
		}
		interior { ior 1.5 }
		rotate <0,0,-90>
		scale 4
		translate <-6, 4.3, 2.5>
	}
	scale <0.8, 1.0, 0.8>
	translate y*4
	rotate y*90
}

background { color Gray20 }
