//	Persistence of Vision Ray Tracer Scene Description File
//	File: round_trim_bezierd.pov
//	Date: 15/11/99
//	Demo showing trimmed bezier surfaces
	
#version unofficial MegaPov 0.4;

union {
	bezier_patch {	//one quarter of cylinder
		3, 2
		accuracy 0.01
		rational
		<0, 1, 0, 1>, <1, 1, 0, 1>, <1, 1, 1, 2>,
		<0, -1, 0, 1>, <1, -1, 0, 1>, <1, -1, 1, 2>
	trimmed_by {
		type  0
		#declare c=20;
		#declare rel= 1/2  ;    
		#declare i=c;
		#while (i!=0)
			2  <cos (pi/c), sin (pi/c)>*rel, <1, 0>
			rotate 360/c
			#declare i= i -1;
		#end      
		scale 0.4
		translate <0.5,0.5>
	}
		translate -z
		texture {
			pigment { color <1,0,0> }
			finish { ambient 0.1 diffuse 0.9 phong 1 }
		}
	}
	bezier_patch {	//one quarter of cylinder
		2,3
		accuracy 0.01
		rational
		<0, 1,0,1>,  <0,-1,0,1>,  
		<1, 1,0,1>,  <1,-1,0,1>,
		<1, 1,1,2>,  <1,-1,1,2>
	trimmed_by {
		type  0
		#declare i=4;
		#while (i!=0)
			2 <0,1>, <1/4,1/4>
			rotate 90
			#declare i= i -1;
		#end      
		scale 0.3
		translate <0.5,0.5>
	}
		translate -z
		rotate  y * 90 
		//  translate  x 
		texture {
			pigment { color <0,1,0> }
			finish { ambient 0.1 diffuse 0.9 phong 1 }
		}
	}
#declare vert=6;
#declare cykl=vert;
#declare star =
	trimmed_by {
		type 0
		#while (cykl > 0)
			3  
			#if (cykl=vert) <cos(2 * pi/vert),sin(2 * pi/vert)> #else previous #end
			<0,0>
			#if (cykl=1)  first #else <1,0> #end 
				rotate 360/vert
			#declare cykl=cykl-1;
		#end		    
	}
	bezier_patch {	//one quarter of cylinder
		3,2
		accuracy 0.01
		rational
		<0, 1,0,1>, <1, 1,0,1>, <1, 1,1,2>,
		<0,-1,0,1>, <1,-1,0,1>, <1,-1,1,2>
	trimmed_by {
		star
		type  0
		scale 0.4
		translate <+.5,+.5>
	}
	trimmed_by {
		star
		scale 0.15
		rotate 180 / vert
		translate <0.5,0.5>
		type 1
	}
		translate -z
		rotate  y * 180
		//  translate  x 
		texture {
			pigment { color <0,0,1> }
			finish { ambient 0.1 diffuse 0.9 phong 1 }
		}
	}
	bezier_patch {	//one quarter of cylinder
		3,2
		accuracy 0.01
		rational
		<0, 1,0,1>, <1, 1,0,1>, <1, 1,1,2>
		<0,-1,0,1>, <1,-1,0,1>, <1,-1,1,2>
	trimmed_by {
		type  0
		#declare i=4;
		#while (i!=0)
			// 3 rational <0,1,1>, <1,1,1>, <1,0,2>
			3 <0,1>, <1,1>, <1,0>
			rotate 90
			#declare i= i -1;
		#end      
		scale 0.3
		translate <0.5,0.5>
	}
		translate -z
		rotate  y * 270
		//  translate  x 
		texture {
			pigment { color <1,0,1> }
			finish { ambient 0.1 diffuse 0.9 phong 1 }
		}
	}
	rotate y*-105
	translate x*-1.1
}


union {
	bezier_patch {	//one quarter of cylinder
		3,2
		accuracy 0.01
		rational
		<0, 1,0,1>, <1, 1,0,1>, <1, 1,1,2>
		<0,-1,0,1>, <1,-1,0,1>, <1,-1,1,2>
	trimmed_by {
		type  1
		#declare c=20;
		#declare rel= 1/2  ;    
		#declare i=c;
		#while (i!=0)
			2  <cos(pi/c),sin(pi/c)>*rel, <1,0>
			rotate 360/c
			#declare i= i -1;
		#end      
		scale 0.4
		translate <0.5,0.5>
	}
		translate -z
		//   rotate  z * 180
		//  translate  x 
		texture {
			pigment { color <1,0,0> }
			finish { ambient 0.1 diffuse 0.9 phong 1 }
		}
	}
	bezier_patch {	//one quarter of cylinder
		2,3
		accuracy 0.01
		rational
		<0, 1,0,1>,  <0,-1,0,1>, 
		<1, 1,0,1>,  <1,-1,0,1>, 
		<1, 1,1,2>,  <1,-1,1,2>
	trimmed_by {
		type  1
		#declare i=4;
		#while (i!=0)
			2 <0,1>, <1/4,1/4>
			rotate 90
			#declare i= i -1;
		#end      
		scale 0.3
		translate <0.5,0.5>
	}
		translate -z
		rotate  y * 180
		texture {
			pigment { color <0,1,0> }
			finish { ambient 0.1 diffuse 0.9 phong 1 }
		}
	}
	cylinder 	{
		<0,-1,0>, <0,1,0>, 1
		open
		texture {
			pigment { color <0,0,1>  }
			finish {ambient 0.1 diffuse 0.9 phong 1 }
		}
		clipped_by { box { <-1,-1,-1>, <0,1,0> } }
	}
	bezier_patch {	//one quarter of cylinder
		2,3
		accuracy 0.01
		rational
		<0, 1,0,1>,  <0,-1,0,1>, 
		<1, 1,0,1>,  <1,-1,0,1>, 
		<1, 1,1,2>,  <1,-1,1,2>
	trimmed_by {
		type  1
		#declare i=4;
		#while (i!=0)
			// 3 rational <0,1,1>, <1,1,1>, <1,0,2>
			3 <0,1>, <1,1>, <1,0>
			rotate 90
			#declare i= i -1;
		#end      
		scale 0.3
		translate <0.5,0.5>
	}
		translate -z
		rotate  y*(-90)
		texture {
			pigment { color <1,1,0> }
			finish { ambient 0.1 diffuse 0.9 phong 1 }
		}
	}
	rotate y*65
	translate x*1.1
}

light_source {
	<0,100,-30>
	color <1,1,1>*1.5
}

background { color <0,0,1.0> }

camera {
	location <0, 1.5, -7>

	right x*image_width up y*image_height
	look_at <0,0,0>
	angle 40
}

