#version unofficial MegaPov 0.4;


//This scene is a demo of my eval_pigment patch, which is different from 
//the eval_pattern patch in that it returns a color instead of a float, 
//and takes a pigment. It probably doesn't work correctly with transparent 
//pigments, because it actually returns a vector instead of a color. I 
//might enhance it and add a class of functions which return a color.
//Note that my most recently released patch includes the reflectivity 
//patch, which I plan to remove in the next version. I have a few things I 
//would like to change about it, and it isn't backwards compatable.

//*******************************************
#include "colors.inc"
//-------------------------------------------
global_settings {
   assumed_gamma 1.8
}

camera {
   location < 1, 4, -7>
   angle 40
   look_at < 0, 0, 0>
}
//*******************************************
#declare xSize = 80;
#declare zSize = 80;
//it is not required that the pigment be declared,
//but it makes cleaner looking code.
#declare testPigment =
pigment {crackle
   color_map {
      [0 color Blue]
      [0.3 color Red]
      [0.67 color Yellow]
      [1 color White]
   }
   scale 0.5
}

union {
   #declare J=0;
   #while(J< xSize)
         #declare L=0;
         #while(L< zSize)
            #declare Pos = <(J-(xSize/2))/xSize, 0, (L-(zSize/2))/zSize>*2;
            #declare Col = eval_pigment(pigment {testPigment}, Pos);
//            #declare Col = eval_pigment(
//pigment {crackle
//   color_map {
//      [0 color Blue]
//      [0.3 color Red]
//      [0.67 color Yellow]
//      [1 color White]
//   }
//   scale 0.5
//}, Pos)
            sphere {< (1/xSize)/2, 0.01, (1/zSize)/2>, 0.01
               pigment {color Col}
               finish {ambient 1 diffuse 1}
               translate Pos
            }
            #declare L=L+1;
      #end
      #declare J=J+1;
   #end
   scale 2
}


//*******************************************

light_source { < -30, 75, -60 >*100 color White }
light_source { < 30, 15, -30 >*100 color White*0.25}

//-------------------------------------------

