// This shows how splines can be used in animations
// render with : 
// Initial_Frame=0
// Final_Frame=20
// Initial_Clock=0
// Final_Clock=1
#version unofficial MegaPov 0.4;


#include "colors.inc"
#include "skies.inc"

camera {location <4.5, 4.5, 4.5> look_at <0.3, 1.3, 0> }

light_source { <-15, 30, -25> color red 1 green 1 blue 1 }
light_source { < 15, 30, -25> color red 1 green 1 blue 1 }
light_source { < -1, 1, 10> color red 1 green 1 blue 1 }
light_source { < 0, 1, 0> color red 1 green 1 blue 1 }

#init_3d_spline {"My_Spline",closed
                            #declare c=0;
                            #while (c<1.001)
                               ,<2*sin(15*c),c*3,2*cos(15*c)>
                               #declare c=c+0.05;
                            #end
                            }


blob {
  threshold 0.6
  #declare c=0;
  #while (c<0.05)
   sphere { eval_3d_spline("My_Spline",c+clock),0.2,1.5 }
   #declare c=c+0.008;
  #end
  texture {
    finish {
      ambient 0.3
      diffuse 0.8
      phong 1
    }
    normal {
      bumps 0.4
      sine_wave
      scale 0.08
    }
    pigment { color Red }
  }
}
