// Persistence Of Vision raytracer version 3.1e (isosurface patch)
// sample file by R.Suzuki   <rsuzuki@etl.go.jp>  Apr.'99
#version unofficial MegaPov 0.4;

#include "colors.inc"

camera {
   location <15, 40, -35>
   direction <0, 0,  5.5>
   look_at <0,0,0>
}

light_source {<-50, 40, -20> color White}
light_source {<  0, 40, -50> color White}
background {color DarkSlateGray}

#declare R0=2.0;
#declare R1=0.5;
#declare L0=2.8;
#declare BBOXL = < -(R0+R1), -R1, -(R0+R1)>;
#declare BBOXH = <(R0+R1), R1, (R0+R1)>;

#declare FUNC1= function{"torus", <R0,R1>}
#declare FUNC2= function{sqrt(sqr(sqrt(sqr(x)+sqr(z))-R0)+sqr(y)) -R1 }

//----- All of following four objects should give us same shape.  ------------

isosurface {
     function {FUNC1}   contained_by{ box{BBOXL, BBOXH}}   method 1
     pigment {Green}
     translate <-L0, 0, L0>
}

isosurface {
     function {FUNC1}   contained_by{ box{BBOXL, BBOXH}}   method 2
     pigment {Blue}
     translate < L0, 0, L0>
}

isosurface {
     function {FUNC2}   contained_by{ box{BBOXL, BBOXH}}  method 1
     pigment {Red}
     translate <-L0, 0,-L0>
}

isosurface {
     function {FUNC2}  contained_by{ box{BBOXL, BBOXH}}  method 2
     pigment {Yellow}
     translate < L0, 0,-L0>
}
//------------------------------------------------------------------------
