// Persistence Of Vision raytracer version 3.1e isosurface patch
// sample file. By R.Suzuki.
// This image contains an example of 'isosurface'.
#version unofficial MegaPov 0.4;

#include "colors.inc"
#include "textures.inc"

camera {  
	location <24, 35, -45>
	direction <0, 0,  4.0>
	look_at <0, 0, 0>
}

light_source {	<150, 400, -120> color White}
light_source {	<350, 200, -120> color White}

isosurface {  
	function  { "func_12", <6., 9, 3, 0, 1.0, 1.2, 0.13, -6, 0.1,-64>, library "i_nfunc"}
	contained_by { box { <-9, -3, -9>, <9, 3, 9> }}
	eval
	max_gradient 2.0
	accuracy     0.01
	texture {
		pigment {	color red 0.05 green 0.05 blue 0.1	}
		finish { phong 1.0 reflection 0.6	}
	}
   no_shadow
}

isosurface {  
 	function { "func_12", <6., -30, 5, 0, 0.12, 2.75, 0.03, -6, 0.1,-64>, library "i_nfunc" }
    contained_by { box { <-10, -4, -10>, <10, 4, 10> } }
	eval <1.0, 1.3, 0.997>
//     max_gradient 4.0
//     accuracy     0.005
     texture {
		pigment { Brown_Agate }
		finish { phong 1.0}
	}
	no_shadow
}

object {
	plane {<0, 1, 0>, 0 }
	texture { pigment { White_Marble } }
	scale 70
	translate <0, -40, 0>
	no_shadow
}

background {color DarkSlateGray }

