// Persistence Of Vision raytracer version 3.0 (isosurface)
// sample file.
// By R.Suzuki
// This image contains an example of 'isosurface'.
#version unofficial MegaPov 0.4;
#include "colors.inc"
#include "textures.inc"

#declare D3DFUNC = function {"odd_sphere", <1.0, -0.25, 0.4>, library "i_dat3d","test1.dat", <5,5,5,0>}

#declare ISOCOL= pigment {
     function {D3DFUNC}
     color_map
    {[0.0, 0.01 color red 0.8 green 0.6 blue 0.5  color red 0.8 green 0.6 blue 0.5]
     [0.01, 0.2 color red 0.5 green 0.5 blue 1.1  color red 0.5 green 0.5 blue 1.1]
     [0.2, 0.22 color red 0.0 green 0.0 blue 0.0  color red 0.0 green 0.0 blue 0.0]
     [0.22, 0.4   color red 0.7 green 0.5 blue 1.1   color red 1.1 green 0.5 blue 1.1]
     [0.4, 0.43   color red 0.0 green 0.0 blue 0.0   color red 0.0 green 0.0 blue 0.0]
     [0.43, 0.6   color red 0.5 green 0.7 blue 1.1   color red 0.5 green 1.1 blue 1.1]
     [0.6, 0.63  color red 0.0 green 0.0 blue 0.0   color red 0.0 green 0.0 blue 0.0]
     [0.63, 0.78  color red 0.6 green 1.1 blue 0.9   color red 0.6 green 1.1 blue 0.6]
     [0.78, 0.80 color red 0.0 green 0.0 blue 0.0   color red 0.0 green 0.0 blue 0.0]
     [0.80, 0.89 color red 0.7 green 1.1 blue 0.5   color red 1.1 green 1.1 blue 0.5]
     [0.89, 0.91 color red 0.0 green 0.0 blue 0.0   color red 0.0 green 0.0 blue 0.0]
     [0.91, 0.98 color red 1.1 green 0.9 blue 0.5   color red 1.1 green 0.6 blue 0.5]
     [0.98, 0.99 color red 0.0 green 0.0 blue 0.0   color red 0.0 green 0.0 blue 0.0]
     [0.99, 1.001 color red 0.8 green 0.6 blue 0.5  color red 0.8 green 0.6 blue 0.5]
     }
     frequency .7
   }

camera { location <65, 25, 35> direction <0, 0, 6.0> look_at <0,1,1> }

light_source {<40, 180, 10> color White}
light_source {<-20, 40, 120> color White}
light_source {<80, 20, 80> color White}
background {color DarkSlateGray}

object{
  difference{
    isosurface
    {
      function   {D3DFUNC}
      contained_by {box {<-3.4, -3.7, -5.8> <3.4, 3.7, 5.8>}}
      eval
      max_gradient 2.2
      accuracy 0.01
      max_trace 5
    }
    box{<0,0,0>, <7,7,7>}
  }
  pigment {ISOCOL}
//  rotate <-10,0,0>
//  translate <-3.3,0,0>
  finish {phong 0.6}
  no_shadow
}

#declare ComBl = texture{ pigment {color red 0.6 green 0.6 blue 1.0}}

cylinder { x*6,-x*6, 0.12 texture {ComBl} no_shadow}
cylinder { y*5.5,-y*5.5, 0.12 texture {ComBl} no_shadow}
cylinder { z*6.5,-z*6.5, 0.12 texture {ComBl} no_shadow}
cone { x*0.7,0, -x*0.7,0.3 texture {ComBl} translate x*6 no_shadow}
cone { y*0.7,0, -y*0.7,0.3 texture {ComBl} translate y*5.5 no_shadow}
cone { z*0.7,0, -z*0.7,0.3 texture {ComBl} translate z*6.5 no_shadow}

#declare CHRed = <2,2,2>
#declare CHScl = <1.5, 1.5, 0.05>
text { ttf "crystal.ttf", "x", 2, 0 pigment { color rgb CHRed }
  scale CHScl rotate y*250 translate <7.5, -.5, -.5> no_shadow }
text { ttf "crystal.ttf", "y", 2, 0 pigment { color rgb CHRed }
  scale CHScl rotate y*250 translate <0, 6., 0.4> no_shadow }
text { ttf "crystal.ttf", "z", 2, 0 pigment { color rgb CHRed }
  scale CHScl rotate y*250 translate <0, -0.5, 7.5> no_shadow }
