
// Persistence of Vision Ray Tracer Scene Description File
// File: circular.pov
// Vers: 3
// Desc: Test of the Circular Keyword
// Date: 9/18/97
// Auth: Eric N Brown

#version unofficial MegaPov 0.4;


global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 1, -8.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, -2.5,  0.0>
}

// An area light (creates soft shadows)
// Testing the circular keyword
light_source
{
  <0,0,0>
  color rgb 1.0
  area_light
  <18, 0, 0> <0, 0, 18> // lights spread out across this distance (x * z)
  5, 5                  // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0            // 0,1,2,3...
  circular
  translate <0, 30, 0>
}

// ----------------------------------------
// A plane with a sphere above it.
plane { y, -3 pigment {color rgb <0.7,0.5,0.3>} }
sphere { 0.0, 1.4 texture {pigment {color rgb <1,0,1>} }}
