//	Persistence of Vision Ray Tracer Scene Description File
//	File: vturb_vect.pov
//	Date: 15/11/99
//	Demo showing the use of vturbulence()
	
#version unofficial MegaPov 0.4;


#include "colors.inc"

global_settings { assumed_gamma 1.8 }

camera {
	location <0.0, 1.0, -25>
	right x*(image_width/image_height)
	up y
	look_at <0.0, -0.5,  0.0>
	angle 45
}

light_source { <10, 30, -60> White*1.6}
light_source { <0, 0, 0> White*1.5}

#declare C = 0;
#declare Copies = 10000;
#while ( C < Copies)
	sphere  {
		< 0.0, 0.0, 0.0 >, 0.1
		translate vturbulence (1.5, 8, 2, x * (-10 + (C * (10 - (-10))/(Copies -1))))
		#declare R = (0.000000 + (C * (0.694820 -(0.000000))/(Copies -1)));
		#declare G = (0.000000 + (C * (0.694820 -(0.000000))/(Copies -1)));
		#declare B = (1.000000 + (C * (0.152590 -(1.000000))/(Copies -1)));
		#declare F = (0 + (C * (0 -(0))/(Copies -1)));
		#declare T = (0 + (C * (0 -(0))/(Copies -1)));
		texture {
			pigment { 	rgbft <R, G, B, F, T> }
			finish  {
				ambient color rgb < 0.35, 0.35, 0.35 > 
				phong 1.0
				phong_size 800
			}
		}
	} //object
	#declare C = C +1;
#end  //while (C < Copies)
  
  
  