//	Persistence of Vision Ray Tracer Scene Description File
//	File: hf_height_at.pov
//	Date: 12/12/99
//	Author: Ren Smellenbergh
//	Demo showing the use of the "hf_height_at" function
#version unofficial MegaPov 0.4;

/*
"hf_height_at" function.
This function returns the height of a height_field at a given position on the height_field.
It has the following syntax:
	hf_height_at (XCOORD, ZCOORD, IDENTIFIER)
XCOORD and ZCOORD are both in the range of 0 to 1 and represent the position you want
to test on the height_field.
IDENTIFIER is the declared height_field object to test.
hf_height_at returns a number in the range of 0 to 1.
EXAMPLES:
	#declare Myhf = height_field { tga "field.tga" translate <-0.5,0,-0.5> scale <20,5,20> }
	#declare Ypos = hf_height_at ( 0.5, 0.5, Myhf )
The above example would return the height at the center of the height field object.
This number would be from 0 to 1, so, in the above example, Ypos would need to be
multiplied by 5 to get the actual height of the point (since Myhf was scaled by 5 in the y-direction).
This function can be used to put trees and other objects on terrain, for instance. 
*/

global_settings { assumed_gamma 1.8 }

camera {
	location <0.0, 0, -3>
	up y*image_height right x*image_width
	angle 60
	look_at <0.0, 0.0, 0.0>
	rotate x*45
}

light_source{<1000,1000,-1000> rgb 1}

#declare Myhf =
height_field {
	pattern 500, 500 {
		hf_gray_16
		bozo
		color_map {
			[ 0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
			[ 0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
			[ 0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
			[ 0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
			[ 0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
			[ 0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
			[ 0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
			[ 0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
			[ 0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
			[ 1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
		}
		triangle_wave
		scale <0.3, 0.1, 0.3>
	}
	scale <2, 0.2, 2>
	smooth 
}
object {
	Myhf   
	pigment { rgb <0.9, 0.9, 0.9> 	}
	translate <-1.0, 0, -1.0>
}

#declare C = 0;
#declare Copies = 40;
#while ( C < Copies)
	#declare Va1 = (0.0 + (C * (1.0 - (0.0))/(Copies -1)));

#declare PosX = Va1;
#declare PosZ = Va1;
#declare ypos = hf_height_at( PosX, PosZ, Myhf );


sphere { <PosX, ypos+0.02 ,PosZ>*<2, 0.2, 2>, 0.02 
	pigment { rgb <1.0, 0, 0> }
 	translate <-1, 0, -1>
}
#declare C = C +1;
#end  //while (C < Copies)
