// MegaPov scene file, demo for complex functions use.

#version unofficial MegaPov 0.4;
#include "colors.inc"

#include "densmcr.inc"

#declare S=20;

/*=============================*/
// These are the arguments for DensityMacroFunction
// in DensMcr.inc
#local MinVec=<-1.5,-1.5,-1.5>;
#local MaxVec=<1.5,1.5,1.5>;
#local Amp=1;             
#local SampleVec=<S,S,S>; 
/*=============================*/ 


// #declare hA=<-.745,0,.113,.05>;
// #declare b=<1,0,0,0>;
#declare BAILOUT=4;
#declare iilim=40;

#macro DensityMacro(xx,yy,zz)                
/*===================================================================*/
        // a 'hypercomplex julia' set
        #local hh=<xx,yy,zz,0>;
        #local rr=hAbs2(hh);
        #local ii=0;
        #while(ii<iilim & rr<BAILOUT)
           // h(n+1)=e^h(n) + h(n)^2
           #local hh=hAdd(hExp(hh),hSqr(hh));
           
           #local rr=hAbs2(hh);
           #local ii=ii+1;
	#end
	//#debug concat(str(rr,0,-1),str(ii,0,0),"\n")
        ii/iilim
/*===================================================================*/
#end

/*===================================================================*/
// These 'hypercomplex' macro functions
// are extracted from a more complete 
// quaternion and hypercomplex number 
// include file to speed up parsing/calculation
// #include quat.inc
#macro h2c_1(h)
   <h.x-h.t, h.y+h.z>
#end
#macro h2c_2(h)
   <h.x+h.t, h.y-h.z>
#end             
#macro c2h(c1,c2)
    <(c1.u+c2.u)/2,(c1.v+c2.v)/2,(c1.v-c2.v)/2,(c2.u-c1.u)/2>
#end
#macro hAbs2(h1)
    h1.x*h1.x+h1.y*h1.y+h1.z*h1.z+h1.t*h1.t
#end                  
#macro hAdd(h1,h2)
    <
    h1.x+h2.x,
    h1.y+h2.y,
    h1.z+h2.z,
    h1.t+h2.t
    >
#end
#macro hSqr(h)         
    <
    (h.x) * (h.x) - (h.y) * (h.y) - (h.z) * (h.z) + (h.t) * (h.t),
    2.0 * ( (h.x) * (h.y) - (h.z) * (h.t) ),
    2.0 * ( (h.z) * (h.x) - (h.t) * (h.y) ),
    2.0 * ( (h.t) * (h.x) + (h.z) * (h.y) )
    >
#end    
#macro hExp(h)
    #local c1=cexp(h2c_1(h));
    #local c2=cexp(h2c_2(h));
    c2h(c1,c2)
#end              
/*===================================================================*/

// DensityMacroFunction in file DensMcr.inc takes the previously
// defined float returning macro named 'DensityMacro(xx,yy,zz)' 
// and returns an isosurface function.
// DensityMacroFunction requires that DensityMacro(xx,yy,zz)
// has been defined (as above).
/*===================================================================*/
#declare mydensityfn=DensityMacroFunction(MinVec,MaxVec,SampleVec,Amp,<1,1,1>)
/*===================================================================*/  


camera { location 4*<65, 25, 35> direction <0, 0, 6.0> look_at <0,0,0> }

light_source {4*<50, 80, 30> color White}

light_source {4*<60, -25, 40> color White}

isosurface{
	function {mydensityfn(x,y,z)}
	eval
//	max_gradient 5.0
	contained_by{sphere{0,S}}
	pigment {
		function {mydensityfn(x,y,z)}

		color_map{
			[0.0     rgbt <0,0,0,1>] 
			[0.98    rgbt <0,0,0,1>] 
			[1.0     rgbt <1,1,0,0>]
		}
	}
	scale 20/S
}


sky_sphere {
	pigment {
		gradient y    
		color_map { [0.0 color rgb <0.5,0.7,1.0>] [1.0 color rgb <0.5,0.7,.7>] }
	}
}
