/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"

#include <string.h>

#include <glib-object.h>

#include "libgimpcolor/gimpcolor.h"

#include "pdb-types.h"
#include "procedural_db.h"

#include "core/gimp.h"
#include "core/gimpcontainer.h"
#include "core/gimpcontext.h"
#include "core/gimpdatafactory.h"
#include "core/gimpgradient.h"
#include "core/gimplist.h"

static ProcRecord gradient_new_proc;
static ProcRecord gradient_duplicate_proc;
static ProcRecord gradient_is_editable_proc;
static ProcRecord gradient_rename_proc;
static ProcRecord gradient_delete_proc;
static ProcRecord gradient_get_uniform_samples_proc;
static ProcRecord gradient_get_custom_samples_proc;
static ProcRecord gradient_segment_get_left_color_proc;
static ProcRecord gradient_segment_set_left_color_proc;
static ProcRecord gradient_segment_get_right_color_proc;
static ProcRecord gradient_segment_set_right_color_proc;
static ProcRecord gradient_segment_get_left_pos_proc;
static ProcRecord gradient_segment_set_left_pos_proc;
static ProcRecord gradient_segment_get_middle_pos_proc;
static ProcRecord gradient_segment_set_middle_pos_proc;
static ProcRecord gradient_segment_get_right_pos_proc;
static ProcRecord gradient_segment_set_right_pos_proc;
static ProcRecord gradient_segment_get_blending_function_proc;
static ProcRecord gradient_segment_get_coloring_type_proc;
static ProcRecord gradient_segment_range_set_blending_function_proc;
static ProcRecord gradient_segment_range_set_coloring_type_proc;
static ProcRecord gradient_segment_range_flip_proc;
static ProcRecord gradient_segment_range_replicate_proc;
static ProcRecord gradient_segment_range_split_midpoint_proc;
static ProcRecord gradient_segment_range_split_uniform_proc;
static ProcRecord gradient_segment_range_delete_proc;
static ProcRecord gradient_segment_range_redistribute_handles_proc;
static ProcRecord gradient_segment_range_blend_colors_proc;
static ProcRecord gradient_segment_range_blend_opacity_proc;
static ProcRecord gradient_segment_range_move_proc;

void
register_gradient_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &gradient_new_proc);
  procedural_db_register (gimp, &gradient_duplicate_proc);
  procedural_db_register (gimp, &gradient_is_editable_proc);
  procedural_db_register (gimp, &gradient_rename_proc);
  procedural_db_register (gimp, &gradient_delete_proc);
  procedural_db_register (gimp, &gradient_get_uniform_samples_proc);
  procedural_db_register (gimp, &gradient_get_custom_samples_proc);
  procedural_db_register (gimp, &gradient_segment_get_left_color_proc);
  procedural_db_register (gimp, &gradient_segment_set_left_color_proc);
  procedural_db_register (gimp, &gradient_segment_get_right_color_proc);
  procedural_db_register (gimp, &gradient_segment_set_right_color_proc);
  procedural_db_register (gimp, &gradient_segment_get_left_pos_proc);
  procedural_db_register (gimp, &gradient_segment_set_left_pos_proc);
  procedural_db_register (gimp, &gradient_segment_get_middle_pos_proc);
  procedural_db_register (gimp, &gradient_segment_set_middle_pos_proc);
  procedural_db_register (gimp, &gradient_segment_get_right_pos_proc);
  procedural_db_register (gimp, &gradient_segment_set_right_pos_proc);
  procedural_db_register (gimp, &gradient_segment_get_blending_function_proc);
  procedural_db_register (gimp, &gradient_segment_get_coloring_type_proc);
  procedural_db_register (gimp, &gradient_segment_range_set_blending_function_proc);
  procedural_db_register (gimp, &gradient_segment_range_set_coloring_type_proc);
  procedural_db_register (gimp, &gradient_segment_range_flip_proc);
  procedural_db_register (gimp, &gradient_segment_range_replicate_proc);
  procedural_db_register (gimp, &gradient_segment_range_split_midpoint_proc);
  procedural_db_register (gimp, &gradient_segment_range_split_uniform_proc);
  procedural_db_register (gimp, &gradient_segment_range_delete_proc);
  procedural_db_register (gimp, &gradient_segment_range_redistribute_handles_proc);
  procedural_db_register (gimp, &gradient_segment_range_blend_colors_proc);
  procedural_db_register (gimp, &gradient_segment_range_blend_opacity_proc);
  procedural_db_register (gimp, &gradient_segment_range_move_proc);
}

static Argument *
gradient_new_invoker (Gimp         *gimp,
                      GimpContext  *context,
                      GimpProgress *progress,
                      Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpData *data = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      if (strlen (name))
        data = gimp_data_factory_data_new (gimp->gradient_factory, name);

      success = (data != NULL);
    }

  return_args = procedural_db_return_args (&gradient_new_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (GIMP_OBJECT (data)->name);

  return return_args;
}

static ProcArg gradient_new_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The requested name of the new gradient"
  }
};

static ProcArg gradient_new_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The actual new gradient name"
  }
};

static ProcRecord gradient_new_proc =
{
  "gimp-gradient-new",
  "gimp-gradient-new",
  "Creates a new gradient",
  "This procedure creates a new, uninitialized gradient",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  1,
  gradient_new_inargs,
  1,
  gradient_new_outargs,
  { { gradient_new_invoker } }
};

static Argument *
gradient_duplicate_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpGradient *gradient = NULL;
  GimpGradient *gradient_copy = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          gradient_copy = (GimpGradient *)
            gimp_data_factory_data_duplicate (gimp->gradient_factory,
                                              GIMP_DATA (gradient));

          success = (gradient_copy != NULL);
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_duplicate_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (GIMP_OBJECT (gradient_copy)->name);

  return return_args;
}

static ProcArg gradient_duplicate_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  }
};

static ProcArg gradient_duplicate_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The name of the gradient's copy"
  }
};

static ProcRecord gradient_duplicate_proc =
{
  "gimp-gradient-duplicate",
  "gimp-gradient-duplicate",
  "Duplicates a gradient",
  "This procedure creates an identical gradient by a different name",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  1,
  gradient_duplicate_inargs,
  1,
  gradient_duplicate_outargs,
  { { gradient_duplicate_invoker } }
};

static Argument *
gradient_is_editable_invoker (Gimp         *gimp,
                              GimpContext  *context,
                              GimpProgress *progress,
                              Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        success = TRUE;
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_is_editable_proc, success);

  if (success)
    return_args[1].value.pdb_int = GIMP_DATA (gradient)->writable;

  return return_args;
}

static ProcArg gradient_is_editable_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  }
};

static ProcArg gradient_is_editable_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "editable",
    "True if the gradient can be edited"
  }
};

static ProcRecord gradient_is_editable_proc =
{
  "gimp-gradient-is-editable",
  "gimp-gradient-is-editable",
  "Tests if gradient can be edited",
  "Returns True if you have permission to change the gradient",
  "Bill Skaggs <weskaggs@primate.ucdavis.edu",
  "Bill Skaggs",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  gradient_is_editable_inargs,
  1,
  gradient_is_editable_outargs,
  { { gradient_is_editable_invoker } }
};

static Argument *
gradient_rename_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gchar *new_name;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  new_name = (gchar *) args[1].value.pdb_pointer;
  if (new_name == NULL || !g_utf8_validate (new_name, -1, NULL))
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient && GIMP_DATA (gradient)->writable)
        gimp_object_set_name (GIMP_OBJECT (gradient), new_name);
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_rename_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (GIMP_OBJECT (gradient)->name);

  return return_args;
}

static ProcArg gradient_rename_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_STRING,
    "new-name",
    "The new name of the gradient"
  }
};

static ProcArg gradient_rename_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The actual new name of the gradient"
  }
};

static ProcRecord gradient_rename_proc =
{
  "gimp-gradient-rename",
  "gimp-gradient-rename",
  "Rename a gradient",
  "This procedure renames a gradient",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  2,
  gradient_rename_inargs,
  1,
  gradient_rename_outargs,
  { { gradient_rename_invoker } }
};

static Argument *
gradient_delete_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient && GIMP_DATA (gradient)->deletable)
        {
          GError *error = NULL;

          success = gimp_data_factory_data_delete (gimp->gradient_factory,
                                                   GIMP_DATA (gradient),
                                                   TRUE, &error);

          if (! success)
            {
              g_message (error->message);
              g_clear_error (&error);
            }
        }
      else
        success = FALSE;
    }

  return procedural_db_return_args (&gradient_delete_proc, success);
}

static ProcArg gradient_delete_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  }
};

static ProcRecord gradient_delete_proc =
{
  "gimp-gradient-delete",
  "gimp-gradient-delete",
  "Deletes a gradient",
  "This procedure deletes a gradient",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  1,
  gradient_delete_inargs,
  0,
  NULL,
  { { gradient_delete_invoker } }
};

static Argument *
gradient_get_uniform_samples_invoker (Gimp         *gimp,
                                      GimpContext  *context,
                                      GimpProgress *progress,
                                      Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 num_samples;
  gboolean reverse;
  gint32 num_color_samples = 0;
  gdouble *color_samples = NULL;
  GimpGradient *gradient;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  num_samples = args[1].value.pdb_int;
  if (num_samples < 2)
    success = FALSE;

  reverse = args[2].value.pdb_int ? TRUE : FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg   = NULL;
          gdouble              pos   = 0.0;
          gdouble              delta = 1.0 / (num_samples - 1);
          gdouble             *sample;

          num_color_samples = num_samples * 4;

          sample = color_samples = g_new (gdouble, num_color_samples);

          while (num_samples--)
            {
              GimpRGB color;

              seg = gimp_gradient_get_color_at (gradient, seg, pos, reverse, &color);

              *sample++ = color.r;
              *sample++ = color.g;
              *sample++ = color.b;
              *sample++ = color.a;

              pos += delta;
            }
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_get_uniform_samples_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = num_color_samples;
      return_args[2].value.pdb_pointer = color_samples;
    }

  return return_args;
}

static ProcArg gradient_get_uniform_samples_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "num-samples",
    "The number of samples to take"
  },
  {
    GIMP_PDB_INT32,
    "reverse",
    "Use the reverse gradient (TRUE or FALSE)"
  }
};

static ProcArg gradient_get_uniform_samples_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "num-color-samples",
    "Length of the color_samples array (4 * num_samples)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "color-samples",
    "Color samples: { R1, G1, B1, A1, ..., Rn, Gn, Bn, An }"
  }
};

static ProcRecord gradient_get_uniform_samples_proc =
{
  "gimp-gradient-get-uniform-samples",
  "gimp-gradient-get-uniform-samples",
  "Sample the specified in uniform parts.",
  "This procedure samples the active gradient in the specified number of uniform parts. It returns a list of floating-point values which correspond to the RGBA values for each sample. The minimum number of samples to take is 2, in which case the returned colors will correspond to the { 0.0, 1.0 } positions in the gradient. For example, if the number of samples is 3, the procedure will return the colors at positions { 0.0, 0.5, 1.0 }.",
  "Federico Mena Quintero",
  "Federico Mena Quintero",
  "1997",
  NULL,
  GIMP_INTERNAL,
  3,
  gradient_get_uniform_samples_inargs,
  2,
  gradient_get_uniform_samples_outargs,
  { { gradient_get_uniform_samples_invoker } }
};

static Argument *
gradient_get_custom_samples_invoker (Gimp         *gimp,
                                     GimpContext  *context,
                                     GimpProgress *progress,
                                     Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 num_samples;
  gdouble *pos;
  gboolean reverse;
  gint32 num_color_samples = 0;
  gdouble *color_samples = NULL;
  GimpGradient *gradient;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  num_samples = args[1].value.pdb_int;
  if (num_samples <= 0)
    success = FALSE;

  pos = (gdouble *) args[2].value.pdb_pointer;

  reverse = args[3].value.pdb_int ? TRUE : FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg = NULL;
          gdouble             *sample;

          num_color_samples = num_samples * 4;

          sample = color_samples = g_new (gdouble, num_color_samples);

          while (num_samples--)
            {
              GimpRGB color;

              seg = gimp_gradient_get_color_at (gradient, seg, *pos, reverse, &color);

              *sample++ = color.r;
              *sample++ = color.g;
              *sample++ = color.b;
              *sample++ = color.a;

              pos++;
            }
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_get_custom_samples_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = num_color_samples;
      return_args[2].value.pdb_pointer = color_samples;
    }

  return return_args;
}

static ProcArg gradient_get_custom_samples_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "num-samples",
    "The number of samples to take"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "positions",
    "The list of positions to sample along the gradient"
  },
  {
    GIMP_PDB_INT32,
    "reverse",
    "Use the reverse gradient (TRUE or FALSE)"
  }
};

static ProcArg gradient_get_custom_samples_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "num-color-samples",
    "Length of the color_samples array (4 * num_samples)"
  },
  {
    GIMP_PDB_FLOATARRAY,
    "color-samples",
    "Color samples: { R1, G1, B1, A1, ..., Rn, Gn, Bn, An }"
  }
};

static ProcRecord gradient_get_custom_samples_proc =
{
  "gimp-gradient-get-custom-samples",
  "gimp-gradient-get-custom-samples",
  "Sample the spacified gradient in custom positions.",
  "This procedure samples the active gradient in the specified number of points. The procedure will sample the gradient in the specified positions from the list. The left endpoint of the gradient corresponds to position 0.0, and the right endpoint corresponds to 1.0. The procedure returns a list of floating-point values which correspond to the RGBA values for each sample.",
  "Federico Mena Quintero",
  "Federico Mena Quintero",
  "1997",
  NULL,
  GIMP_INTERNAL,
  4,
  gradient_get_custom_samples_inargs,
  2,
  gradient_get_custom_samples_outargs,
  { { gradient_get_custom_samples_invoker } }
};

static Argument *
gradient_segment_get_left_color_invoker (Gimp         *gimp,
                                         GimpContext  *context,
                                         GimpProgress *progress,
                                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 segment;
  GimpRGB color;
  gdouble opacity = 0;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  segment = args[1].value.pdb_int;
  if (segment < 0)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg;

          seg = gimp_gradient_segment_get_nth (gradient->segments, segment);

          if (seg)
            {
              gimp_gradient_segment_get_left_color (gradient, seg, &color);
              opacity = color.a * 100.0;
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_segment_get_left_color_proc, success);

  if (success)
    {
      return_args[1].value.pdb_color = color;
      return_args[2].value.pdb_float = opacity;
    }

  return return_args;
}

static ProcArg gradient_segment_get_left_color_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "segment",
    "The index of the segment within the gradient"
  }
};

static ProcArg gradient_segment_get_left_color_outargs[] =
{
  {
    GIMP_PDB_COLOR,
    "color",
    "The return color"
  },
  {
    GIMP_PDB_FLOAT,
    "opacity",
    "The opacity of the endpoint"
  }
};

static ProcRecord gradient_segment_get_left_color_proc =
{
  "gimp-gradient-segment-get-left-color",
  "gimp-gradient-segment-get-left-color",
  "Retrieves the left endpoint color of the specified gradient and segment",
  "This procedure retrieves the left endpoint color of the specified segment of the specified gradient.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  2,
  gradient_segment_get_left_color_inargs,
  2,
  gradient_segment_get_left_color_outargs,
  { { gradient_segment_get_left_color_invoker } }
};

static Argument *
gradient_segment_set_left_color_invoker (Gimp         *gimp,
                                         GimpContext  *context,
                                         GimpProgress *progress,
                                         Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 segment;
  GimpRGB color;
  gdouble opacity;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  segment = args[1].value.pdb_int;
  if (segment < 0)
    success = FALSE;

  color = args[2].value.pdb_color;

  opacity = args[3].value.pdb_float;
  if (opacity < 0.0 || opacity > 100.0)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg;

          seg = gimp_gradient_segment_get_nth (gradient->segments, segment);

          if (seg)
            {
              color.a = opacity / 100.0;
              gimp_gradient_segment_set_left_color (gradient, seg, &color);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return procedural_db_return_args (&gradient_segment_set_left_color_proc, success);
}

static ProcArg gradient_segment_set_left_color_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "segment",
    "The index of the segment within the gradient"
  },
  {
    GIMP_PDB_COLOR,
    "color",
    "The color to set"
  },
  {
    GIMP_PDB_FLOAT,
    "opacity",
    "The opacity to set for the endpoint"
  }
};

static ProcRecord gradient_segment_set_left_color_proc =
{
  "gimp-gradient-segment-set-left-color",
  "gimp-gradient-segment-set-left-color",
  "Retrieves the left endpoint color of the specified gradient and segment",
  "This procedure retrieves the left endpoint color of the specified segment of the specified gradient.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  4,
  gradient_segment_set_left_color_inargs,
  0,
  NULL,
  { { gradient_segment_set_left_color_invoker } }
};

static Argument *
gradient_segment_get_right_color_invoker (Gimp         *gimp,
                                          GimpContext  *context,
                                          GimpProgress *progress,
                                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 segment;
  GimpRGB color;
  gdouble opacity = 0;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  segment = args[1].value.pdb_int;
  if (segment < 0)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg;

          seg = gimp_gradient_segment_get_nth (gradient->segments, segment);

          if (seg)
            {
              gimp_gradient_segment_get_right_color (gradient, seg, &color);
              opacity = color.a * 100.0;
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_segment_get_right_color_proc, success);

  if (success)
    {
      return_args[1].value.pdb_color = color;
      return_args[2].value.pdb_float = opacity;
    }

  return return_args;
}

static ProcArg gradient_segment_get_right_color_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "segment",
    "The index of the segment within the gradient"
  }
};

static ProcArg gradient_segment_get_right_color_outargs[] =
{
  {
    GIMP_PDB_COLOR,
    "color",
    "The return color"
  },
  {
    GIMP_PDB_FLOAT,
    "opacity",
    "The opacity of the endpoint"
  }
};

static ProcRecord gradient_segment_get_right_color_proc =
{
  "gimp-gradient-segment-get-right-color",
  "gimp-gradient-segment-get-right-color",
  "Retrieves the right endpoint color of the specified gradient and segment",
  "This procedure retrieves the right endpoint color of the specified segment of the specified gradient.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  2,
  gradient_segment_get_right_color_inargs,
  2,
  gradient_segment_get_right_color_outargs,
  { { gradient_segment_get_right_color_invoker } }
};

static Argument *
gradient_segment_set_right_color_invoker (Gimp         *gimp,
                                          GimpContext  *context,
                                          GimpProgress *progress,
                                          Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 segment;
  GimpRGB color;
  gdouble opacity;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  segment = args[1].value.pdb_int;
  if (segment < 0)
    success = FALSE;

  color = args[2].value.pdb_color;

  opacity = args[3].value.pdb_float;
  if (opacity < 0.0 || opacity > 100.0)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg;

          seg = gimp_gradient_segment_get_nth (gradient->segments, segment);

          if (seg)
            {
              color.a = opacity / 100.0;
              gimp_gradient_segment_set_right_color (gradient, seg, &color);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return procedural_db_return_args (&gradient_segment_set_right_color_proc, success);
}

static ProcArg gradient_segment_set_right_color_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "segment",
    "The index of the segment within the gradient"
  },
  {
    GIMP_PDB_COLOR,
    "color",
    "The color to set"
  },
  {
    GIMP_PDB_FLOAT,
    "opacity",
    "The opacity to set for the endpoint"
  }
};

static ProcRecord gradient_segment_set_right_color_proc =
{
  "gimp-gradient-segment-set-right-color",
  "gimp-gradient-segment-set-right-color",
  "Retrieves the right endpoint color of the specified gradient and segment",
  "This procedure retrieves the right endpoint color of the specified segment of the specified gradient.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  4,
  gradient_segment_set_right_color_inargs,
  0,
  NULL,
  { { gradient_segment_set_right_color_invoker } }
};

static Argument *
gradient_segment_get_left_pos_invoker (Gimp         *gimp,
                                       GimpContext  *context,
                                       GimpProgress *progress,
                                       Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 segment;
  gdouble pos = 0;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  segment = args[1].value.pdb_int;
  if (segment < 0)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg;

          seg = gimp_gradient_segment_get_nth (gradient->segments, segment);

          if (seg)
            {
              pos = gimp_gradient_segment_get_left_pos (gradient, seg);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_segment_get_left_pos_proc, success);

  if (success)
    return_args[1].value.pdb_float = pos;

  return return_args;
}

static ProcArg gradient_segment_get_left_pos_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "segment",
    "The index of the segment within the gradient"
  }
};

static ProcArg gradient_segment_get_left_pos_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "pos",
    "The return position"
  }
};

static ProcRecord gradient_segment_get_left_pos_proc =
{
  "gimp-gradient-segment-get-left-pos",
  "gimp-gradient-segment-get-left-pos",
  "Retrieves the left endpoint position of the specified gradient and segment",
  "This procedure retrieves the left endpoint position of the specified segment of the specified gradient.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  2,
  gradient_segment_get_left_pos_inargs,
  1,
  gradient_segment_get_left_pos_outargs,
  { { gradient_segment_get_left_pos_invoker } }
};

static Argument *
gradient_segment_set_left_pos_invoker (Gimp         *gimp,
                                       GimpContext  *context,
                                       GimpProgress *progress,
                                       Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 segment;
  gdouble pos;
  gdouble final_pos = 0;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  segment = args[1].value.pdb_int;
  if (segment < 0)
    success = FALSE;

  pos = args[2].value.pdb_float;
  if (pos < 0.0 || pos > 1.0)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg;

          seg = gimp_gradient_segment_get_nth (gradient->segments, segment);

          if (seg)
            {
              final_pos =
                gimp_gradient_segment_set_left_pos (gradient, seg, pos);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_segment_set_left_pos_proc, success);

  if (success)
    return_args[1].value.pdb_float = final_pos;

  return return_args;
}

static ProcArg gradient_segment_set_left_pos_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "segment",
    "The index of the segment within the gradient"
  },
  {
    GIMP_PDB_FLOAT,
    "pos",
    "The position to set the guidepoint in."
  }
};

static ProcArg gradient_segment_set_left_pos_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "final-pos",
    "The return position"
  }
};

static ProcRecord gradient_segment_set_left_pos_proc =
{
  "gimp-gradient-segment-set-left-pos",
  "gimp-gradient-segment-set-left-pos",
  "Sets the left endpoint position of the specified gradient and segment",
  "This procedure sets the left endpoint position of the specified segment of the specified gradient. The final position will be between the position of the middle point to the left to the middle point of the current segement. This procedure returns the final position.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  3,
  gradient_segment_set_left_pos_inargs,
  1,
  gradient_segment_set_left_pos_outargs,
  { { gradient_segment_set_left_pos_invoker } }
};

static Argument *
gradient_segment_get_middle_pos_invoker (Gimp         *gimp,
                                         GimpContext  *context,
                                         GimpProgress *progress,
                                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 segment;
  gdouble pos = 0;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  segment = args[1].value.pdb_int;
  if (segment < 0)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg;

          seg = gimp_gradient_segment_get_nth (gradient->segments, segment);

          if (seg)
            {
              pos = gimp_gradient_segment_get_middle_pos (gradient, seg);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_segment_get_middle_pos_proc, success);

  if (success)
    return_args[1].value.pdb_float = pos;

  return return_args;
}

static ProcArg gradient_segment_get_middle_pos_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "segment",
    "The index of the segment within the gradient"
  }
};

static ProcArg gradient_segment_get_middle_pos_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "pos",
    "The return position"
  }
};

static ProcRecord gradient_segment_get_middle_pos_proc =
{
  "gimp-gradient-segment-get-middle-pos",
  "gimp-gradient-segment-get-middle-pos",
  "Retrieves the middle point position of the specified gradient and segment",
  "This procedure retrieves the middle point position of the specified segment of the specified gradient.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  2,
  gradient_segment_get_middle_pos_inargs,
  1,
  gradient_segment_get_middle_pos_outargs,
  { { gradient_segment_get_middle_pos_invoker } }
};

static Argument *
gradient_segment_set_middle_pos_invoker (Gimp         *gimp,
                                         GimpContext  *context,
                                         GimpProgress *progress,
                                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 segment;
  gdouble pos;
  gdouble final_pos = 0;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  segment = args[1].value.pdb_int;
  if (segment < 0)
    success = FALSE;

  pos = args[2].value.pdb_float;
  if (pos < 0.0 || pos > 1.0)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg;

          seg = gimp_gradient_segment_get_nth (gradient->segments, segment);

          if (seg)
            {
              final_pos =
                gimp_gradient_segment_set_middle_pos (gradient, seg, pos);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_segment_set_middle_pos_proc, success);

  if (success)
    return_args[1].value.pdb_float = final_pos;

  return return_args;
}

static ProcArg gradient_segment_set_middle_pos_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "segment",
    "The index of the segment within the gradient"
  },
  {
    GIMP_PDB_FLOAT,
    "pos",
    "The position to set the guidepoint in."
  }
};

static ProcArg gradient_segment_set_middle_pos_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "final-pos",
    "The return position"
  }
};

static ProcRecord gradient_segment_set_middle_pos_proc =
{
  "gimp-gradient-segment-set-middle-pos",
  "gimp-gradient-segment-set-middle-pos",
  "Sets the middle point position of the specified gradient and segment",
  "This procedure sets the middle point position of the specified segment of the specified gradient. The final position will be between the two endpoints of the segment. This procedure returns the final position.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  3,
  gradient_segment_set_middle_pos_inargs,
  1,
  gradient_segment_set_middle_pos_outargs,
  { { gradient_segment_set_middle_pos_invoker } }
};

static Argument *
gradient_segment_get_right_pos_invoker (Gimp         *gimp,
                                        GimpContext  *context,
                                        GimpProgress *progress,
                                        Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 segment;
  gdouble pos = 0;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  segment = args[1].value.pdb_int;
  if (segment < 0)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg;

          seg = gimp_gradient_segment_get_nth (gradient->segments, segment);

          if (seg)
            {
              pos = gimp_gradient_segment_get_right_pos (gradient, seg);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_segment_get_right_pos_proc, success);

  if (success)
    return_args[1].value.pdb_float = pos;

  return return_args;
}

static ProcArg gradient_segment_get_right_pos_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "segment",
    "The index of the segment within the gradient"
  }
};

static ProcArg gradient_segment_get_right_pos_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "pos",
    "The return position"
  }
};

static ProcRecord gradient_segment_get_right_pos_proc =
{
  "gimp-gradient-segment-get-right-pos",
  "gimp-gradient-segment-get-right-pos",
  "Retrieves the right endpoint position of the specified gradient and segment",
  "This procedure retrieves the right endpoint position of the specified segment of the specified gradient.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  2,
  gradient_segment_get_right_pos_inargs,
  1,
  gradient_segment_get_right_pos_outargs,
  { { gradient_segment_get_right_pos_invoker } }
};

static Argument *
gradient_segment_set_right_pos_invoker (Gimp         *gimp,
                                        GimpContext  *context,
                                        GimpProgress *progress,
                                        Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 segment;
  gdouble pos;
  gdouble final_pos = 0;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  segment = args[1].value.pdb_int;
  if (segment < 0)
    success = FALSE;

  pos = args[2].value.pdb_float;
  if (pos < 0.0 || pos > 1.0)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg;

          seg = gimp_gradient_segment_get_nth (gradient->segments, segment);

          if (seg)
            {
              final_pos =
                gimp_gradient_segment_set_right_pos (gradient, seg, pos);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_segment_set_right_pos_proc, success);

  if (success)
    return_args[1].value.pdb_float = final_pos;

  return return_args;
}

static ProcArg gradient_segment_set_right_pos_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "segment",
    "The index of the segment within the gradient"
  },
  {
    GIMP_PDB_FLOAT,
    "pos",
    "The position to set the guidepoint in."
  }
};

static ProcArg gradient_segment_set_right_pos_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "final-pos",
    "The return position"
  }
};

static ProcRecord gradient_segment_set_right_pos_proc =
{
  "gimp-gradient-segment-set-right-pos",
  "gimp-gradient-segment-set-right-pos",
  "Sets the right endpoint position of the specified gradient and segment",
  "This procedure sets the right endpoint position of the specified segment of the specified gradient. The final position will be between the position of the middle point of the current segment and the middle point of the segment to the right. This procedure returns the final position.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  3,
  gradient_segment_set_right_pos_inargs,
  1,
  gradient_segment_set_right_pos_outargs,
  { { gradient_segment_set_right_pos_invoker } }
};

static Argument *
gradient_segment_get_blending_function_invoker (Gimp         *gimp,
                                                GimpContext  *context,
                                                GimpProgress *progress,
                                                Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 segment;
  gint32 blend_func = 0;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  segment = args[1].value.pdb_int;
  if (segment < 0)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg;

          seg = gimp_gradient_segment_get_nth (gradient->segments, segment);

          if (seg)
            {
              blend_func =
                gimp_gradient_segment_get_blending_function (gradient, seg);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_segment_get_blending_function_proc, success);

  if (success)
    return_args[1].value.pdb_int = blend_func;

  return return_args;
}

static ProcArg gradient_segment_get_blending_function_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "segment",
    "The index of the segment within the gradient"
  }
};

static ProcArg gradient_segment_get_blending_function_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "blend-func",
    "The blending function of the segment: { GIMP_GRADIENT_SEGMENT_LINEAR (0), GIMP_GRADIENT_SEGMENT_CURVED (1), GIMP_GRADIENT_SEGMENT_SINE (2), GIMP_GRADIENT_SEGMENT_SPHERE_INCREASING (3), GIMP_GRADIENT_SEGMENT_SPHERE_DECREASING (4) }"
  }
};

static ProcRecord gradient_segment_get_blending_function_proc =
{
  "gimp-gradient-segment-get-blending-function",
  "gimp-gradient-segment-get-blending-function",
  "Retrieves the gradient segment's blending function",
  "This procedure retrieves the blending function of the segment at the specified gradient name and segment index.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  2,
  gradient_segment_get_blending_function_inargs,
  1,
  gradient_segment_get_blending_function_outargs,
  { { gradient_segment_get_blending_function_invoker } }
};

static Argument *
gradient_segment_get_coloring_type_invoker (Gimp         *gimp,
                                            GimpContext  *context,
                                            GimpProgress *progress,
                                            Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 segment;
  gint32 coloring_type = 0;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  segment = args[1].value.pdb_int;
  if (segment < 0)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *seg;

          seg = gimp_gradient_segment_get_nth (gradient->segments, segment);

          if (seg)
            {
              coloring_type =
                gimp_gradient_segment_get_coloring_type (gradient, seg);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&gradient_segment_get_coloring_type_proc, success);

  if (success)
    return_args[1].value.pdb_int = coloring_type;

  return return_args;
}

static ProcArg gradient_segment_get_coloring_type_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "segment",
    "The index of the segment within the gradient"
  }
};

static ProcArg gradient_segment_get_coloring_type_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "coloring-type",
    "The coloring type of the segment: { GIMP_GRADIENT_SEGMENT_RGB (0), GIMP_GRADIENT_SEGMENT_HSV_CCW (1), GIMP_GRADIENT_SEGMENT_HSV_CW (2) }"
  }
};

static ProcRecord gradient_segment_get_coloring_type_proc =
{
  "gimp-gradient-segment-get-coloring-type",
  "gimp-gradient-segment-get-coloring-type",
  "Retrieves the gradient segment's coloring type",
  "This procedure retrieves the coloring type of the segment at the specified gradient name and segment index.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  2,
  gradient_segment_get_coloring_type_inargs,
  1,
  gradient_segment_get_coloring_type_outargs,
  { { gradient_segment_get_coloring_type_invoker } }
};

static Argument *
gradient_segment_range_set_blending_function_invoker (Gimp         *gimp,
                                                      GimpContext  *context,
                                                      GimpProgress *progress,
                                                      Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 start_segment;
  gint32 end_segment;
  gint32 blending_function;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  start_segment = args[1].value.pdb_int;
  if (start_segment < 0)
    success = FALSE;

  end_segment = args[2].value.pdb_int;

  blending_function = args[3].value.pdb_int;
  if (blending_function < GIMP_GRADIENT_SEGMENT_LINEAR || blending_function > GIMP_GRADIENT_SEGMENT_SPHERE_DECREASING)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *start_seg, *end_seg;
          start_seg = gimp_gradient_segment_get_nth (gradient->segments,
                                                     start_segment);
          if (start_seg)
            {
              if ((end_segment < start_segment) && (end_segment >= 0))
                {
                  /* Do Nothing */
                  success = FALSE;
                }
              else
                {
                  if (end_segment < 0)
                    {
                      end_seg = NULL;
                    }
                  else
                    {
                      end_seg = gimp_gradient_segment_get_nth (start_seg,
                                                               end_segment -
                                                               start_segment);
                    }

                  /* Success */
                  gimp_gradient_segment_range_set_blending_function (gradient,
                                                                     start_seg,
                                                                     end_seg,
                                                                     blending_function);
                }
            }
          else
            {
              success = FALSE;
            }
        }
    }

  return procedural_db_return_args (&gradient_segment_range_set_blending_function_proc, success);
}

static ProcArg gradient_segment_range_set_blending_function_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "start-segment",
    "The index of the first segment to operate on"
  },
  {
    GIMP_PDB_INT32,
    "end-segment",
    "The index of the last segment to operate on. If negative, the selection will extend to the end of the string."
  },
  {
    GIMP_PDB_INT32,
    "blending-function",
    "The Blending Function: { GIMP_GRADIENT_SEGMENT_LINEAR (0), GIMP_GRADIENT_SEGMENT_CURVED (1), GIMP_GRADIENT_SEGMENT_SINE (2), GIMP_GRADIENT_SEGMENT_SPHERE_INCREASING (3), GIMP_GRADIENT_SEGMENT_SPHERE_DECREASING (4) }"
  }
};

static ProcRecord gradient_segment_range_set_blending_function_proc =
{
  "gimp-gradient-segment-range-set-blending-function",
  "gimp-gradient-segment-range-set-blending-function",
  "Change the blending function of a segments range",
  "This function changes the blending function of a segment range to the specified blending function.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  4,
  gradient_segment_range_set_blending_function_inargs,
  0,
  NULL,
  { { gradient_segment_range_set_blending_function_invoker } }
};

static Argument *
gradient_segment_range_set_coloring_type_invoker (Gimp         *gimp,
                                                  GimpContext  *context,
                                                  GimpProgress *progress,
                                                  Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 start_segment;
  gint32 end_segment;
  gint32 coloring_type;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  start_segment = args[1].value.pdb_int;
  if (start_segment < 0)
    success = FALSE;

  end_segment = args[2].value.pdb_int;

  coloring_type = args[3].value.pdb_int;
  if (coloring_type < GIMP_GRADIENT_SEGMENT_RGB || coloring_type > GIMP_GRADIENT_SEGMENT_HSV_CW)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *start_seg, *end_seg;
          start_seg = gimp_gradient_segment_get_nth (gradient->segments,
                                                     start_segment);
          if (start_seg)
            {
              if ((end_segment < start_segment) && (end_segment >= 0))
                {
                  /* Do Nothing */
                  success = FALSE;
                }
              else
                {
                  if (end_segment < 0)
                    {
                      end_seg = NULL;
                    }
                  else
                    {
                      end_seg = gimp_gradient_segment_get_nth (start_seg,
                                                               end_segment -
                                                               start_segment);
                    }

                  /* Success */
                  gimp_gradient_segment_range_set_coloring_type (gradient,
                                                                 start_seg,
                                                                 end_seg,
                                                                 coloring_type);
                }
            }
          else
            {
              success = FALSE;
            }
        }
    }

  return procedural_db_return_args (&gradient_segment_range_set_coloring_type_proc, success);
}

static ProcArg gradient_segment_range_set_coloring_type_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "start-segment",
    "The index of the first segment to operate on"
  },
  {
    GIMP_PDB_INT32,
    "end-segment",
    "The index of the last segment to operate on. If negative, the selection will extend to the end of the string."
  },
  {
    GIMP_PDB_INT32,
    "coloring-type",
    "The Coloring Type: { GIMP_GRADIENT_SEGMENT_RGB (0), GIMP_GRADIENT_SEGMENT_HSV_CCW (1), GIMP_GRADIENT_SEGMENT_HSV_CW (2) }"
  }
};

static ProcRecord gradient_segment_range_set_coloring_type_proc =
{
  "gimp-gradient-segment-range-set-coloring-type",
  "gimp-gradient-segment-range-set-coloring-type",
  "Change the coloring type of a segments range",
  "This function changes the coloring type of a segment range to the specified coloring type.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  4,
  gradient_segment_range_set_coloring_type_inargs,
  0,
  NULL,
  { { gradient_segment_range_set_coloring_type_invoker } }
};

static Argument *
gradient_segment_range_flip_invoker (Gimp         *gimp,
                                     GimpContext  *context,
                                     GimpProgress *progress,
                                     Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 start_segment;
  gint32 end_segment;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  start_segment = args[1].value.pdb_int;
  if (start_segment < 0)
    success = FALSE;

  end_segment = args[2].value.pdb_int;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *start_seg, *end_seg;
          start_seg = gimp_gradient_segment_get_nth (gradient->segments,
                                                     start_segment);
          if (start_seg)
            {
              if ((end_segment < start_segment) && (end_segment >= 0))
                {
                  /* Do Nothing */
                  success = FALSE;
                }
              else
                {
                  if (end_segment < 0)
                    {
                      end_seg = NULL;
                    }
                  else
                    {
                      end_seg = gimp_gradient_segment_get_nth (start_seg,
                                                               end_segment -
                                                               start_segment);
                    }

                  /* Success */
                  gimp_gradient_segment_range_flip (gradient,
                                                    start_seg,
                                                    end_seg,
                                                    NULL, NULL);
                }
            }
          else
            {
              success = FALSE;
            }
        }
    }

  return procedural_db_return_args (&gradient_segment_range_flip_proc, success);
}

static ProcArg gradient_segment_range_flip_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "start-segment",
    "The index of the first segment to operate on"
  },
  {
    GIMP_PDB_INT32,
    "end-segment",
    "The index of the last segment to operate on. If negative, the selection will extend to the end of the string."
  }
};

static ProcRecord gradient_segment_range_flip_proc =
{
  "gimp-gradient-segment-range-flip",
  "gimp-gradient-segment-range-flip",
  "Flip the segment range",
  "This function flips a segment range.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  3,
  gradient_segment_range_flip_inargs,
  0,
  NULL,
  { { gradient_segment_range_flip_invoker } }
};

static Argument *
gradient_segment_range_replicate_invoker (Gimp         *gimp,
                                          GimpContext  *context,
                                          GimpProgress *progress,
                                          Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 start_segment;
  gint32 end_segment;
  gint32 replicate_times;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  start_segment = args[1].value.pdb_int;
  if (start_segment < 0)
    success = FALSE;

  end_segment = args[2].value.pdb_int;

  replicate_times = args[3].value.pdb_int;
  if (replicate_times < 2 || replicate_times > 20)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *start_seg, *end_seg;
          start_seg = gimp_gradient_segment_get_nth (gradient->segments,
                                                     start_segment);
          if (start_seg)
            {
              if ((end_segment < start_segment) && (end_segment >= 0))
                {
                  /* Do Nothing */
                  success = FALSE;
                }
              else
                {
                  if (end_segment < 0)
                    {
                      end_seg = NULL;
                    }
                  else
                    {
                      end_seg = gimp_gradient_segment_get_nth (start_seg,
                                                               end_segment -
                                                               start_segment);
                    }

                  /* Success */
                  gimp_gradient_segment_range_replicate (gradient,
                                                         start_seg,
                                                         end_seg,
                                                         replicate_times,
                                                         NULL, NULL);
                }
            }
          else
            {
              success = FALSE;
            }
        }
    }

  return procedural_db_return_args (&gradient_segment_range_replicate_proc, success);
}

static ProcArg gradient_segment_range_replicate_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "start-segment",
    "The index of the first segment to operate on"
  },
  {
    GIMP_PDB_INT32,
    "end-segment",
    "The index of the last segment to operate on. If negative, the selection will extend to the end of the string."
  },
  {
    GIMP_PDB_INT32,
    "replicate-times",
    "The number of times to replicate"
  }
};

static ProcRecord gradient_segment_range_replicate_proc =
{
  "gimp-gradient-segment-range-replicate",
  "gimp-gradient-segment-range-replicate",
  "Replicate the segment range",
  "This function replicates a segment range a given number of times. Instead of the original segment range, several smaller scaled copies of it will appear in equal widths.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  4,
  gradient_segment_range_replicate_inargs,
  0,
  NULL,
  { { gradient_segment_range_replicate_invoker } }
};

static Argument *
gradient_segment_range_split_midpoint_invoker (Gimp         *gimp,
                                               GimpContext  *context,
                                               GimpProgress *progress,
                                               Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 start_segment;
  gint32 end_segment;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  start_segment = args[1].value.pdb_int;
  if (start_segment < 0)
    success = FALSE;

  end_segment = args[2].value.pdb_int;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *start_seg, *end_seg;
          start_seg = gimp_gradient_segment_get_nth (gradient->segments,
                                                     start_segment);
          if (start_seg)
            {
              if ((end_segment < start_segment) && (end_segment >= 0))
                {
                  /* Do Nothing */
                  success = FALSE;
                }
              else
                {
                  if (end_segment < 0)
                    {
                      end_seg = NULL;
                    }
                  else
                    {
                      end_seg = gimp_gradient_segment_get_nth (start_seg,
                                                               end_segment -
                                                               start_segment);
                    }

                  /* Success */
                  gimp_gradient_segment_range_split_midpoint (gradient,
                                                              start_seg,
                                                              end_seg,
                                                              NULL, NULL);
                }
            }
          else
            {
              success = FALSE;
            }
        }
    }

  return procedural_db_return_args (&gradient_segment_range_split_midpoint_proc, success);
}

static ProcArg gradient_segment_range_split_midpoint_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "start-segment",
    "The index of the first segment to operate on"
  },
  {
    GIMP_PDB_INT32,
    "end-segment",
    "The index of the last segment to operate on. If negative, the selection will extend to the end of the string."
  }
};

static ProcRecord gradient_segment_range_split_midpoint_proc =
{
  "gimp-gradient-segment-range-split-midpoint",
  "gimp-gradient-segment-range-split-midpoint",
  "Splits each segment in the segment range at midpoint",
  "This function splits each segment in the segment range at its midpoint.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  3,
  gradient_segment_range_split_midpoint_inargs,
  0,
  NULL,
  { { gradient_segment_range_split_midpoint_invoker } }
};

static Argument *
gradient_segment_range_split_uniform_invoker (Gimp         *gimp,
                                              GimpContext  *context,
                                              GimpProgress *progress,
                                              Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 start_segment;
  gint32 end_segment;
  gint32 split_parts;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  start_segment = args[1].value.pdb_int;
  if (start_segment < 0)
    success = FALSE;

  end_segment = args[2].value.pdb_int;

  split_parts = args[3].value.pdb_int;
  if (split_parts < 2 || split_parts > 20)
    success = FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *start_seg, *end_seg;
          start_seg = gimp_gradient_segment_get_nth (gradient->segments,
                                                     start_segment);
          if (start_seg)
            {
              if ((end_segment < start_segment) && (end_segment >= 0))
                {
                  /* Do Nothing */
                  success = FALSE;
                }
              else
                {
                  if (end_segment < 0)
                    {
                      end_seg = NULL;
                    }
                  else
                    {
                      end_seg = gimp_gradient_segment_get_nth (start_seg,
                                                               end_segment -
                                                               start_segment);
                    }

                  /* Success */
                  gimp_gradient_segment_range_split_uniform (gradient,
                                                             start_seg,
                                                             end_seg,
                                                             split_parts,
                                                             NULL, NULL);
                }
            }
          else
            {
              success = FALSE;
            }
        }
    }

  return procedural_db_return_args (&gradient_segment_range_split_uniform_proc, success);
}

static ProcArg gradient_segment_range_split_uniform_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "start-segment",
    "The index of the first segment to operate on"
  },
  {
    GIMP_PDB_INT32,
    "end-segment",
    "The index of the last segment to operate on. If negative, the selection will extend to the end of the string."
  },
  {
    GIMP_PDB_INT32,
    "split-parts",
    "The number of uniform divisions to split each segment to"
  }
};

static ProcRecord gradient_segment_range_split_uniform_proc =
{
  "gimp-gradient-segment-range-split-uniform",
  "gimp-gradient-segment-range-split-uniform",
  "Splits each segment in the segment range uniformly",
  "This function splits each segment in the segment range uniformly according to the number of times specified by the parameter.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  4,
  gradient_segment_range_split_uniform_inargs,
  0,
  NULL,
  { { gradient_segment_range_split_uniform_invoker } }
};

static Argument *
gradient_segment_range_delete_invoker (Gimp         *gimp,
                                       GimpContext  *context,
                                       GimpProgress *progress,
                                       Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 start_segment;
  gint32 end_segment;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  start_segment = args[1].value.pdb_int;
  if (start_segment < 0)
    success = FALSE;

  end_segment = args[2].value.pdb_int;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *start_seg, *end_seg;
          start_seg = gimp_gradient_segment_get_nth (gradient->segments,
                                                     start_segment);
          if (start_seg)
            {
              if ((end_segment < start_segment) && (end_segment >= 0))
                {
                  /* Do Nothing */
                  success = FALSE;
                }
              else
                {
                  if (end_segment < 0)
                    {
                      end_seg = NULL;
                    }
                  else
                    {
                      end_seg = gimp_gradient_segment_get_nth (start_seg,
                                                               end_segment -
                                                               start_segment);
                    }

                  /* Success */
                  gimp_gradient_segment_range_delete (gradient,
                                                      start_seg,
                                                      end_seg,
                                                      NULL, NULL);
                }
            }
          else
            {
              success = FALSE;
            }
        }
    }

  return procedural_db_return_args (&gradient_segment_range_delete_proc, success);
}

static ProcArg gradient_segment_range_delete_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "start-segment",
    "The index of the first segment to operate on"
  },
  {
    GIMP_PDB_INT32,
    "end-segment",
    "The index of the last segment to operate on. If negative, the selection will extend to the end of the string."
  }
};

static ProcRecord gradient_segment_range_delete_proc =
{
  "gimp-gradient-segment-range-delete",
  "gimp-gradient-segment-range-delete",
  "Delete the segment range",
  "This function deletes a segment range.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  3,
  gradient_segment_range_delete_inargs,
  0,
  NULL,
  { { gradient_segment_range_delete_invoker } }
};

static Argument *
gradient_segment_range_redistribute_handles_invoker (Gimp         *gimp,
                                                     GimpContext  *context,
                                                     GimpProgress *progress,
                                                     Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 start_segment;
  gint32 end_segment;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  start_segment = args[1].value.pdb_int;
  if (start_segment < 0)
    success = FALSE;

  end_segment = args[2].value.pdb_int;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *start_seg, *end_seg;
          start_seg = gimp_gradient_segment_get_nth (gradient->segments,
                                                     start_segment);
          if (start_seg)
            {
              if ((end_segment < start_segment) && (end_segment >= 0))
                {
                  /* Do Nothing */
                  success = FALSE;
                }
              else
                {
                  if (end_segment < 0)
                    {
                      end_seg = NULL;
                    }
                  else
                    {
                      end_seg = gimp_gradient_segment_get_nth (start_seg,
                                                               end_segment -
                                                               start_segment);
                    }

                  /* Success */
                  gimp_gradient_segment_range_redistribute_handles (gradient,
                                                                    start_seg,
                                                                    end_seg);
                }
            }
          else
            {
              success = FALSE;
            }
        }
    }

  return procedural_db_return_args (&gradient_segment_range_redistribute_handles_proc, success);
}

static ProcArg gradient_segment_range_redistribute_handles_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "start-segment",
    "The index of the first segment to operate on"
  },
  {
    GIMP_PDB_INT32,
    "end-segment",
    "The index of the last segment to operate on. If negative, the selection will extend to the end of the string."
  }
};

static ProcRecord gradient_segment_range_redistribute_handles_proc =
{
  "gimp-gradient-segment-range-redistribute-handles",
  "gimp-gradient-segment-range-redistribute-handles",
  "Uniformly redistribute the segment range's handles",
  "This function redistributes the handles of the specified segment range of the specified gradient, so they'll be evenly spaced.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  3,
  gradient_segment_range_redistribute_handles_inargs,
  0,
  NULL,
  { { gradient_segment_range_redistribute_handles_invoker } }
};

static Argument *
gradient_segment_range_blend_colors_invoker (Gimp         *gimp,
                                             GimpContext  *context,
                                             GimpProgress *progress,
                                             Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 start_segment;
  gint32 end_segment;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  start_segment = args[1].value.pdb_int;
  if (start_segment < 0)
    success = FALSE;

  end_segment = args[2].value.pdb_int;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *start_seg, *end_seg;
          start_seg = gimp_gradient_segment_get_nth (gradient->segments,
                                                     start_segment);
          if (start_seg)
            {
              if ((end_segment < start_segment) && (end_segment >= 0))
                {
                  /* Do Nothing */
                  success = FALSE;
                }
              else
                {
                  if (end_segment < 0)
                    {
                      end_seg = NULL;
                    }
                  else
                    {
                      end_seg = gimp_gradient_segment_get_nth (start_seg,
                                                               end_segment -
                                                               start_segment);
                    }

                  /* Success */
                  gimp_gradient_segment_range_blend (gradient,
                                                     start_seg, end_seg,
                                                     &start_seg->left_color,
                                                     &end_seg->right_color,
                                                     TRUE, FALSE);
                }
            }
          else
            {
              success = FALSE;
            }
        }
    }

  return procedural_db_return_args (&gradient_segment_range_blend_colors_proc, success);
}

static ProcArg gradient_segment_range_blend_colors_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "start-segment",
    "The index of the first segment to operate on"
  },
  {
    GIMP_PDB_INT32,
    "end-segment",
    "The index of the last segment to operate on. If negative, the selection will extend to the end of the string."
  }
};

static ProcRecord gradient_segment_range_blend_colors_proc =
{
  "gimp-gradient-segment-range-blend-colors",
  "gimp-gradient-segment-range-blend-colors",
  "Blend the colors of the segment range.",
  "This function blends the colors (but not the opacity) of the segments' range of the gradient. Using it, the colors' transition will be uniform across the range.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  3,
  gradient_segment_range_blend_colors_inargs,
  0,
  NULL,
  { { gradient_segment_range_blend_colors_invoker } }
};

static Argument *
gradient_segment_range_blend_opacity_invoker (Gimp         *gimp,
                                              GimpContext  *context,
                                              GimpProgress *progress,
                                              Argument     *args)
{
  gboolean success = TRUE;
  gchar *name;
  gint32 start_segment;
  gint32 end_segment;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  start_segment = args[1].value.pdb_int;
  if (start_segment < 0)
    success = FALSE;

  end_segment = args[2].value.pdb_int;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *start_seg, *end_seg;
          start_seg = gimp_gradient_segment_get_nth (gradient->segments,
                                                     start_segment);
          if (start_seg)
            {
              if ((end_segment < start_segment) && (end_segment >= 0))
                {
                  /* Do Nothing */
                  success = FALSE;
                }
              else
                {
                  if (end_segment < 0)
                    {
                      end_seg = NULL;
                    }
                  else
                    {
                      end_seg = gimp_gradient_segment_get_nth (start_seg,
                                                               end_segment -
                                                               start_segment);
                    }

                  /* Success */
                  gimp_gradient_segment_range_blend (gradient,
                                                     start_seg, end_seg,
                                                     &start_seg->left_color,
                                                     &end_seg->right_color,
                                                     FALSE, TRUE);
                }
            }
          else
            {
              success = FALSE;
            }
        }
    }

  return procedural_db_return_args (&gradient_segment_range_blend_opacity_proc, success);
}

static ProcArg gradient_segment_range_blend_opacity_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "start-segment",
    "The index of the first segment to operate on"
  },
  {
    GIMP_PDB_INT32,
    "end-segment",
    "The index of the last segment to operate on. If negative, the selection will extend to the end of the string."
  }
};

static ProcRecord gradient_segment_range_blend_opacity_proc =
{
  "gimp-gradient-segment-range-blend-opacity",
  "gimp-gradient-segment-range-blend-opacity",
  "Blend the opacity of the segment range.",
  "This function blends the opacity (but not the colors) of the segments' range of the gradient. Using it, the opacity's transition will be uniform across the range.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  3,
  gradient_segment_range_blend_opacity_inargs,
  0,
  NULL,
  { { gradient_segment_range_blend_opacity_invoker } }
};

static Argument *
gradient_segment_range_move_invoker (Gimp         *gimp,
                                     GimpContext  *context,
                                     GimpProgress *progress,
                                     Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 start_segment;
  gint32 end_segment;
  gdouble delta;
  gboolean control_compress;
  gdouble final_delta = 0;
  GimpGradient *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  start_segment = args[1].value.pdb_int;
  if (start_segment < 0)
    success = FALSE;

  end_segment = args[2].value.pdb_int;

  delta = args[3].value.pdb_float;
  if (delta < -1.0 || delta > 1.0)
    success = FALSE;

  control_compress = args[4].value.pdb_int ? TRUE : FALSE;

  if (success)
    {
      gradient = (GimpGradient *)
        gimp_container_get_child_by_name (gimp->gradient_factory->container, name);

      if (gradient)
        {
          GimpGradientSegment *start_seg, *end_seg;
          start_seg = gimp_gradient_segment_get_nth (gradient->segments,
                                                     start_segment);
          if (start_seg)
            {
              if ((end_segment < start_segment) && (end_segment >= 0))
                {
                  /* Do Nothing */
                  success = FALSE;
                }
              else
                {
                  if (end_segment < 0)
                    {
                      end_seg = NULL;
                    }
                  else
                    {
                      end_seg = gimp_gradient_segment_get_nth (start_seg,
                                                               end_segment -
                                                               start_segment);
                    }

                  /* Success */
                  final_delta = gimp_gradient_segment_range_move (gradient,
                                                                  start_seg,
                                                                  end_seg,
                                                                  delta,
                                                                  control_compress);

                }
            }
          else
            {
              success = FALSE;
            }
        }
    }

  return_args = procedural_db_return_args (&gradient_segment_range_move_proc, success);

  if (success)
    return_args[1].value.pdb_float = final_delta;

  return return_args;
}

static ProcArg gradient_segment_range_move_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    GIMP_PDB_INT32,
    "start-segment",
    "The index of the first segment to operate on"
  },
  {
    GIMP_PDB_INT32,
    "end-segment",
    "The index of the last segment to operate on. If negative, the selection will extend to the end of the string."
  },
  {
    GIMP_PDB_FLOAT,
    "delta",
    "The delta to move the segment range"
  },
  {
    GIMP_PDB_INT32,
    "control-compress",
    "Whether or not to compress the neighboring segments"
  }
};

static ProcArg gradient_segment_range_move_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "final-delta",
    "The final delta by which the range moved"
  }
};

static ProcRecord gradient_segment_range_move_proc =
{
  "gimp-gradient-segment-range-move",
  "gimp-gradient-segment-range-move",
  "Move the position of an entire segment range by a delta.",
  "This funtions moves the position of an entire segment range by a delta. The actual delta (which is returned) will be limited by the control points of the neighboring segments.",
  "Shlomi Fish",
  "Shlomi Fish",
  "2003",
  NULL,
  GIMP_INTERNAL,
  5,
  gradient_segment_range_move_inargs,
  1,
  gradient_segment_range_move_outargs,
  { { gradient_segment_range_move_invoker } }
};
