/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIMP_ERASER_H__
#define __GIMP_ERASER_H__


#include "gimppaintcore.h"
#include "gimppaintoptions.h"


#define GIMP_TYPE_ERASER            (gimp_eraser_get_type ())
#define GIMP_ERASER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIMP_TYPE_ERASER, GimpEraser))
#define GIMP_ERASER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GIMP_TYPE_ERASER, GimpEraserClass))
#define GIMP_IS_ERASER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIMP_TYPE_ERASER))
#define GIMP_IS_ERASER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GIMP_TYPE_ERASER))
#define GIMP_ERASER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GIMP_TYPE_ERASER, GimpEraserClass))


typedef struct _GimpEraser      GimpEraser;
typedef struct _GimpEraserClass GimpEraserClass;

struct _GimpEraser
{
  GimpPaintCore parent_instance;
};

struct _GimpEraserClass
{
  GimpPaintCoreClass parent_class;
};


typedef struct _GimpEraserOptions GimpEraserOptions;

struct _GimpEraserOptions
{
  GimpPaintOptions  paint_options;

  gboolean          hard;
  gboolean          hard_d;
  GtkWidget        *hard_w;

  gboolean          anti_erase;
  gboolean          anti_erase_d;
  GtkWidget        *anti_erase_w;
};


void    gimp_eraser_register (Gimp                      *gimp,
                              GimpPaintRegisterCallback  callback);

GType   gimp_eraser_get_type (void) G_GNUC_CONST;


GimpEraserOptions * gimp_eraser_options_new (GimpContext *context);


#endif  /*  __GIMP_ERASER_H__  */
