/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-1999 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "procedural_db.h"

#include <string.h>

#include "brush_select.h"
#include "gimpbrushlist.h"
#include "paint_funcs.h"

static ProcRecord brushes_popup_proc;
static ProcRecord brushes_close_popup_proc;
static ProcRecord brushes_set_popup_proc;

void
register_brush_select_procs (void)
{
  procedural_db_register (&brushes_popup_proc);
  procedural_db_register (&brushes_close_popup_proc);
  procedural_db_register (&brushes_set_popup_proc);
}

static BrushSelectP
brush_get_brushselect (gchar *name)
{
  GSList *list = brush_active_dialogs;
  BrushSelectP bsp;

  while (list)
    {
      bsp = (BrushSelectP) list->data;
      
      if (!strcmp (name, bsp->callback_name))
	return bsp;

      list = list->next;
    }

  return NULL;
}

static Argument *
brushes_popup_invoker (Argument *args)
{
  gboolean success = TRUE;
  gchar *name;
  gchar *title;
  gchar *brush;
  gdouble opacity;
  gint32 spacing;
  gint32 paint_mode;
  ProcRecord *prec;
  BrushSelectP newdialog;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL)
    success = FALSE;

  title = (gchar *) args[1].value.pdb_pointer;
  if (title == NULL)
    success = FALSE;

  brush = (gchar *) args[2].value.pdb_pointer;

  opacity = args[3].value.pdb_float;

  spacing = args[4].value.pdb_int;

  paint_mode = args[5].value.pdb_int;
  if (paint_mode < NORMAL_MODE || paint_mode > DIVIDE_MODE)
    success = FALSE;

  if (success)
    {
      if ((prec = procedural_db_lookup (name)))
	{
	  if (brush && strlen (brush))
	    newdialog = brush_select_new (title, brush, opacity, spacing,
					  paint_mode);
	  else
	    newdialog = brush_select_new (title, NULL, 0.0, 0, 0);
    
	  /* Add to list of proc to run when brush changes */
	  /* change_callbacks = g_list_append (change_callbacks, g_strdup (name)); */
	  newdialog->callback_name = g_strdup (name);
    
	  /* Add to active brush dialogs list */
	  brush_active_dialogs = g_slist_append (brush_active_dialogs, newdialog);
	}
      else
	success = FALSE;
    }

  return procedural_db_return_args (&brushes_popup_proc, success);
}

static ProcArg brushes_popup_inargs[] =
{
  {
    PDB_STRING,
    "brush_callback",
    "The callback PDB proc to call when brush selection is made"
  },
  {
    PDB_STRING,
    "popup_title",
    "Title to give the brush popup window"
  },
  {
    PDB_STRING,
    "initial_brush",
    "The name of the brush to set as the first selected"
  },
  {
    PDB_FLOAT,
    "opacity",
    "The initial opacity of the brush"
  },
  {
    PDB_INT32,
    "spacing",
    "The initial spacing of the brush (if < 0 then use brush default spacing)"
  },
  {
    PDB_INT32,
    "paint_mode",
    "The initial paint mode: { NORMAL (0), DISSOLVE (1), BEHIND (2), MULTIPLY/BURN (3), SCREEN (4), OVERLAY (5), DIFFERENCE (6), ADDITION (7), SUBTRACT (8), DARKEN_ONLY (9), LIGHTEN_ONLY (10), HUE (11), SATURATION (12), COLOR (13), VALUE (14), DIVIDE/DODGE (15) }"
  }
};

static ProcRecord brushes_popup_proc =
{
  "gimp_brushes_popup",
  "Invokes the Gimp brush selection.",
  "This procedure popups the brush selection dialog.",
  "Andy Thomas",
  "Andy Thomas",
  "1998",
  PDB_INTERNAL,
  6,
  brushes_popup_inargs,
  0,
  NULL,
  { { brushes_popup_invoker } }
};

static Argument *
brushes_close_popup_invoker (Argument *args)
{
  gboolean success = TRUE;
  gchar *name;
  ProcRecord *prec;
  BrushSelectP bsp;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL)
    success = FALSE;

  if (success)
    {
      if ((prec = procedural_db_lookup (name)) &&
	  (bsp = brush_get_brushselect (name)))
	{
	  brush_active_dialogs = g_slist_remove (brush_active_dialogs, bsp);
    
	  if (GTK_WIDGET_VISIBLE (bsp->shell))
	    gtk_widget_hide (bsp->shell);
    
	  /* Free memory if poping down dialog which is not the main one */
	  if (bsp != brush_select_dialog)
	    {
	      gtk_widget_destroy (bsp->shell);
	      brush_select_free (bsp);
	    }
	}
      else
	success = FALSE;
    }

  return procedural_db_return_args (&brushes_close_popup_proc, success);
}

static ProcArg brushes_close_popup_inargs[] =
{
  {
    PDB_STRING,
    "brush_callback",
    "The name of the callback registered for this popup"
  }
};

static ProcRecord brushes_close_popup_proc =
{
  "gimp_brushes_close_popup",
  "Popdown the Gimp brush selection.",
  "This procedure closes an opened brush selection dialog.",
  "Andy Thomas",
  "Andy Thomas",
  "1998",
  PDB_INTERNAL,
  1,
  brushes_close_popup_inargs,
  0,
  NULL,
  { { brushes_close_popup_invoker } }
};

static Argument *
brushes_set_popup_invoker (Argument *args)
{
  gboolean success = TRUE;
  gchar *name;
  gchar *brush_name;
  gdouble opacity;
  gint32 spacing;
  gint32 paint_mode;
  ProcRecord *prec;
  BrushSelectP bsp;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL)
    success = FALSE;

  brush_name = (gchar *) args[1].value.pdb_pointer;
  if (brush_name == NULL)
    success = FALSE;

  opacity = args[2].value.pdb_float;

  spacing = args[3].value.pdb_int;

  paint_mode = args[4].value.pdb_int;
  if (paint_mode < NORMAL_MODE || paint_mode > DIVIDE_MODE)
    success = FALSE;

  if (success)
    {
      if ((prec = procedural_db_lookup (name)) &&
	  (bsp = brush_get_brushselect (name)))
	{
	  GimpBrushP active = gimp_brush_list_get_brush (brush_list, brush_name);
    
	  if (active)
	    {
	      /* Must alter the wigdets on screen as well */
    
	      bsp->brush = active;
	      brush_select_select (bsp, gimp_brush_list_get_brush_index (brush_list, active));
    
	      bsp->opacity_value = opacity;
	      bsp->spacing_value = spacing;
	      bsp->paint_mode = paint_mode;
    
	      bsp->spacing_data->value = bsp->spacing_value;
	      gtk_signal_emit_by_name (GTK_OBJECT (bsp->spacing_data),
				       "value_changed");
    
	      bsp->opacity_data->value = bsp->opacity_value * 100.0;
	      gtk_signal_emit_by_name (GTK_OBJECT (bsp->opacity_data),
				       "value_changed");
	      
	      gtk_option_menu_set_history (GTK_OPTION_MENU (bsp->option_menu), bsp->paint_mode);
    
	    }
	  else
	    success = FALSE;
	}
      else
	success = FALSE;
    }

  return procedural_db_return_args (&brushes_set_popup_proc, success);
}

static ProcArg brushes_set_popup_inargs[] =
{
  {
    PDB_STRING,
    "brush_callback",
    "The name of the callback registered for this popup"
  },
  {
    PDB_STRING,
    "brush_name",
    "The name of the brush to set as selected"
  },
  {
    PDB_FLOAT,
    "opacity",
    "The initial opacity of the brush"
  },
  {
    PDB_INT32,
    "spacing",
    "The initial spacing of the brush (if < 0 then use brush default spacing)"
  },
  {
    PDB_INT32,
    "paint_mode",
    "The initial paint mode: { NORMAL (0), DISSOLVE (1), BEHIND (2), MULTIPLY/BURN (3), SCREEN (4), OVERLAY (5), DIFFERENCE (6), ADDITION (7), SUBTRACT (8), DARKEN_ONLY (9), LIGHTEN_ONLY (10), HUE (11), SATURATION (12), COLOR (13), VALUE (14), DIVIDE/DODGE (15) }"
  }
};

static ProcRecord brushes_set_popup_proc =
{
  "gimp_brushes_set_popup",
  "Sets the current brush selection in a popup.",
  "Sets the current brush selection in a popup.",
  "Andy Thomas",
  "Andy Thomas",
  "1998",
  PDB_INTERNAL,
  5,
  brushes_set_popup_inargs,
  0,
  NULL,
  { { brushes_set_popup_invoker } }
};
