/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpgimprc_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"

gchar *
gimp_gimprc_query (gchar *token)
{
  GParam *return_vals;
  gint nreturn_vals;
  gchar *value = NULL;

  return_vals = gimp_run_procedure ("gimp_gimprc_query",
				    &nreturn_vals,
				    PARAM_STRING, token,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    value = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return value;
}

void
gimp_gimprc_set (gchar *token,
		 gchar *value)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_gimprc_set",
				    &nreturn_vals,
				    PARAM_STRING, token,
				    PARAM_STRING, value,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_get_monitor_resolution (gdouble *xres,
			     gdouble *yres)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_get_monitor_resolution",
				    &nreturn_vals,
				    PARAM_END);

  *xres = 0.0;
  *yres = 0.0;

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    {
      *xres = return_vals[1].data.d_float;
      *yres = return_vals[2].data.d_float;
    }

  gimp_destroy_params (return_vals, nreturn_vals);
}
