#include "libgimp/stdplugins-intl.h"

printer_t printers[] = /* List of supported printer types */
{
  {
    N_("PostScript Level 1"),
    "ps",
    1,
    0,
    1.000,
    1.000,
    ps_parameters,
    ps_media_size,
    ps_imageable_area,
    ps_print
  },
  {
    N_("PostScript Level 2"),
    "ps2",
    1,
    1,
    1.000,
    1.000,
    ps_parameters,
    ps_media_size,
    ps_imageable_area,
    ps_print
  },
  {
    N_("HP DeskJet 500, 520"),
    "pcl-500",
    0,
    500,
    0.818,
    0.786,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("HP DeskJet 500C, 540C"),
    "pcl-501",
    1,
    501,
    0.818,
    0.786,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("HP DeskJet 550C, 560C"),
    "pcl-550",
    1,
    550,
    0.818,
    0.786,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("HP DeskJet 600 series"),
    "pcl-600",
    1,
    600,
    0.818,
    0.786,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print },
  {
    N_("HP DeskJet 800 series"),
    "pcl-800",
    1,
    800,
    0.818,
    0.786,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("HP DeskJet 1100C, 1120C"),
    "pcl-1100",
    1,
    1100,
    0.818,
    0.786,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("HP DeskJet 1200C, 1600C"),
    "pcl-1200",
    1,
    1200,
    0.818,
    0.786,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("HP LaserJet II series"),
    "pcl-2",
    0,
    2,
    1.000,
    0.596,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("HP LaserJet III series"),
    "pcl-3",
    0,
    3,
    1.000,
    0.596,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("HP LaserJet 4 series"),
    "pcl-4",
    0,
    4,
    1.000,
    0.615,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("HP LaserJet 4V, 4Si"),
    "pcl-4v",
    0,
    5,
    1.000,
    0.615,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("HP LaserJet 5 series"),
    "pcl-5",
    0,
    4,
    1.000,
    0.615,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("HP LaserJet 5Si"),
    "pcl-5si",
    0,
    5,
    1.000,
    0.615,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("HP LaserJet 6 series"),
    "pcl-6",
    0,
    4,
    1.000,
    0.615,
    pcl_parameters,
    default_media_size,
    pcl_imageable_area,
    pcl_print
  },
  {
    N_("EPSON Stylus Color"),
    "escp2",
    1,
    0,
    0.597,
    0.568,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  },
  {
    N_("EPSON Stylus Color Pro"),
    "escp2-pro",
    1,
    1,
    0.597,
    0.631,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  },
  {
    N_("EPSON Stylus Color Pro XL"),
    "escp2-proxl",
    1,
    1,
    0.597,
    0.631,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  },
  {
    N_("EPSON Stylus Color 1500"),
    "escp2-1500",
    1,
    2,
    0.597,
    0.631,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  },
  {
    N_("EPSON Stylus Color 400"),
    "escp2-400",
    1,
    1,
    0.585,
    0.646,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  },
  {
    N_("EPSON Stylus Color 500"),
    "escp2-500",
    1,
    1,
    0.597,
    0.631,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  },
  {
    N_("EPSON Stylus Color 600"),
    "escp2-600",
    1,
    3,
    0.585,
    0.646,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  },
  {
    N_("EPSON Stylus Color 800"),
    "escp2-800",
    1,
    4,
    0.585,
    0.646,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  },
  {
    N_("EPSON Stylus Color 1520"),
    "escp2-1520",
    1,
    5,
    0.585,
    0.646,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  },
  {
    N_("EPSON Stylus Color 3000"),
    "escp2-3000",
    1,
    5,
    0.585,
    0.646,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  },
  {
    N_("EPSON Stylus Photo 700"),
    "escp2-700",
    1,
    6,
    0.585,
    0.646,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  },
  {
    N_("EPSON Stylus Photo EX"),
    "escp2-ex",
    1,
    7,
    0.585,
    0.646,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  },
  {
    N_("EPSON Stylus Photo"),
    "escp2-photo",
    1,
    8,
    0.585,
    0.646,
    escp2_parameters,
    default_media_size,
    escp2_imageable_area,
    escp2_print
  }
};
const static int printer_count = sizeof(printers) / sizeof(printer_t);
