/*  GIMP header image file format (RGB-only): /home/quinet/gimpdev/wilber.h  */

static unsigned int wilber_width = 84;
static unsigned int wilber_height = 70;

/*  Call this macro repeatedly.  After each use, the pixel data can be extracted  */

#define HEADER_PIXEL(data,pixel) \
  pixel[0] = (((data[0] - 33) << 2) | ((data[1] - 33) >> 4)); \
  pixel[1] = ((((data[1] - 33) & 0xF) << 4) | ((data[2] - 33) >> 2)); \
  pixel[2] = ((((data[2] - 33) & 0x3) << 6) | ((data[3] - 33))); \
  data += 4;

static char *wilber_data =
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8R=8&HZ_@"
	"@X^`:'2E45V./TM\\,3UN)S-D(\"Q='BI;'RM<(\"Q=(\"Q=(2U>(2U>)3%B+3EJ.$1U"
	"1U.$6666;WNLB97&I[/DRM<'V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8O\\O\\B97&"
	"6666+#AI%B)3&B97'2E:(\"Q=(R]@)C)C*35F+#AI+CIK,#QM,CYO,S]P-$!Q-4%R"
	"-D)S-D)S-D)S-D)S-4%R-$!Q,S]P,CYO,#QM+CIK0DY_:'2EDY_0PL[_V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8N,3U"
	"=(\"Q-D)S%\"!1&\"15'\"A9(\"Q=)3%B*C9G+SML,S]P.$1U/$AY0$Q]1%\"!1U.$2E:'"
	"3%B)3EJ+3UN,4%R-4%R-45V.45V.4%R-4%R-3UN,3EJ+3%B)2E:'1U.$1%\"!0$Q]"
	"/$AY.$1U4EZ/A9'\"O<GZV^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8C9G*0$Q]$AY/%R-4'\"A9(2U>)S-D+3EJ-$!Q.D9W0$Q]1U.$35F*4U^06&25"
	"76F:86V>97&B:'2E:W>H;7FJ;GJK<'RM<'RM<7VN<7VN<'RM<'RM;GJK;7FJ:W>H"
	":'2E97&B86V>76F:6&254U^035F*1U.$0$Q]86V>G*C9V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8U>(2=X.T(BY?$Q]0&\"15'BI;)#!A+#AI,S]P.T=X1%\"!3%B)5&\"17&B9"
	"9'\"A:W>H<GZO>(2U?8FZ@HZ_AI+#BI;'C)C)CYO,D)S-D9W.DI[/DY_0DY_0DI[/"
	"D9W.D)S-CYO,C)C)BI;'AI+#@HZ_?8FZ>(2U<GZO:W>H9'\"A7&B95&\"13%B)4EZ/"
	"CIK+UN,3V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8>X>X&R=8$Q]0&256'RM<)C)C+SML.$1U0DY_3%B)5F*3"
	"8&R=:G:G<W^P?(BYA)#!C)C)DY_0F:76GJK;HZ_@I[/DJK;GK;GJK[OLL+SMLK[O"
	"LK[OL[_PL[_PLK[OLK[OL+SMK[OLK;GJJK;GI[/DHZ_@GJK;F:76DY_0C)C)A)#!"
	"?(BY<W^P:G:G8&R=5F*35&\"1E*#1V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8EZ/4+#AI$AY/%R-4'BI;)S-D,#QM.D9W15&\""
	"45V.76F::'2E=(\"Q?XN\\BI;'DY_0G*C9I+#AK+CILK[ON,3UO,CYP,S]Q-$!Q]0$"
	"R=8&R]@(S-D)S=H*SML+SML+SML+SML+S=H*S-D)R]@(R=8&Q]0$Q-$!P,S]O,CY"
	"N,3ULK[OK+CII+#AG*C9DY_0BI;'?XN\\=(\"Q:'2E76F:9G*CJK;GV^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8S]P,5V.4$!Q-%2%2'\"A9)#!A+CIK"
	".D9W1E*#4U^08&R=;GJK>X>XB)3%E*#1GZO<J;7FLK[ONL;WP<W^Q]0$S=H*T=X."
	"U>(2V.45V^@8W>H:W^P<X.T=X>X>XN\\?X^`@X^`@X^`@X^`@XN\\?X>X>X.T=W^P<"
	"W>H:V^@8V.45U>(2T=X.S=H*Q]0$P<W^NL;WLK[OJ;7FGZO<E*#1B)3%>X>X;GJK"
	"8&R=A9'\"TM\\/V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8GZO<(R]@$AY/&256"
	"(2U>*S=H-T-T1%\"!4EZ/8&R=;WNL?HJ[C)C)FJ;7IK+CL;WNN\\?XQ-$!S-D)T]`0"
	"V.45W>H:X>X>Y?(BY_0DZO<G[/DI[?HJ[OLK[_PL\\/TM\\?XN\\?XN\\?XN\\?XN\\?XN"
	"\\?XN\\/TM[_PL[OLK[?HJ[/DIZO<GY_0DY?(BX>X>W>H:V.45T]`0S-D)Q-$!N\\?X"
	"L;WNIK+CFJ;7C)C)?HJ[;WNL;7FJM,#QV^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8>H:W"
	"#AI+%\"!1'\"A9)3%B,3UN/DI[35F*76F:;7FJ?8FZC9G*G*C9JK;GML+SP<W^R]@("
	"T]`0V^@8X.T=Y?(BZ?8F[?HJ\\/TM\\O\\O]0$Q]@(R]P,S]`0T^04U^04U^@8V^@8V"
	"^@8V^@8V^@8V^@8V^@8V^@8V^04U^04U]`0T]P,S]@(R]0$Q\\O\\O\\/TM[?HJZ?8F"
	"Y?(BX.T=W.D9T]`0R]@(P<W^ML+SJK;GG*C9C9G*?8FZ;7FJH*S=V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@886V>#QM,%B)3'BI;*35F-D)S15&\"5F*39W.D>86VBI;'FZ?8JK;GN,3U"
	"Q-$!S]P,V.45W^P<YO,CZ_@H[_PL\\O\\O]@(R]`0T^04U^P<W^`@X_0DY_0DY_@HZ"
	"_@HZ_PL[_PL[_PL[_PL[_PL[_PL[_PL[_PL[_PL[_PL[_@HZ_@HZ_0DY_0DY^`@X"
	"^P<W^04U]`0T]@(R\\_`O\\?XM[/DIYO,CW^P<V.45S]P,Q-$!N,3UJK;GFZ?8BI;'"
	">86VEZ/4V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@84U^0$!Q-%R-4(\"Q=+#AI.D9W2U>(76F:=8&QB97%F:76"
	"IK+CML+SP\\_`S]P,V>86X>X>Z/4E[OLK\\O\\O]@(R^04U^P<W^`@X_@HZ_PL[_PL["
	"_`P\\_`P\\`0T]`0T]`0T]`0T]`0T]`0T]`@X^`@X^`@X^`@X^`0T]`0T]`0T]`0T]"
	"`0T]`0T]_`P\\_`P\\_PL[_PL[_@HZ^`@X^`@W^P<V]`0T\\O\\O[OLKZ/4EX>X>V>86"
	"S]P,P\\_`ML+SIK+CE:'2@X^`E:'2V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@84EZ/$!Q-&\"15(BY?+SML/DI[4%R-8V^@"
	">(2UG*?6BY&VQM,\"P\\_`S=H*V.45XN\\?Z?8F[_PL\\_`P]`0T^P<W_0DY_@HZ_PL["
	"_`P\\`0T]`0T]`@X^`@X^`@X^`@X^`@X^`@X^`@X^`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_"
	"`P\\_`P\\_`@X^`@X^`@X^`@X^`@X^`@X^`@X^`0T]`0T]_`P\\_`P[_`P[_`P[^`@X"
	"]`0T\\_`P[_PLZ?8FXN\\?V.45S=H*P,S]L+SMGJK;BY?(F:76V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@876F:$!Q-&\"15(BY?,#QM"
	"0$Q]4U^0:'2E?8FZE*#1NL3S@86IO,7OW^P<W^P<Z/4E[_PL]0$Q^04U^P<W_@HZ"
	"_PL[_`P\\`0T]`0T]`@X^`@X^`@X^`@X^`@X^`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_"
	"`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\^`P\\^`P\\^`@X]`@X]`@X]`@X]`@X]"
	"`0T]`@X]`@X\\`0T\\_`P[]?`K\\O\\N]@(R[_PLZ/4EW^P<U>(2Q]0$N,3UIK+CDI[/"
	"HJ[?V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8=(\"Q#QM,"
	"%R-4)3%B,#QM04U^56&2:G:G@8V^EZ/4L+SMR=8'?H.>@86AY/$@[?HJ\\_`P]`0T"
	"^P<W_@HZ_PL[_`P\\`0T]`@X^`@X^`@X^`@X^`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_"
	"`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^"
	"`P\\^`P\\^`P\\^`@X]`@X]`@X]`@X]`@X]^P<UT-'B_@<U_PLZ^04U\\_`P[?HJY?(B"
	"VN<7S=H*OLK[J[?HEZ/4KKKKV^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8F:76#AI+%B)3)#!A/4EY04U^56&2:W>H@X^`F:76K[OLS]P,M+WA>GZ=?H*>"
	"M+WE]P,S^P<W_0DY_PL[`0T]`0T]`@X^`@X^`@X^`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_"
	"`P\\_`P\\_`P\\_`````````````````````````````````````````P\\_`P\\_`P\\_"
	"`P\\_`P\\^`P\\^`P\\^`P\\^`P\\^`P\\]`P\\]`P\\]_PL]_PL]]P,USL[EUMKU_PL]`@X\\"
	"_`P[^`@X]`0S\\/TMZ/4EWNL;TM\\/PL[_K[OLF:76O\\O\\V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8R]@('RM<%\"!1'BI;-D)R0DY_4U^0:G:G@X^`FJ;7L;WNQ-$!"
	"Y/$@GJ;->GZ=>GZ=B(RIVN40_PL[_`P\\`0T]`@X]`@X]`P\\^`P\\^`P\\^`P\\^`P\\^"
	"`P\\^`P\\^`P\\^`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`````````````````P\\_"
	"`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\^`P\\^`P\\]_PL]_PL]^P<U^P<U\\O\\MPL;E"
	"PL+5XNL5_PL]`@X]`@X\\`0T\\_0DY^@8U\\_`PZ_@HX>X>U.$1Q-$!L;WNGZO<U.$1"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@85V.4$AY/'BI;+3EJ0DY_4%R-:'2E@8V^"
	"FJ;7L;WNQ=(\"U>(2Y/$BPLKQ=GJ==GJ5>W^>A8JKX^X;`@X]`@X]`P\\^`P\\^`P\\^"
	"`P\\^`P\\^`P\\^`P\\^`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_"
	"`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\^`P\\^`P\\^`P\\^`P\\]`P\\]_PL]^P<U"
	"]P,U[OLMNK[5NKK0OK[5^P<U_PLU_PL]_PL]`@X]_`P[_@HY^@8V]0$Q[?HJX^`@"
	"U>(2Q=(\"L;WNL;WNV^@8V^@8V^@8V^@8V^@8V^@8V^@8G:G:$!Q-&256)S-D-T-T"
	"2U>(9'\"A?8FZEZ/4K[OLQ-$!V.45Y/$AZ/4FOLKU<G:5<GJ=<GJ5=WN>AHJK]0$S"
	"`0T^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_"
	"`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\^`P\\^`P\\]`P\\]`P\\]`P\\]"
	"_PL]^P<U]P,U]P,UYO,=JJ[)KJ[%MK;-TM;U]P,M_P<U_PL]`P\\]`@X]`@X]_`P\\"
	"_@HZ^P<W]@(R[OLKX^`@UN,3Q-$!K[OLQ]0$V^@8V^@8V^@8V^@8V^@8V^@8.45V"
	"%2%2(2U>,3UN15&\"76F:>(2UDI[/J[?HPL[_U.$1YO,DY_0FW^P>NL+J;G*5<G:5"
	"<G:5=GJ5=WN7D9JZ]O`I`P\\]`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\_`P\\_"
	"`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\_`P\\^`P\\^`P\\]`P\\]"
	"`P\\]`P\\]`P\\]_PL]^P<U]P,U\\O\\MYO,=HJ*]HJ*]KJ[%LK;-YN\\;]O\\M^P<U_PL]"
	"`P\\]`P\\]`@X]`@X]_`P\\_@HZ^P<W]@(R[OLKX^`@U.$1PL[_M<'RV^@8V^@8V^@8"
	"V^@8V^@8E*#1$1U.'\"A9*C9G/DI[56&2<'RMBY?(IK+COLK[TM\\/X>X>ZO<GXN\\<"
	"VN<4OLK]:G*1:G*1;G*-;G*5<GJ5=WN7CY>WZ/(>`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^"
	"`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^"
	"`P\\^`P\\]`P\\]`P\\]`P\\]`P\\]_PL]^P<U]P,U[OLMQL[XEIJUEIJUHJ:]JJ[)PL;E"
	"[OLE\\O\\M]P,U^P<U_PL]`P\\]`P\\]`@X]`@X]`0T]_PL[^P<W]@(R[?HJX>X>TM\\/"
	"OLK[R-4%V^@8V^@8V^@8V^@8/TM\\%R-4(R]@-4%R3%B)9G*C@HZ_GJK;M\\/TS=H*"
	"WNL;Z_@H[OLLXN\\<UN,5TM\\-:FZ-9FJ-:FZ-;G*5<G:5<G:5=WN>@X>GVN<5_`P]"
	"`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]"
	"`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]_PL]^P<U\\O\\M[OLMPL[]@HJECI*M"
	"EIJUHJ:]JJ[)SM;_ZO<E\\O\\M^P<U_PL]`P\\]`P\\]`P\\]`P\\]`P\\^`@X]`0T]_@HZ"
	"^P<W]0$QZ_@HWNL;S=H*O\\O\\V^@8V^@8V^@8KKKK$AY/'2E:+#AI04U^6F:7=X.T"
	"DY_0K[OLQ]0$VN<7Z/4E\\O\\N\\O\\PW.D6TM\\-SML->H*E9FZ.9FJ-:FZ-:FZ-;G*5"
	"<W>6=7J9@H>GK+7<`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]"
	"`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]_PL]^P<U]P,U\\O\\MZO<E"
	"GJ+%?GZ=AX>FCI*MFIZUHJ:]LK;-WNL5ZO<E\\O\\M^P<U_PL]_PL]`P\\]`P\\]`P\\]"
	"`P\\^`P\\^`@X]`0T]_@HZ^@8V\\O\\OZ/4EVN<7Q]0$T=X.V^@8V^@8:'2E%B)3(R]@"
	"-D)S3EJ+:76FAY/$I+#AOLK[T]`0Y/$A\\/TM]`0T\\/TNW^P>TM\\-SML-CI:]8F:&"
	"8F:&9FJ-9FZ.:G*1<G:5<W>6>(\"B?8&ACY.OXN\\<`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]"
	"`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]_PL]^P<U"
	"]P,U[OLMWNL=BI*U>GZ=?H:HBHZLDI:TGIZXIJ:]OL;EWNL=ZO<E\\O\\M^P<U_PL]"
	"_PL]`P\\]`P\\]`P\\]`P\\]`P\\^`P\\^`@X]_`P\\_0DY^04U\\/TMY/$AT]`0RM<'V^@8"
	"V^@8*S=H&R=8*S=H0$Q]6V>8>(2UEJ+3LK[ORM<'WNL;[/DI]@(R^@8V[/DJWNL="
	"TM\\-QM,%KKKM7F:'8F:&8FJ%9FJ-:FZ-:G*1;G:8<W>6=WN7>W^>>GZ=FI[%YN\\;"
	"`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]"
	"`P\\]_PL]^P<U]P,U[OLMLK[M<GJ5=GJ=>GZ=AH:ECI*MEIJUHJ*]JJJ`TML&XN\\<"
	"ZO<E]O\\M^P<U_PL]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\^`P\\^`P\\^`@X^_`P\\^`@X]@(R"
	"[/DIWNL;S-D)V^@8M\\/T%\"!1(2U>,S]P2U>(9W.DAI+#I+#AO\\O\\U>(2YO,C\\O\\O"
	"^@8U^`@W[?HIWNL=TM\\-QM,%PL[]<G:57F*%8F:&8FJ-9FJ-:FZ-;G*-;W..=WN7"
	"=WN>=GZ?>GZ=>H*=FJ+%TM\\-_PL]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]"
	"`P\\]`P\\]`P\\]_PL]^P<U]P,U[OLMTML&BI*U<G:5=GJ5?GZ=@H:EBHZLDI:TGZ\"Z"
	"IZ>^MK[EUN,5XN\\<[OLM^P,U_PL]_PL]`P\\]`P\\]`P\\]`P\\]`P\\^`P\\^`P\\^`P\\^"
	"`@X]`0T]_PL[^@8V\\O\\OYO,CU>(2UN,3B)3%&\"15)S-D/$AY5F*3=(\"QDY_0L+SM"
	"RM<'WNL;[/DI]P,S^`@X_0DX[_PKXN\\<TM\\-RM<$OLK]CIK%6F:-7F*%8F:&8FJ-"
	"9FZ.:FZ-;G*5;G*5<W>6<G:5=WN6=WN6=GJ5=GJ=>W^>HZO.TML&XN\\<`P\\]`P\\]"
	"`P\\]`P\\]`P\\]_PL]_PL]^P<U]P,UZO<ESM;_KK;EAHZM>GZ==GJ=>GZ=?H*=?H:H"
	"AHJEDI*MEIJUGIZXIJJ`QM+]UN,5YO,E\\O\\M^P<U_PL]`P\\]`P\\]`P\\]`P\\]`P\\]"
	"`P\\^`P\\^`P\\^`P\\^`P\\^`@X^_`P\\_0DY]P,S[/DIWNL;U.$186V>'\"A9+3EJ1%\"!"
	"8&R=?XN\\GJK;N\\?XT]`0Y?(B\\?XN^@8V_@HZ_@H[]P,TY/$>TM\\-RM<$NL;UML+U"
	"9FZ.7F*%7F:'7F:'9VN.8FJ-9FZ.:FZ-:G*1:G*1<G:5<G:5<G:5<G:5=WN6='B7"
	";W>9;W.7<'27?X.FGJ;-HJ;)HJK5IJ[5JK+5DI:TBHJEBHJE@H:E@H:E@H:E@H*E"
	"?H:H@H:EAHJEBHZLCHZMEI:UFIZUHJ*]LKKERM<$VN<4ZO<E]P,U^P<U_PL]`P\\]"
	"`P\\]`P\\]`P\\]`P\\]`P\\]`P\\^`P\\^`P\\^`P\\^`P\\^`0T]_PL[^@8V\\?XNY?(BUN,3"
	"1%\"!(\"Q=,S]P3%B):76FB97&J+3EQ-$!VN<7ZO<G]@(R_0DY_PL\\_PL[]`0UYO,@"
	"VN<4RM<$OLK]LK[MFJ;56F*&6F*&7F*%7F*%8F:&8F:&9FJ-8F:&9FJ-:FZ-9FZ."
	"9FZ.:FZ-:FZ-<761<761;765<'2/;W.6<G:5<GJ=?H*=?H*=@H:E@HJEAHJEBHZL"
	"BHJEAHJE@H:EAHJEAHJEBHJEBHZLCHZMEI:UFIZUHJ*]HJ:]JK+5SM;_XN\\<[OLM"
	"]P,U_P<U`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\^`P\\_`P\\^`P\\^`P\\^`@X]_`P\\"
	"_0DY]@(RZO<GVN<7+CIK)#!A.45V4U^0<GZODI[/L;WNS-D)X.T=[_PL^04U_@HZ"
	"_`P[_PL[^04TZO<HW^P>SML-PL[]ML+UJK;E<GJE6F*&7F*%7V.&8&2'7F:+86F+"
	"86F*86F*96F)86F+9FJ+:V^3:W.4;G:7;G:7<'24;765;G*5<GJ5=GJ=?H*=?H:H"
	"@HJEAHZELK;=VN<4]P,U`P\\]]P,MWN<1KK;5BHZLCI*MDI:TEIJUGJ*UTMK]]O\\M"
	"`P\\]]P,U\\O\\M[OLM^P<U_PL]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\^`P\\^`P\\_"
	"`P\\^`P\\^`P\\^`0T]_@HZ^04U[_PLW^P<(BY?*#1E/DI[6F:7>H:WFZ?8N<7VTM\\/"
	"Y?(B\\O\\O^P<W_PL[`0T]_PL[]`0S[?HHW^P=TM\\-PL[]ML+UJK;EHJ[=8F:&5EY_"
	"6U^#666(8&2)8&2(7V>)7V2(666(76&%7V>+96F-8VR0;7&3;7*3<'68;W.3<'B:"
	"<W>6=W^@>X.>@H:EAHZEUM\\%_PL]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]WN<1DI:TEI:U"
	"FIZUYO,=`P\\]`P\\]`P\\]`P\\]`P\\]^P<U^P<U_PL]_PL]`P\\]`P\\]`P\\]`P\\]`P\\]"
	"`P\\]`P\\^`P\\^`P\\^`P\\^`P\\^`P\\^`@X]_PL[^P<W\\O\\OY/$A'\"A9+#AI0T]`8&R="
	"@(R]H:W>O\\O\\U^04Z/4E]0$Q^`@X_`P\\`@X]`0T^^@8X\\/TOYO,EUN,5QM,%NL;U"
	"JK;EHJK5CIK-7F:'5EY_6&\"\"6&&$766)7V>+5U^$4EI^6%Q`6F*#7F*'7V>+9FJ."
	":'\"2<G:;;WB9=7F5=GJ:>'R8?W^>@X>FSML%^P,U_P<U_PL]`P\\]`P\\]`P\\]`P\\]"
	"`P\\]`P\\]XNL5FIJUSM;_`P\\]^P,UTM\\-QM,%VN<4^P<U`P\\][OLM_PL]_PL]`P\\]"
	"_PL]]P,UZO<EW.D6W^P9`P\\]`P\\]`P\\^`P\\^`P\\^`P\\^`@X]_`P\\^`@X]0$QY_0D"
	"'BI;+SML1U.$97&BAI+#IK+CP\\_`V^@8Z_@H]P,S_@HZ`0T]`0T]`0T^_0DX\\_`O"
	"YO,EVN<4SML-NL;UKKKMHJ[=DI[-?HJ\\5U]`5%Q_5EN!5UQ`6E^#5UQ`3U=]3E9["
	"4%A]4UM^5%Q_66&\"9&B,;'&2<7::='B8>7V==7Z9?(2?JK+5[OLE]P,U]P,UYO,="
	"RM<$TM\\-ZO<E_PL]`P\\]`P\\]`P\\]PLKQ\\O\\M`P\\]ML+M,CYK,CYKML+UPL[]`P\\]"
	"]P,MWN<1_PL]_PL]XN\\<AY/%97&@6F:57&B7=H*PPL[]^04W`P\\]`P\\]`P\\^`@X]"
	"`0T]_@HZ]P,SZO<G'RM<,3UN2E:':76FBI;'J[?HQ]0$W>H:[?HJ]`0T_@HZ`0T]"
	"`P\\^`0T^_0DX]`0V[OLMXN\\<TM\\-PL[]LK[MHJ[=CIK-AI+$=H*U4UM^355Z355\\"
	"3%AX3E9\\2T]R35%X3%1Y2E)W4U=]5UM^766)8VN-;G*6<765=WN;>'R8=WN7QL[X"
	"YO,=[OLMSML-:G:D*C9D;GJKGJK=VN<4`P\\]`P\\]`P\\]ZO,?`P\\]`P\\],CYK!A)%"
	"-D)UIK+E5F*5`P\\]`P\\]IJ:]SML%ML+M5F*5)S-F,CYQ0T^\"3%B'35F(7&B;K+CK"
	"]`0V`P\\]`P\\]`P\\^`0T]_@HZ]`0T[/DI(2U>,S]P35F*;'BIC9G*KKKKRM<'X.T="
	"[_PL^04U_PL[`@X]`P\\^`0T^_`P]^04V[OLMYO,EVN<4QM,%ML+UHJ[=EJ+5@HZ]"
	"<GZM9W.F4%A\\3E)Y2U!S1DYR15%X1$QP1T]U2E)W3E9Z3EI]5U]`8&2'96V):7&2"
	"<'27<W>6>GZ=TM\\-WNL=ZO<E?HJ\\#AI--D)UML+UNL;UFJ;5`P\\]_PL]_PL]]P,M"
	"[OLE`P\\]%B)5!A)%\"A9%*C9D'BI=`P\\]]P,MGIZX>GZ=1E*%)S-F,S]L4%R/<'RM"
	"BI;%BI;%9W.F45V0N<7X`P\\]`P\\]`P\\]`@X]_PL[^04U[OLK(BY?-$!Q3UN,;GJK"
	"D)S-L+SMS-D)X>X>\\/TM^@8V_PL[`@X]`P\\^`P\\^_`P]^`@W\\O\\NZO<EWNL=SML-"
	"OLK]KKKMFJ;5AI+$<GZM8V^>5&\"/2%!V1$QP0$QW/TMN0TMO1DYT2DYU2E)W4EI]"
	"5EI]7V.&8V>'9VN.;G*-<GJ5<GJ5RM<$VN<4XN\\<3EJ-!A)%(BY=?HJ\\?HJ\\9G*E"
	"^P<U^P<U^P<U\\O\\MQL[X_PL]9G*E$AY-!A)%$AY-:G:D`P\\]TM;]?H*E3EJ%*C9D"
	"*C9D/TMV7VN=CIK-PL[]RM<$EJ+55F*5<W^N[OLM`P\\]`P\\]`@X]_PL[^@8V[_PL"
	"(BY?-4%R4%R-;WNLD9W.L;WNS=H*XN\\?\\/TM^@8V_PL[`@X]`P\\^`P\\^`P\\^_`P]"
	"^P<V\\O\\MYO,EVN<4RM<$LK[MGJK=BI;%=H*U8V^>4U^.2DYU0DYU0D9M0D9M0DIN"
	"0DIN1DYT2DYU3E)U5EI]5F*%6F*&8FJ%9FZ.:G*1<G:5KK;ESML-VN<46F*5!A)%"
	"!A)%&B95'BI=7FJ<^P<U]P,U]P,UVN,-EI:UVN,-WN<1;GJK0DY]<GZMWNL=WNL5"
	"EIJU6F*&/DI],CYK+CIM/TM^8V^>FJ;5UN,5VN<4IK+E6F:50DY]ZO<E`P\\]`P\\]"
	"`@X]_`P[^P<V[_PL*35F-D)S4%R-<'RMDI[/LK[OS=H*XN\\?\\?XN^P<W_PL[`@X^"
	"`P\\^`P\\^`P\\^_`P^^`@V]P,U[OLMWNL=SML-OLK]JK;EDI[-?HJ\\9W.F4U^.1E*%"
	"0DIN0D9M0DIN0DIN0DIN1DIM1DYT2E)W3E9Z5EY_6EZ\"8F:&9FJ-:FZ-;G*5FI[%"
	"RM<$TM\\-CIK-)C)E!A)%!A)%*C9DHJ[=\\O\\M\\O\\M\\O\\MLKK=DI:TDI:TQL[XZO<E"
	"_PL]ZO<EQL[XCI*M?H*E3EJ-0DY].D9S-T-V.T=T4U^.?XN]IK+EKKKMBI;%4EZ-"
	"-D)ULK[M`P\\]`P\\]`@X]_`P[^`@X\\/TM.$1U-D)S4%R-<'RMDI[/LK[OS=H*XN\\?"
	"\\?XN^P<W_PL[`@X^`P\\^`P\\^`P\\^`0T^_`P]^P<U\\O\\MZO<EWNL=QM,%ML+UGJK="
	"@HZ];GJK6V.60DY]/DIU0DIN0DIN/D9M/DIM0DYU1E)U2E)W3E9Z4E9\\6F*&7F:'"
	"9FJ-;G*-;G*5<G:5GJK=QM,%QM,%DI[-3EJ-4EZ-FJ;5UN,5ZO<E[OLMRM<$CHZM"
	"CHZMBHZLCI*MCI*MBHZLBHJEBHJEAHJE8FJ-4U^.35F(1E*!/DIW.D9X1%!_7FJ<"
	"?HJ\\AI+$;GJK0DY])C)EKKKM_PL]`P\\]`@X]_`P[^`@X[_PL3EJ+-4%R4%R-;WNL"
	"D9W.L;WNS=H*XN\\?\\/TM^@8V_PL[`@X^`P\\^`P\\^`P\\^`P\\^`P\\]^P<V]P,U[OLM"
	"XN\\<TM\\-PL[]JK;EDI[-=X.V6V>61U.&.D)K0DIN/DIU0DIN0DYU1DIM1DYT2E)W"
	"3E9Z4EI]5EY_7F*%8F:&9FZ.:FZ-;G*-=GZ?IJ[5TM\\-UN,5WNL=WNL5WNL=WNL="
	"XN\\<PLKQBHZLBHZLBHZLBHZLBHZLAHJEAHJE@H:E@X>F>W^>6V>776F966644U^."
	"2E:%0T^\"1%!_3EJ-7FJ<9G*E5F*5-D)U*C9DJK;E_PL]_PL]`@X]_`P[^`@WZ_@H"
	":W>H-$!Q3UN,;GJKD)S-L+SMS-D)X>X>\\/TM^@8V_PL[`@X^`P\\^`P\\^`P\\^`P\\^"
	"_`P^`P\\]^P<U]P,U[OLMWNL=SML-ML+UGJK=@HZ]9W.F2U>&-T-V/D9U0DIN0D9M"
	"0DIN0DIN1DYT2DYU3E)U3E9Z4EI]6EZ\"6F*&7F*%9FJ-;G*5;G*5<G:5FJ+%NL+J"
	"TM\\-VN<4RM<$MK[EJK+5@HJEAHJEAHJEAHZEAHZEAHJE@HJE?H:H?W^>>8&B<WN="
	"<7FD;7FH9W.C7VN:5F*51E*!/TM^0DY]2E:%2E:%/DI]*C9D+CIMNL;U_PL]`P\\]"
	"`@X]_`P[^`@WZ?8FCYO,,S]P35F*;'BIC9G*KKKKRM<'X.T=[_PL^04U_PL[`@X^"
	"`P\\_`P\\^`P\\^`P\\_`P\\^`P\\]_PL]^P<U\\O\\MZO<EVN<4PL[]JK;EBI;%;WNL5&\"/"
	".T=T-T-N0DIN0DIN0DIN0D9M1DYT1DYT2E)W3E)U4EI]5EI]2E)W3E9Z8FJ-9FZ."
	":G*1;G*-<G:5<G:5=GZ?=GJ=>GZ=?H*E?H:H?H*E@H:E@H:EAH:EAHJE@H:E?X.>"
	"?(\"?>GZ:=7V@=GJ;>86S>86S=(\"R9W.E6V>:3%B'1U.&0DY]/DI].D9S-D)U)C)E"
	"-D)U\\O\\M_PL]`P\\]`@X]_`P[^P<VY?(BNL;W,3UN2E:':76FBI;'J[?HQ]0$W>H:"
	"[?HJ]`0T_@HZ`0T]`P\\_`P\\^`P\\^`P\\_`P\\^`P\\^_PL]_PL]^P<U[OLMXN\\<TM\\-"
	"ML+UFJ;5>X>V6V>6/TM^*C9D/D9M0DIN0DIN/D9M0D9M1DIM1DYT1E)U4E9\\3E9Z"
	"1DYT/D9M6EZ\"9FJ-9FJ-:G*1;G*5;G*5<G:5=GJ5<GJ==GJ5>GZ=?H*=?GZ=?H*="
	"@X>F?X.>@(2??8&@=W^;<WN;<GN<;G>9@(FT@8V`<W^M:W>J8&R>5V.63EJ-1E*%"
	"0DY].D9S+CIM+CIM=H*U^P<U_PL]`P\\]`@X]_PL[^@8UX.T=V^@815&\"1U.$97&B"
	"AI+#IK+CP\\_`V^@8Z_@H]P,S_@HZ`0T]`@X^`P\\^`P\\^`P\\_`P\\_`P\\^`P\\]_PL]"
	"^P<U]P,UZO<EVN<4PL[]IK+E@HZ]9W.F1E*%+CIM*C9D1DYT1DIU0DIN0DIN0DIN"
	"0DIN1DYT2E)W3E)]2E)W/DIM-CYI8F:&8FJ%9FJ-:FZ-9FZ.;G:8;G*5<G:5<G:5"
	"=GJ==GJ5=W^@>X.>>X.>=W^@>'R8<7F;<'24;G*6;7:2:6Z2>X.N@X_!=8&P<'RM"
	"9W.F7FJ<5F*53EJ-1E*%/DI]-D)U0DY]NL;U^P<U`P\\]`@X]`@X]_PLZ]0$QW>H:"
	"V^@8>86V0T]`8&R=@(R]H:W>O\\O\\U^04Z/4E]0$Q^`@X_`P\\`@X^`P\\_`P\\^`P\\^"
	"`P\\_`P\\^`P\\]`P\\]_PL]^P<U\\O\\MXN\\<RM<$KKKMDI[-;GJK4EZ--D)U(BY=,CYK"
	"0DIN/DIM/DIU/DIM1DIM0DYU2DYU5EY_5F*%2E)W.D)K,CYK7F*%8FJ%8F:&9FJ-"
	"9FJ-:G*1:G*1;G*-;G:8<W>6<W>6<W>6=WN6<W>6:W.29VN/96V(8VN,7VB,7&2%"
	"9V^2A)\"_?XN]=X.V;GJK9G*E7FJ<5F*53EJ-1E*%3EJ-BI;%ZO<E_PL]_PL]_PL]"
	"`0T\\_0DYZO<GW.D9V^@8M<'R/DI[6F:7>H:WFZ?8N<7VTM\\/Y?(B\\O\\O^P<W_PL["
	"`@X^`P\\_`P\\^`P\\^`P\\_`P\\^`P\\^`P\\]`P\\]_PL]\\O\\MYO,EUN,5OLK]GJK=?HJ\\"
	"7FJ</DI]*C9D(BI5.D)K0DIN0DIN0TMO0T=N0TMO1DIM6F:%8FZ=6F:-1E*%,CIE"
	"*C)=3EI]6F*&7F:'8F:&9FJ-8FJ%9FJ-:FZ-:FZ-:FZ-:FZ-;G*5:FZ-8F:&7F*%"
	"7V>(6&\"\"6%Q`55U`5EZ\"?(2RAY/%?XN]>H*P<GZM:G:D8FZ=6F:55F*5@HZ]TM\\-"
	"]P,U_PL]_PL]_`P]_`P[^`@XX>X>V^@8V^@8V^@87VN<4U^0<GZODI[/L;WNS-D)"
	"X.T=[_PL^04U_@HZ`0T]`P\\_`P\\_`P\\^`P\\_`P\\^`P\\^`P\\]`P\\]_PL]^P<U[OLM"
	"WNL=QM,%KK;EBI;%:G*=3EJ--D)U'BI=(BI50TMO0TMO14UQ04UX1$QP1DIU8FJ5"
	"=GZ?:G:D7F*%1DY],CYK)BY=-D)E6EZ\"6F*&7F*%7F*%7F:'8FJ%8F:&8FJ-9FJ-"
	"9FJ-8F:&7F*%6F*&5EI]4UM^4%A\\4%A]4%A]7VN=@X^^AI+$@HZ]=H*U;GJK9G*E"
	":G:DCIK-RM<$]P,U^P<U_PL]_`P]`0T]_PLZ\\_`OW.D9V^@8V^@8V^@8H:W>3%B)"
	":76FB97&J+3EQ-$!VN<7ZO<G]@(R_0DY_`P\\`@X^`P\\^`P\\^`P\\^`P\\^`P\\^`P\\]"
	"`P\\]`P\\]_PL]\\O\\MYO,ETM\\-NL;UFJ;5>H:U7FJ</TM^)S-F&R=6)#!?14UR1TMR"
	"1%!S14UR1%!W3E9Z?H*E?H:H;G:86F*&0DYU,CYK*C)=)BY=+C9E3E9Z6F*&6F*&"
	"6EZ\"5EY_6F*&6F*&7F:'6F*&6EZ\"5EI]5UM^4%Q_4%1X3%1Y3U-V4UM^6F:%;GJK"
	"AI+$?HJ\\>H*PAI+$IK+ETM\\-[OLM]P,U^P<V_`P]_`P]_`P\\_0DYY?(BV^@8V^@8"
	"V^@8V^@8V^@89'\"A8&R=?XN\\GJK;N\\?XT]`0Y?(B\\?XN^@8V_PL[`0T]`P\\^`P\\^"
	"`P\\^`P\\^`P\\]`P\\]`P\\]`P\\]_PL]^P<U[OLMWNL=QM,%KKKMBI;%:W>E3UN.-T-V"
	"(R]>&258(2E904IS1TMR14UR1$QP0TMO:G:D>H:U<GZM9G*=5F*%2DYU.D9S,CIE"
	")C)=)BY=(BY=*C)=.D)K2E)W5EY_4EI]5EY_4EI]4E9\\4UM^3U=[4%A\\3%A_2U-X"
	"4E9\\4EI]7F*%9FJ-:FZ-<G:5HJK-UN,5YO,E[OLM\\O\\M^P<U_PL]_`P]`0T]_PL["
	"\\_`PW.D9V^@8V^@8V^@8V^@8V^@8K+CI5F*3=(\"QDY_0L+SMRM<'WNL;[/DI]P,S"
	"_0DY_`P\\`@X]`P\\^`P\\^`P\\^`P\\]`P\\]`P\\]`P\\]_PL]^P<U\\O\\MYO,ETM\\-NL;U"
	"FJ;5?HJ\\8V^>1U.&,S]L)3%@&R=:'2E<-CYI1$QP2$QW0TMO1DYT<G:5=GJ=<GJE"
	":FZ-7F*%3EJ%1DYT/D9M-CYI*C)=)BY='BI5%B)-%AY-&B95(BI5'B95*C)=-T-F"
	"/$1M/$1M.T-L.D)K.D)K+CIE-D)E1DYT>H*ENL;UWNL=YO,EZO<E\\O\\M]P,U^`@V"
	"_@HX_`P]_`P\\_0DYX^`@V^@8V^@8V^@8V^@8V^@8V^@8V^@8?XN\\9W.DAI+#I+#A"
	"O\\O\\U>(2YO,C\\O\\O^@8V_PL[`0T]`@X]`P\\^`P\\^`P\\]`P\\]`P\\]`P\\]`P\\]_PL]"
	"^P<U[OLMWNL=RM<$LK[MDI[-=X.V6V>61%!_,3UP)C)A&R=:%R-2'2E8.45P0T]N"
	"0DYU0DYU:G*=;G:8;G:8:G*=8FZ=6F*&3EI]0DYU.D9S,CIE*C)=(BY=&B95%AY-"
	"$AY-#QM&#Q=&#QM&$1U($!Q'$QM.%B)-%B)--CYI<GJENL;UTM\\-VN<4XN\\<YO,E"
	"[OLM\\O\\M^`@V_`P]`@X]`0T]_PL[[_PKV^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"S]P,9G*C>(2UEJ+3LK[ORM<'WNL;[/DI]@(R^`@X_`P\\`@X]`P\\^`P\\^`P\\]`P\\]"
	"`P\\]`P\\]`P\\]_PL]^P<U\\O\\MZO<EVN<4QM,%JK;ECIK-<W^N6V>61T]^-$!M*C9I"
	"(R]:&R=:%2%0$Q].(BY=-CYI1DIU4EI]:FZ-:G:D:G:D:FZ-6F:55EY_2U=^/DIM"
	".D9S+SMF*S->'RM6&R=6%2%0%1U0%2%0%2%0'RM6.T=T9G*=GJK=KKKMOLK]RM<$"
	"TM\\-WNL=YO,EZO<E\\O\\N]`0V_0DX`0T^`0T]_`P\\^04UW.D9V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8KKKK:76FAY/$I+#AOLK[T]`0Y/$A\\/TM^04U_0DY_`P\\"
	"`@X]`P\\^`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]^P<U\\O\\MYO,ETM\\-OLK]JK;ECIK-"
	"=X.V7VN=2U>&.45X+CIH)#!C(\"Q;&258$Q].$Q].#QM.(BI5)C)E1DY]6F*&:G*1"
	":G*18FJ56U^#4U=]1T]^/TMN-T-N,#AG+3EG*35@.D9Q15%`8V^><GZM@HZ]EJ+5"
	"IK+=ML+MPL[]SML-VN<4XN\\<ZO<E\\O\\M]`0V_0DX`0T^`0T]_`P\\_0DYY/$AV^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8FZ?8=X.TDY_0K[OLQ]0$VN<7"
	"Z/4E\\O\\O^@8V_@HZ`0T]`@X]`P\\^`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]_PL]^P<U\\O\\M"
	"XN\\<TM\\-OLK]IK+ECIK-=H*U8V^>3UN.1%!_.D9X,S]Q)S-B(R]B'2E8&\"17$Q]."
	"$AY-$AY-$AY-$AY-$AY-#AI-$AY-%R-6&R=6&B95'RM>)S-F-$!M0$Q_3%B'6V>7"
	":W>E>H:UCIK-GJK=KKKMOL;RRM<$VN<4XN\\<ZO<E[OLM]`0V_0DX`0T^`@X]_`P]"
	"_@HZZ?8FV^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8E*#1"
	"@HZ_GJK;M\\/TS=H*WNL;Z_@H]0$Q^P<W_@HZ`0T]`@X]`P\\]`P\\]`P\\]`P\\]`P\\]"
	"`P\\]_PL]_PL]]P,U[OLMXN\\<UN,5OLK]JK;EEJ+5@HZ]<GZM7VN=4%R/15%`/4EW"
	"-D)O,CII*35H*#1G(R]>'BI='BI='BI='BI='BI='BI=(BY=(BY=*C9D+CIM-D)U"
	"/DI]3U>&6V.6:G:D=H*UBI;%FJ;5KKKMNL;URM<$UN,5WNL=YO,E[_PM]`0V_0DX"
	"_PLZ`0T]_`P]_@HZ[?HJV^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8E*#1BY?(IK+COLK[TM\\/X>X>[?HJ]@(R^P<W_PL[`0T]`@X]"
	"`@X]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]^P<U]P,U\\O\\MYO,EUN,5QM,%ML+UHJ[=DI[-"
	"?HJ\\;WNL8V^>6&274%R/2%2'1%!_/$AU.$1W-T-V-T-V,S]L,CYK,CYK-D)U-D)U"
	"-D)U/DI]0DY]2E:%4EZ-8FZ=;GJK?HJ\\BI;%GJK=KKKMOL;RQM,%UN,5WNL=YO,E"
	"[_PN^04V_0DX_`P]`0T]`0T]_PL[[_PLV^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8FJ;7DI[/J[?HPL[_U.$1X^`@[OLK"
	"]@(R^P<W_@HZ_`P\\`@X]`@X]`P\\]`P\\]`P\\]`P\\]`P\\]`P\\]_PL]]P,U[OLMYO,E"
	"VN<4RM<$OLK]KKKMGJK=DI[-AI+$>H:U;GJK9W.F7VN=6V>65V.64U^.3EJ-4EZ-"
	"3EJ-3EJ-4EZ-4EZ-5F*56F:57FJ<9G*E<GZM>H:UBI;%EJ+5HJ[=LK[MOLK]SML-"
	"UN,5XN\\<Z_@F\\_`N^04W_@HX_`P]`0T]_PL\\_@HZ[_PLV^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8I+#AEZ/4"
	"K[OLQ-$!UN,3X^`@[OLK]@(R^P<W_@HZ`0T\\`@X]`@X]`P\\]`P\\]`P\\]`P\\]`P\\]"
	"_PL]_PL]^P<U]P,UZO<EXN\\<VN<4RM<$OLK]ML+UJK;EGJK=EJ+5CIK-@HZ]?HJ\\"
	">H:U=H*U<GZM<GZM<W^N<GZM=H*U<GZM=H*U>H:U?HJ\\AI+$CIK-FJ;5HJ[=KKKM"
	"NL;UQM,%SML-VN<4X^`=[_PN\\?XO^@8W^`@Y_`P]_`P]_PL\\_@HZ[?HJV^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8L;WNFJ;7L;WNQ=(\"U>(2X^`@[?HJ]0$Q^@8V_@HY_`P[`@X]`@X]"
	"`@X]`P\\]`P\\]`P\\]`P\\]_PL]_PL]^P<U]P,U\\O\\MYO,EXN\\<VN<4SML-QM,%OLK]"
	"ML+UKKKMJK;EHJ[=GJK=FJ;5FJ;5FJ;5EJ+5FJ;5EJ+5FJ;5FJ;5GJK=HJ[=JK;E"
	"KKKMML+UPL[]RM<$TM\\-VN<4XN\\<Z_@F]0$O]@(Q_0DX_`P]`0T]_`P]_PL[_0DY"
	"Z/4EV^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8PL[_H:W>L;WNQ-$!U.$1X>X>Z_@H\\_`P"
	"^@8U_0DY_`P[`0T\\`@X]`@X]`@X]`P\\]`P\\]`P\\]`P\\]_PL]_PL]^P<U]P,U\\O\\M"
	"[OLMYO,EXN\\<VN<4TM\\-SML%QM,%PL[]OLK]OLK]OLK]NL;UNL;UNL;UNL;UOLK]"
	"OLK]PL[]PL[]QM,%RM<$TM\\-UN,5WNL=X^`=Z_@F\\_`O^04W^@8X_@HY_`P]_`P]"
	"_PL\\_PL[]`0TX^`@V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8UN,3L;WNK[OL"
	"PL[_TM\\/WNL;Z/4E\\?XN]`0T_0DX_PLZ`0T\\`@X]`@X]`@X]`@X]`@X]`P\\]`P\\]"
	"`P\\]_PL]_PL]^P<U]P,U\\O\\M[OLMZO<EYO,EXN\\<XN\\<WNL=VN<4VN<4UN,5VN<4"
	"VN<4VN<4VN<4UN,5VN<4VN<4VN<4WNL=XN\\<YO,EZO<F[_PN\\_`O^04W^@8W_@HX"
	"_`P]_`P]_`P]_PL[_0DY[OLKW.D9V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8Q=(\"LK[OOLK[S=H*VN<7Y?(B[OLK]@(Q^@8V_0DY_`P[`0T\\`@X\\"
	"`@X]`@X]`@X]`@X]`@X]`P\\]`P\\]_PL]_PL]_PL]^P<U^P<U]P,U]P,U\\O\\M[OLM"
	"[OLM[OLMZO<E[OLMZO<EZO<EZO<EZO<E[OLM[OLM[OLM\\O\\M\\O\\N]`0U]`0V^`@W"
	"_0DW_`P]_`P]`0T]_PL\\_PL[_@HZ]@(RY/$AV^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8PL[_NL;WQ]0$U>(2W^P<Z?8F\\?XN"
	"]P,S^P<W_@HY_`P[`0T\\`0T\\`@X]`@X]`@X]`@X]`@X]`@X]`@X]`P\\]`P\\]_PL]"
	"_PL]^P<U^P<U^P<U^P<U^P<U^P<U^P<U^P<U^P<U^P<U^P<U^P<U]P,U^P<U^P<V"
	"^`@V_0DW_`P]_`P]_`P]`0T]_`P\\_PL[_@HZ^04UZ/4EV^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V>86QM,#"
	"PL[_S=H*V.45X^`@Z_@H\\?XN]P,R^@8V_0DX_PLZ_PL[_`P[`0T\\`@X]`@X]`@X]"
	"`@X]`@X]`@X]`@X]`@X]`@X]`P\\]`P\\]_PL]_PL]_PL]_PL]_PL]`P\\]_PL]`@X]"
	"_PL]_PL]`@X]_`P]`@X]`0T]`0T]_`P\\_PL[_@HZ_0DY]`0TZ/4EV^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8S=H*R-4%S]P,VN<7XN\\?ZO<G\\/TM]0$Q]`0S^P<V^`@X"
	"_0DY_PLZ_`P[_`P[`0T\\`0T\\`@X]`@X]`@X]`@X]`@X]`@X]`@X]`@X]`@X]`@X]"
	"`@X]`@X]`@X]`@X]`@X]`@X]`0T\\`0T\\_`P[_PL[_@HZ^`@X^P<W\\/TMY/$AV^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8U>(2S]P,T=X.V>86X.T="
	"Y_0D[/DI\\/TM\\_`P]P,S^04U^@8V^`@X_0DY_@HZ_PL[_`P\\`0T]`0T]`@X^`@X^"
	"`@X^`@X^`@X^`@X^`@X^`@X^`0T]`0T]_`P\\_PL[_@HZ_0DY^P<W^04U\\?XNY_0D"
	"WNL;V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8U^04U.$1U>(2V^@8X.T=Y?(BZ?8F[?HJ\\/TM\\O\\O]@(R]P,S]`0T^@8V"
	"^P<W^`@X_0DY_@HZ_@HZ_PL[_PL[_PL[_@HZ_@HZ^`@X^`@X^@8V]`0T\\O\\O[/DI"
	"Y/$AW>H:V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V>86V.45V>86W.D9W^P<XN\\?"
	"Y?(BZ?8FZ_@H[?HJ[_PL\\?XN\\O\\O\\_`P]0$Q]0$Q]0$Q\\_`P\\?XN[OLKZO<GYO,C"
	"X.T=W>H:V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8W.D9W>H:WNL;W^P<W^P<W^P<WNL;"
	"WNL;WNL;W>H:V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"W.D9W.D9W.D9W.D9W.D9V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8"
	"V^@8V^@8V^@8V^@8V^@8V^@8V^@8V^@8";
