package netfu.selectors;

import java.awt.*;

public class GLimitedInteger extends Panel implements Selector {

    private Scrollbar scrollbar;
    private Label valueLabel, minLabel, maxLabel;
    
    public GLimitedInteger (int min, int max) {
	valueLabel = new Label ("" + 1);
	scrollbar = new Scrollbar (Scrollbar.HORIZONTAL, 1, 20, min, max);
	minLabel = new Label ("" + min);
	maxLabel = new Label ("" + max);
/*	this.setLayout (new BorderLayout ());
	this.add ("North", valueLabel);
	this.add ("West", minLabel);
	this.add ("Center", scrollbar);
	this.add ("East", maxLabel);
	this.show (); */
	GridBagLayout gridbag = new GridBagLayout ();
	this.setLayout (gridbag);
	GridBagConstraints valueLabelConstraints = new GridBagConstraints();
	valueLabelConstraints.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints (valueLabel, valueLabelConstraints); 
	this.add (valueLabel);
	this.add (minLabel);
	GridBagConstraints scrollbarConstraints = new GridBagConstraints();
	scrollbarConstraints.fill = GridBagConstraints.HORIZONTAL;
	scrollbarConstraints.anchor = GridBagConstraints.CENTER;
	scrollbarConstraints.gridwidth = 3; 
	scrollbarConstraints.weightx = 3;
	scrollbarConstraints.ipadx = 40;
	gridbag.setConstraints (scrollbar, scrollbarConstraints);
	this.add (scrollbar);	
	GridBagConstraints maxLabelConstraints = new GridBagConstraints ();
	maxLabelConstraints.anchor = GridBagConstraints.EAST;
	gridbag.setConstraints (maxLabel, maxLabelConstraints);
	this.add (maxLabel); 
    }

    public boolean handleEvent (Event e) {
	if (e.target == scrollbar) {
	    valueLabel.setText ((String)selectedValue());
	    return true;
	} else {
	    return super.handleEvent (e);
	}
    }
	    
    
    public Object selectedValue () {
	return new String ("" + scrollbar.getValue ()); }

    public void selectValue (Object o) {
	scrollbar.setValue ( ((Integer)o).intValue ());
    }

    public Component component () { return this; }

}
