{$ASMMODE intel}

  { Restores screen to the original state }

  function Driver_Restore_Mode: boolean;
  begin
    asm
      mov ax, $0003
      int $10
    end;
    Driver_Restore_Mode := True;
  end;

  function Driver_Set_Graphics( mode : Int ) : boolean;
  var
    rc : Int;
  begin
    Driver_Set_Graphics := False;

    rc := 0;

    case Mode of

      Graphics_Mode_Mono : begin
                             asm
                               mov ax, $0012
                               int $10
                             end;
                             Vio_ScanLineWidth := 80;
                             Vio_Width         := 640;
                             Vio_Height        := 480;
                           end;

      Graphics_Mode_Gray : begin
                             asm
                               mov ax, $0013
                               int $10
                             end;
                             Vio_ScanLineWidth := 320;
                             Vio_Width         := 320;
                             Vio_Height        := 200;

                             (* default gray palette takes the gray levels *)
                             (* the standard VGA 256 colors mode           *)

                             gray_palette[0] := 0;
                             gray_palette[1] := 23;
                             gray_palette[2] := 27;
                             gray_palette[3] := 29;
                             gray_palette[4] := 31;
                           end;
    else
      rc := -1;
    end;

    if rc <> 0 then exit;

    Vio := Ptr(SegA000,0);

    Driver_Set_Graphics := True;
  end;


  procedure Driver_Display_Bitmap ( var buff; line, col : Int ); assembler;
  asm
    push ds
    push ebp

    mov edi, [Vio]

    cld

    mov ecx,[Vio_ScanLineWidth]
    mov ebx,[col]
    mov eax,[line]
    dec eax
    mul ecx
    add edi,eax
    mov edx,[line]

    mov esi,[Buff]

    mov ebp,ebx
    add ebx,ecx

   @1:
    mov ecx,ebp
    rep movsb
    sub edi,ebx
    dec edx
    jnz @1

    pop ebp
    pop ds
  end;


