/*
 * ttf2tfm.h
 *
 * This file is part of the ttf2pk package.
 *
 * Copyright 1997-1998 by
 *    Frederic Loyer <loyer@ensta.fr>
 *    Werner Lemberg <a7971428@unet.univie.ac.at>
 */

#ifndef TTF2TFM_H
#define TTF2TFM_H

#include <stdio.h>

struct encoding
{
  char *name;
  char *vec[256];
};


/*
 *   This is what we store character data in.
 */

struct ttfinfo
{
  struct ttfinfo *next;
  long charcode;                /* the TTF character code (or glyph index */
                                /* if bit 17 is set)                      */
  int glyphindex;               /* the TTF glyph number */
  short incode;                 /* the code position in the raw TeX font */
  short outcode;                /* the code position in the virtual font */
  char *adobename;

  short width;
  short llx, lly, urx, ury;

  struct lig *ligs;
  struct kern *kerns;
  struct ttfptr *kern_equivs;
  struct pcc *pccs;                 /* we use the composite feature for */
                                    /* `germandbls' <--> `SS' only      */
  unsigned char wptr, hptr, dptr, iptr;
};


struct lig
{
  struct lig *next;
  char *succ, *sub;
  short op, boundleft;
};


struct kern
{
  struct kern *next;
  char *succ;
  int delta;
};


struct ttfptr
{
  struct ttfptr *next;
  struct ttfinfo *ch;
};


struct pcc
{
  struct pcc *next;
  char *partname;
  int xoffset, yoffset;
};


struct Font
{
  char ttfname[200];
  char *real_ttfname;       /* the complete font name with path */
  FILE *ttfin;

  char outname[200];        /* only namestem without extension */
  FILE *vplout;
  FILE *tfmout;

  /* The input encoding maps from the TrueType font the raw TeX font. */

  char *inencname;                  /* name of input encoding file */
  struct encoding *inencoding;      /* the input encoding vector */
  struct ttfinfo *inencptrs[256];   /* the input mapping table.  Will be
                                       filled initially with the first
                                       256 characters in the selected
                                       cmap of the TrueType font */

  /* The output encoding maps from the raw TeX font to the virtual font. */

  char *outencname;                 /* name of outout encoding file */
  struct encoding *outencoding;     /* the output encoding vector */
  struct ttfinfo *outencptrs[256];  /* the output mapping table */
  int nextout[256];                 /* for characters encoded multiple times
                                       in output */

  struct ttfinfo *charlist;         /* a linked list of all valid chars */

  struct ttfinfo *uppercase[256];   /* needed for small caps fonts */
  struct ttfinfo *lowercase[256];   /* ditto */

  int boundarychar;                 /* the boundary character */
  char *fontname;                   /* fontname for TeX */
  char *codingscheme;               /* coding scheme for TeX */
  char titlebuf[500];

  /* we get the following three values from the TTF's postscript table */

  int units_per_em;
  double italicangle;
  char fixedpitch;

  int pid;                          /* the TTF platform ID */
  int eid;                          /* the TTF encoding ID */

  int xheight;                      /* xheight for TeX */
  int fontspace;                    /* font space for TeX */

  /* these values can be specified on the command line */

  double efactor;                   /* to extend the glyphs horizontally */
  double slant;                     /* to slant the font */
  double capheight;                 /* the height of small caps glyphs */

  /* the command line parameter strings */

  char *efactorparam;
  char *slantparam;
  char *pidparam;
  char *eidparam;
};

#endif /* TEX2TFM_H */


/* end */
