/*
 * tfmaux.h
 *
 * This file is part of the ttf2pk package.
 *
 * Copyright 1997-1998 by
 *    Frederic Loyer <loyer@ensta.fr>
 *    Werner Lemberg <a7971428@unet.univie.ac.at>
 */

#ifndef TFMAUX_H
#define TFMAUX_H

#define FIXFACTOR (0x100000L)   /* 2^{20}, the unit fixnum */


struct ttfinfo *revlist(struct ttfinfo *p);
long scale(long what);

void remap(long *what, int oldn, int newn, int *source, int *unsort);

void write16(short what, FILE *out);
void writearr(long *p, int n, FILE *out);
void writesarr(long *p, int n, FILE *out);

void makebcpl(long *p, char *s, int n);

long checksum(struct ttfinfo **array);

int transform(int x, int y, float ef, float sl);

void buildtfm(struct Font *fnt);
void writetfm(FILE *out);

#endif /* TFMAUX_H */


/* end */
