/*
 *   filesrch.c
 *
 *   This file is part of the ttf2pk package.
 *
 * Copyright 1997-1998 by
 *     Frederic Loyer <loyer@ensta.fr>
 *     Werner Lemberg <a7971428@unet.univie.ac.at>
 */


/* interface to the system specific TeX file search routines */


#ifdef HAVE_KPATHSEA

#include "kpathsea/kpathsea.h"


extern char *kpathsea_version_string;

/*
 *  initialize kpathsea library; arguments are the full program name and
 *  an identification string.
 */

void TeX_search_init(char *program_name, char *identifier)
{
  kpse_set_progname(program_name);
  kpse_init_prog(identifier, 300, "cx", "cmr10");

  xputenv_int("KPATHSEA_DPI", 300);
}


char *TeX_search_version(void)
{
  return kpathsea_version_string;
}


char *TeX_search_tfm(char *name)
{
  return kpse_find_file(name, kpse_tfm_format, true);
}


char *TeX_search_encoding_file(char *name)
{
  return kpse_find_file(name, kpse_tex_ps_header_format, true);
}


char *TeX_search_config_file(char *name)
{
  return kpse_find_file(name, kpse_dvips_config_format, true);
}


char *TeX_search_ttf_file(char *name)
{
  return kpse_find_file(name, kpse_type1_format, true);
}

#endif /* HAVE_KPATHSEA */


/* end */
